/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.visit;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.NonBlockingStack;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSKeyframesBlock;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.ICSSExpressionMember;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.visit.ICSSUrlVisitor;
import com.helger.css.decl.visit.ICSSVisitor;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSVisitorForUrl
implements ICSSVisitor {
    private final ICSSUrlVisitor m_aVisitor;
    private final NonBlockingStack<ICSSTopLevelRule> m_aTopLevelRule = new NonBlockingStack();

    public CSSVisitorForUrl(@Nonnull ICSSUrlVisitor iCSSUrlVisitor) {
        this.m_aVisitor = (ICSSUrlVisitor)ValueEnforcer.notNull((Object)iCSSUrlVisitor, (String)"Visitor");
    }

    @Nonnull
    public ICSSUrlVisitor getVisitor() {
        return this.m_aVisitor;
    }

    @Override
    public void begin() {
        this.m_aVisitor.begin();
    }

    @Override
    public void onImport(@Nonnull CSSImportRule cSSImportRule) {
        this.m_aVisitor.onImport(cSSImportRule);
    }

    @Override
    public void onNamespace(@Nonnull CSSNamespaceRule cSSNamespaceRule) {
    }

    @Override
    public void onDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        ICSSTopLevelRule iCSSTopLevelRule = this.m_aTopLevelRule.isEmpty() ? null : (ICSSTopLevelRule)this.m_aTopLevelRule.peek();
        CSSExpression cSSExpression = cSSDeclaration.getExpression();
        for (ICSSExpressionMember iCSSExpressionMember : cSSExpression.getAllMembers()) {
            if (!(iCSSExpressionMember instanceof CSSExpressionMemberTermURI)) continue;
            CSSExpressionMemberTermURI cSSExpressionMemberTermURI = (CSSExpressionMemberTermURI)iCSSExpressionMember;
            this.m_aVisitor.onUrlDeclaration(iCSSTopLevelRule, cSSDeclaration, cSSExpressionMemberTermURI);
        }
    }

    @Override
    public void onBeginStyleRule(@Nonnull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule.push((Object)cSSStyleRule);
    }

    @Override
    public void onStyleRuleSelector(@Nonnull CSSSelector cSSSelector) {
    }

    @Override
    public void onEndStyleRule(@Nonnull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginPageRule(@Nonnull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule.push((Object)cSSPageRule);
    }

    @Override
    public void onEndPageRule(@Nonnull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule.push((Object)cSSFontFaceRule);
    }

    @Override
    public void onEndFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginMediaRule(@Nonnull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule.push((Object)cSSMediaRule);
    }

    @Override
    public void onEndMediaRule(@Nonnull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule.push((Object)cSSKeyframesRule);
    }

    @Override
    public void onBeginKeyframesBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginViewportRule(@Nonnull CSSViewportRule cSSViewportRule) {
        this.m_aTopLevelRule.push((Object)cSSViewportRule);
    }

    @Override
    public void onEndViewportRule(@Nonnull CSSViewportRule cSSViewportRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginSupportsRule(@Nonnull CSSSupportsRule cSSSupportsRule) {
        this.m_aTopLevelRule.push((Object)cSSSupportsRule);
    }

    @Override
    public void onEndSupportsRule(@Nonnull CSSSupportsRule cSSSupportsRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onUnknownRule(@Nonnull CSSUnknownRule cSSUnknownRule) {
    }

    @Override
    public void end() {
        this.m_aVisitor.end();
    }
}

