/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.CSSPropertyEnum;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyEnums
extends CSSPropertyEnum {
    private final int m_nMinNumbers;
    private final int m_nMaxNumbers;

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, n, n2, stringArray);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, n, n2, stringArray);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, stringArray);
        ValueEnforcer.isGT0((int)n, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)n2, (String)"MaxNumbers");
        if (n2 < n) {
            throw new IllegalArgumentException("MaxNumbers (" + n2 + ") must be >= MinNumbers (" + n + ")");
        }
        this.m_nMinNumbers = n;
        this.m_nMaxNumbers = n2;
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, n, n2, iterable);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, n, n2, iterable);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, iterable);
        ValueEnforcer.isGT0((int)n, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)n2, (String)"MaxNumbers");
        if (n2 < n) {
            throw new IllegalArgumentException("MaxNumbers (" + n2 + ") must be >= MinNumbers (" + n + ")");
        }
        this.m_nMinNumbers = n;
        this.m_nMaxNumbers = n2;
    }

    @Override
    public int getMinimumArgumentCount() {
        return this.m_nMinNumbers;
    }

    @Override
    public int getMaximumArgumentCount() {
        return this.m_nMaxNumbers;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray((CharSequence)string.trim(), (String)"\\s+");
        if (stringArray.length < this.m_nMinNumbers || stringArray.length > this.m_nMaxNumbers) {
            return false;
        }
        for (String string2 : stringArray) {
            if (super.isValidValue(string2.trim())) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnums getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyEnums(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.m_nMinNumbers, this.m_nMaxNumbers, this.directGetEnumValues());
    }

    @Override
    @Nonnull
    public CSSPropertyEnums getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyEnums(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.m_nMinNumbers, this.m_nMaxNumbers, this.directGetEnumValues());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CSSPropertyEnums cSSPropertyEnums = (CSSPropertyEnums)object;
        return this.m_nMinNumbers == cSSPropertyEnums.m_nMinNumbers && this.m_nMaxNumbers == cSSPropertyEnums.m_nMaxNumbers;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_nMinNumbers).append(this.m_nMaxNumbers).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("minNumbers", this.m_nMinNumbers).append("maxNumbers", this.m_nMaxNumbers).toString();
    }
}

