/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.Token;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class LoggingCSSParseErrorHandler
implements ICSSParseErrorHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingCSSParseErrorHandler.class);
    private static final int TOKEN_EOF = 0;
    private final ICSSParseErrorHandler m_aNestedErrorHandler;

    public LoggingCSSParseErrorHandler() {
        this(null);
    }

    public LoggingCSSParseErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        this.m_aNestedErrorHandler = iCSSParseErrorHandler;
    }

    @Nonnull
    @Nonempty
    public static String createLoggingStringParseError(@Nonnull ParseException parseException) {
        if (parseException.currentToken == null) {
            return parseException.getMessage();
        }
        return LoggingCSSParseErrorHandler.createLoggingStringParseError(parseException.currentToken, parseException.expectedTokenSequences, parseException.tokenImage, null);
    }

    @Nonnull
    @Nonempty
    public static String createLoggingStringParseError(@Nonnull Token token, @Nonnull int[][] nArray, @Nonnull String[] stringArray, @Nullable Token token2) {
        ValueEnforcer.notNull((Object)token, (String)"LastValidToken");
        ValueEnforcer.notNull((Object)nArray, (String)"ExpectedTokenSequencesVal");
        ValueEnforcer.notNull((Object)stringArray, (String)"TokenImageVal");
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int[] nArray2 : nArray) {
            if (n < nArray2.length) {
                n = nArray2.length;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            for (int n2 : nArray2) {
                stringBuilder.append(' ').append(stringArray[n2]);
            }
        }
        Object object = new StringBuilder(1024);
        ((StringBuilder)object).append('[').append(token.next.beginLine).append(':').append(token.next.beginColumn).append(']');
        if (token2 != null) {
            ((StringBuilder)object).append("-[").append(token2.endLine).append(':').append(token2.endColumn).append(']');
        }
        ((StringBuilder)object).append(" Encountered");
        Token token3 = token.next;
        for (int i = 0; i < n; ++i) {
            ((StringBuilder)object).append(' ');
            if (token3.kind == 0) {
                ((StringBuilder)object).append(stringArray[0]);
                break;
            }
            ((StringBuilder)object).append("text '").append(token3.image).append("' corresponding to token ").append(stringArray[token3.kind]);
            token3 = token3.next;
        }
        ((StringBuilder)object).append(". ");
        if (token2 != null) {
            ((StringBuilder)object).append("Skipped until token ").append(token2).append(". ");
        }
        ((StringBuilder)object).append(nArray.length == 1 ? "Was expecting:" : "Was expecting one of:").append((CharSequence)stringBuilder);
        return ((StringBuilder)object).toString();
    }

    @Override
    public void onCSSParseError(@Nonnull Token token, @Nonnull int[][] nArray, @Nonnull String[] stringArray, @Nullable Token token2) throws ParseException {
        s_aLogger.warn(LoggingCSSParseErrorHandler.createLoggingStringParseError(token, nArray, stringArray, token2));
        if (this.m_aNestedErrorHandler != null) {
            this.m_aNestedErrorHandler.onCSSParseError(token, nArray, stringArray, token2);
        }
    }

    @Nonnull
    @Nonempty
    public static String createLoggingStringUnexpectedRule(@Nonnull Token token, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        return "[" + token.beginLine + ":" + token.beginColumn + "] Unexpected rule '" + string + "': " + string2;
    }

    @Override
    public void onCSSUnexpectedRule(@Nonnull Token token, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) throws ParseException {
        s_aLogger.warn(LoggingCSSParseErrorHandler.createLoggingStringUnexpectedRule(token, string, string2));
        if (this.m_aNestedErrorHandler != null) {
            this.m_aNestedErrorHandler.onCSSUnexpectedRule(token, string, string2);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).toString();
    }
}

