/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSExpressionMathMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberMathProduct
implements ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final List<ICSSExpressionMathMember> m_aMembers = new ArrayList<ICSSExpressionMathMember>();
    private CSSSourceLocation m_aSourceLocation;

    @Nonnull
    public CSSExpressionMemberMathProduct addMember(@Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        ValueEnforcer.notNull((Object)iCSSExpressionMathMember, (String)"ExpressionMathMember");
        this.m_aMembers.add(iCSSExpressionMathMember);
        return this;
    }

    @Nonnull
    public CSSExpressionMemberMathProduct addMember(@Nonnegative int n, @Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSExpressionMathMember, (String)"ExpressionMathMember");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add(iCSSExpressionMathMember);
        } else {
            this.m_aMembers.add(n, iCSSExpressionMathMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(iCSSExpressionMathMember));
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllMembers() {
        if (this.m_aMembers.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSExpressionMathMember> getAllMembers() {
        return CollectionHelper.newList(this.m_aMembers);
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder();
        for (ICSSExpressionMathMember iCSSExpressionMathMember : this.m_aMembers) {
            stringBuilder.append(iCSSExpressionMathMember.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct = (CSSExpressionMemberMathProduct)object;
        return this.m_aMembers.equals(cSSExpressionMemberMathProduct.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

