/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import com.helger.css.ECSSSpecificationStatus;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSSpecification implements IHasID<String>
{
    CSS3_COLOR("css3-color", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2011/REC-css3-color-20110607/"),
    CSS3_NAMESPACE("css3-namespace", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2011/REC-css3-namespace-20110929/"),
    SELECTORS("selectors", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2011/REC-css3-selectors-20110929/"),
    CSS2("CSS2", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/CSS2/"),
    CSS1("CSS1", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/CSS1/"),
    CSS_PRINT("css-print", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2013/NOTE-css-print-20130314/"),
    CSS3_MEDIAQUERIES("css3-mediaqueries", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2012/REC-css3-mediaqueries-20120619/"),
    CSS_STYLE_ATTR("css-style-attr", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2013/REC-css-style-attr-20131107/"),
    CSS3_BACKGROUND("css3-background", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2012/CR-css3-background-20120724/"),
    CSS3_CONDITIONAL("css3-conditional", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2013/CR-css3-conditional-20130404/"),
    CSS3_IMAGES("css3-images", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2012/CR-css3-images-20120417/"),
    CSS3_MULTICOL("css3-multicol", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2011/CR-css3-multicol-20110412/"),
    CSS3_SPEECH("css3-speech", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2012/CR-css3-speech-20120320/"),
    CSS3_VALUES("css3-values", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2013/CR-css3-values-20130730/"),
    CSS3_FLEXBOX("css3-flexbox", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2014/WD-css-flexbox-1-20140925/"),
    CSS_TEXT_DECOR_3("css-text-decor-3", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2013/CR-css-text-decor-3-20130801/"),
    CSS3_CASCADE("css3-cascade", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2013/CR-css-cascade-3-20131003/"),
    CSS3_FONTS("css3-fonts", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2013/CR-css-fonts-3-20131003/"),
    CSS3_WRITING_MODES("css3-writing-modes", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2014/CR-css-writing-modes-3-20140320/"),
    CSS_SHAPES("css-shapes-1", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2014/CR-css-shapes-1-20140320/"),
    CSS_MASKING("css-masking", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2014/CR-css-masking-1-20140826/"),
    CSS_MOBILE("css-mobile", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2014/NOTE-css-mobile-20141014/"),
    CSS3_ANIMATIONS("css3-animations", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2013/WD-css3-animations-20130219/"),
    WEB_ANIMATIONS("web-animations", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2014/WD-web-animations-20140605/"),
    CSS_COUNTER_STYLES_3("css-counter-styles-3", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2014/WD-css-counter-styles-3-20140826/"),
    CSS3_TEXT("css3-text", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2013/WD-css-text-3-20131010/"),
    CSS3_BREAK("css3-break", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2014/WD-css3-break-20140116/"),
    CSS3_TRANSFORMS("css3-transforms", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2013/WD-css-transforms-1-20131126/"),
    CSS3_TRANSITIONS("css3-transitions", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2013/WD-css3-transitions-20131119/"),
    CSS_VARIABLES("css-variables", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2014/WD-css-variables-1-20140506/"),
    COMPOSITING("compositing", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2014/CR-compositing-1-20140220/"),
    CSS3_SYNTAX("css3-syntax", ECSSSpecificationStatus.REFINING),
    CSS_WILL_CHANGE_1("css-will-change-1", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2014/WD-css-will-change-1-20140429/"),
    CSS3_ALIGN("css3-align", ECSSSpecificationStatus.REVISING, "http://www.w3.org/TR/2013/WD-css3-align-20130514/"),
    CSS3_GRID_LAYOUT("css3-grid-layout", ECSSSpecificationStatus.REVISING, "http://www.w3.org/TR/2014/WD-css-grid-1-20140513/"),
    CSS3_PAGE("css3-page", ECSSSpecificationStatus.REVISING, "http://www.w3.org/TR/2013/WD-css3-page-20130314/"),
    CSS3_UI("css3-ui", ECSSSpecificationStatus.REVISING, "http://www.w3.org/TR/2012/WD-css3-ui-20120117/"),
    CSSOM_VIEW("cssom-view", ECSSSpecificationStatus.REVISING, "http://www.w3.org/TR/2013/WD-cssom-view-20131217/"),
    SELECTORS4("selectors4", ECSSSpecificationStatus.REVISING, "http://www.w3.org/TR/2013/WD-selectors4-20130502/"),
    CSS4_BACKGROUND("css4-background", ECSSSpecificationStatus.EXPLORING),
    CSS_DEVICE_ADAPT("css-device-adapt", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2011/WD-css-device-adapt-20110915/"),
    CSS3_EXCLUSIONS("css3-exclusions", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2013/WD-css3-exclusions-20130528/"),
    FILTER_EFFECTS("filter-effects", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2014/WD-filter-effects-1-20141125/"),
    CSS3_GCPM("css3-gpcm", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2014/WD-css-gcpm-3-20140513/"),
    PAGE_FLOATS("page-floats", ECSSSpecificationStatus.EXPLORING),
    CSS3_LAYOUT("css3-layout", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2011/WD-css3-layout-20111129/"),
    CSS3_SIZING("css3-sizing", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2012/WD-css3-sizing-20120927/"),
    CSS_LINE_GRID("css-line-grid", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2014/WD-css-line-grid-1-20140916/"),
    CSS3_LISTS("css3-lists", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2014/WD-css-lists-3-20140320/"),
    CSS3_POSITIONING("css3-positioning", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2012/WD-css3-positioning-20120207/"),
    CSS3_REGIONS("css3-regions", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2014/WD-css-regions-1-20141009/"),
    CSS3_RUBY("css3-ruby", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2014/WD-css-ruby-1-20140805/"),
    CSS3_TABLES("css3-tables", ECSSSpecificationStatus.EXPLORING),
    CSSOM("cssom", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2013/WD-cssom-20131205/"),
    CSS_OVERFLOW_3("css-overflow-3", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2013/WD-css-overflow-3-20130418/"),
    CSS_FONT_LOADING_3("css-font-loading-3", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2014/WD-css-font-loading-3-20140522/"),
    CSS_DISPLAY_3("css-display-3", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2014/WD-css-display-3-20140911/"),
    CSS_SCOPING_1("css-scoping-1", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2014/WD-css-scoping-1-20140403/"),
    CSS3_MEDIAQUERIES_4("css3-mediaqueries-4", ECSSSpecificationStatus.EXPLORING),
    SELECTORS_NONELEMENT_1("selectors-nonelement-1", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2014/WD-selectors-nonelement-1-20140603/"),
    GEOMETRY_1("geometry-1", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2014/CR-geometry-1-20141125/"),
    CSS3_BOX("css3-box", ECSSSpecificationStatus.REWRITING),
    CSS3_CONTENT("css3-content", ECSSSpecificationStatus.REWRITING, "http://www.w3.org/TR/2003/WD-css3-content-20030514/"),
    CSS3_LINEBOX("css3-linebox", ECSSSpecificationStatus.REWRITING, "http://www.w3.org/TR/2002/WD-css3-linebox-20020515/"),
    CSS3_READER("css3-reader", ECSSSpecificationStatus.ABANDONED),
    CSS3_PRESLEV("css3-preslev", ECSSSpecificationStatus.ABANDONED),
    CSS_TV("css-tv", ECSSSpecificationStatus.ABANDONED),
    CSS3_MARQUEE("css3-marquee", ECSSSpecificationStatus.ABANDONED, "http://www.w3.org/TR/2014/NOTE-css3-marquee-20141014/"),
    BECSS("becss", ECSSSpecificationStatus.ABANDONED),
    CSS3_HYPERLINKS("css3-hyperlinks", ECSSSpecificationStatus.ABANDONED, "http://www.w3.org/TR/2004/WD-css3-hyperlinks-20040224/"),
    CSS3_GRID("css3-grid", ECSSSpecificationStatus.ABANDONED, "http://www.w3.org/TR/2007/WD-css3-grid-20070905/"),
    FULLSCREEN("fullscreen", ECSSSpecificationStatus.ABANDONED, "http://www.w3.org/TR/2014/NOTE-fullscreen-20141118/"),
    OUTSIDE_CSS("$outside$", ECSSSpecificationStatus.OUTSIDE_CSS);

    private final String m_sID;
    private final ECSSSpecificationStatus m_eStatus;
    private final String m_sHandledURL;

    private ECSSSpecification(String string2, ECSSSpecificationStatus eCSSSpecificationStatus) {
        this(string2, eCSSSpecificationStatus, null);
    }

    private ECSSSpecification(@Nullable String string2, ECSSSpecificationStatus eCSSSpecificationStatus, String string3) {
        this.m_sID = string2;
        this.m_eStatus = eCSSSpecificationStatus;
        this.m_sHandledURL = string3;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public ECSSSpecificationStatus getStatus() {
        return this.m_eStatus;
    }

    public boolean hasHandledURL() {
        return StringHelper.hasText((String)this.m_sHandledURL);
    }

    @Nullable
    public String getHandledURL() {
        return this.m_sHandledURL;
    }

    @Nullable
    public static ECSSSpecification getFromIDOrNull(@Nullable String string) {
        return (ECSSSpecification)EnumHelper.getFromIDOrNull(ECSSSpecification.class, (Object)string);
    }
}

