/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.ValueEnforcer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NonBlockingStringReader
extends Reader {
    private char[] m_aChars;
    private final int m_nLength;
    private int m_nNext;
    private int m_nMark;

    public NonBlockingStringReader(@Nonnull char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public NonBlockingStringReader(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        this.m_aChars = cArray;
        this.m_nLength = n2;
        this.m_nNext = this.m_nMark = n;
    }

    public NonBlockingStringReader(@Nonnull String string) {
        this(string.toCharArray(), 0, string.length());
    }

    public NonBlockingStringReader(@Nonnull String string, @Nonnegative int n, @Nonnegative int n2) {
        this(string.toCharArray(), n, n2);
    }

    private void _ensureOpen() throws IOException {
        if (this.m_aChars == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    @CheckForSigned
    public int read() throws IOException {
        this._ensureOpen();
        if (this.m_nNext >= this.m_nLength) {
            return -1;
        }
        return this.m_aChars[this.m_nNext++];
    }

    @Override
    @CheckForSigned
    public int read(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        this._ensureOpen();
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        if (n2 == 0) {
            return 0;
        }
        if (this.m_nNext >= this.m_nLength) {
            return -1;
        }
        int n3 = Math.min(this.m_nLength - this.m_nNext, n2);
        System.arraycopy(this.m_aChars, this.m_nNext, cArray, n, n3);
        this.m_nNext += n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        this._ensureOpen();
        if (this.m_nNext >= this.m_nLength) {
            return 0L;
        }
        long l2 = Math.min((long)this.m_nLength - (long)this.m_nNext, l);
        l2 = Math.max((long)(-this.m_nNext), l2);
        this.m_nNext = (int)((long)this.m_nNext + l2);
        return l2;
    }

    @Override
    public boolean ready() throws IOException {
        this._ensureOpen();
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) throws IOException {
        ValueEnforcer.isGE0(n, "ReadAheadLimit");
        this._ensureOpen();
        this.m_nMark = this.m_nNext;
    }

    @Override
    public void reset() throws IOException {
        this._ensureOpen();
        this.m_nNext = this.m_nMark;
    }

    @Override
    public void close() {
        this.m_aChars = null;
    }
}

