/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.ValueEnforcer;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NonBlockingPushbackReader
extends FilterReader {
    private char[] m_aBuf;
    private int m_nBufPos;

    public NonBlockingPushbackReader(@Nonnull Reader reader, @Nonnegative int n) {
        super(reader);
        ValueEnforcer.isGT0(n, "Size");
        this.m_aBuf = new char[n];
        this.m_nBufPos = n;
    }

    public NonBlockingPushbackReader(@Nonnull Reader reader) {
        this(reader, 1);
    }

    private void _ensureOpen() throws IOException {
        if (this.m_aBuf == null) {
            throw new IOException("Reader closed");
        }
    }

    @Nonnegative
    public int getUnreadCount() {
        return this.m_aBuf.length - this.m_nBufPos;
    }

    public boolean hasUnreadChars() {
        return this.m_nBufPos < this.m_aBuf.length;
    }

    @Override
    public int read() throws IOException {
        this._ensureOpen();
        if (this.m_nBufPos < this.m_aBuf.length) {
            return this.m_aBuf[this.m_nBufPos++];
        }
        return super.read();
    }

    @Override
    public int read(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        this._ensureOpen();
        if (n2 == 0) {
            return 0;
        }
        try {
            int n3 = n;
            int n4 = n2;
            int n5 = this.m_aBuf.length - this.m_nBufPos;
            if (n5 > 0) {
                if (n4 < n5) {
                    n5 = n4;
                }
                System.arraycopy(this.m_aBuf, this.m_nBufPos, cArray, n3, n5);
                this.m_nBufPos += n5;
                n3 += n5;
                n4 -= n5;
            }
            if (n4 > 0) {
                if ((n4 = super.read(cArray, n3, n4)) == -1) {
                    return n5 == 0 ? -1 : n5;
                }
                return n5 + n4;
            }
            return n5;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void unread(int n) throws IOException {
        this._ensureOpen();
        if (this.m_nBufPos == 0) {
            throw new IOException("Pushback buffer overflow");
        }
        this.m_aBuf[--this.m_nBufPos] = (char)n;
    }

    public void unread(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        this._ensureOpen();
        if (n2 > this.m_nBufPos) {
            throw new IOException("Pushback buffer overflow");
        }
        this.m_nBufPos -= n2;
        System.arraycopy(cArray, n, this.m_aBuf, this.m_nBufPos, n2);
    }

    public void unread(@Nonnull char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    @Override
    public boolean ready() throws IOException {
        this._ensureOpen();
        return this.m_nBufPos < this.m_aBuf.length || super.ready();
    }

    @Override
    public void mark(int n) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.m_aBuf = null;
    }

    @Override
    public long skip(long l) throws IOException {
        ValueEnforcer.isGE0(l, "SkipValue");
        this._ensureOpen();
        if (l == 0L) {
            return 0L;
        }
        long l2 = l;
        int n = this.m_aBuf.length - this.m_nBufPos;
        if (n > 0) {
            if (l2 <= (long)n) {
                this.m_nBufPos = (int)((long)this.m_nBufPos + l2);
                return l2;
            }
            this.m_nBufPos = this.m_aBuf.length;
            l2 -= (long)n;
        }
        return (long)n + super.skip(l2);
    }
}

