/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.GenericReflection;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ArrayHelper {
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJ_ARRAY = new Boolean[0];
    public static final Byte[] EMPTY_BYTE_OBJ_ARRAY = new Byte[0];
    public static final Character[] EMPTY_CHAR_OBJ_ARRAY = new Character[0];
    public static final Double[] EMPTY_DOUBLE_OBJ_ARRAY = new Double[0];
    public static final Float[] EMPTY_FLOAT_OBJ_ARRAY = new Float[0];
    public static final Integer[] EMPTY_INT_OBJ_ARRAY = new Integer[0];
    public static final Long[] EMPTY_LONG_OBJ_ARRAY = new Long[0];
    public static final Short[] EMPTY_SHORT_OBJ_ARRAY = new Short[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final ArrayHelper s_aInstance = new ArrayHelper();

    private ArrayHelper() {
    }

    @Nonnull
    public static <ELEMENTTYPE> Class<? extends ELEMENTTYPE> getComponentType(@Nonnull ELEMENTTYPE[] ELEMENTTYPEArray) {
        ValueEnforcer.notNull(ELEMENTTYPEArray, "Array");
        Class<?> clazz = ELEMENTTYPEArray.getClass().getComponentType();
        return (Class)GenericReflection.uncheckedCast(clazz);
    }

    public static boolean isArray(@Nullable Object object) {
        return object != null && ClassHelper.isArrayClass(object.getClass());
    }

    @Nonnegative
    public static int getSize(boolean ... blArray) {
        return blArray == null ? 0 : blArray.length;
    }

    @Nonnegative
    public static int getSize(byte ... byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    @Nonnegative
    public static int getSize(char ... cArray) {
        return cArray == null ? 0 : cArray.length;
    }

    @Nonnegative
    public static int getSize(double ... dArray) {
        return dArray == null ? 0 : dArray.length;
    }

    @Nonnegative
    public static int getSize(float ... fArray) {
        return fArray == null ? 0 : fArray.length;
    }

    @Nonnegative
    public static int getSize(int ... nArray) {
        return nArray == null ? 0 : nArray.length;
    }

    @Nonnegative
    public static int getSize(long ... lArray) {
        return lArray == null ? 0 : lArray.length;
    }

    @Nonnegative
    public static int getSize(short ... sArray) {
        return sArray == null ? 0 : sArray.length;
    }

    @Nonnegative
    @SafeVarargs
    public static <ELEMENTTYPE> int getSize(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ELEMENTTYPEArray == null ? 0 : ELEMENTTYPEArray.length;
    }

    public static boolean isEmpty(boolean ... blArray) {
        return ArrayHelper.getSize(blArray) == 0;
    }

    public static boolean isEmpty(byte ... byArray) {
        return ArrayHelper.getSize(byArray) == 0;
    }

    public static boolean isEmpty(char ... cArray) {
        return ArrayHelper.getSize(cArray) == 0;
    }

    public static boolean isEmpty(double ... dArray) {
        return ArrayHelper.getSize(dArray) == 0;
    }

    public static boolean isEmpty(float ... fArray) {
        return ArrayHelper.getSize(fArray) == 0;
    }

    public static boolean isEmpty(int ... nArray) {
        return ArrayHelper.getSize(nArray) == 0;
    }

    public static boolean isEmpty(long ... lArray) {
        return ArrayHelper.getSize(lArray) == 0;
    }

    public static boolean isEmpty(short ... sArray) {
        return ArrayHelper.getSize(sArray) == 0;
    }

    @SafeVarargs
    public static <ELEMENTTYPE> boolean isEmpty(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ArrayHelper.getSize(ELEMENTTYPEArray) == 0;
    }

    public static boolean isNotEmpty(boolean ... blArray) {
        return ArrayHelper.getSize(blArray) > 0;
    }

    public static boolean isNotEmpty(byte ... byArray) {
        return ArrayHelper.getSize(byArray) > 0;
    }

    public static boolean isNotEmpty(char ... cArray) {
        return ArrayHelper.getSize(cArray) > 0;
    }

    public static boolean isNotEmpty(double ... dArray) {
        return ArrayHelper.getSize(dArray) > 0;
    }

    public static boolean isNotEmpty(float ... fArray) {
        return ArrayHelper.getSize(fArray) > 0;
    }

    public static boolean isNotEmpty(int ... nArray) {
        return ArrayHelper.getSize(nArray) > 0;
    }

    public static boolean isNotEmpty(long ... lArray) {
        return ArrayHelper.getSize(lArray) > 0;
    }

    public static boolean isNotEmpty(short ... sArray) {
        return ArrayHelper.getSize(sArray) > 0;
    }

    @SafeVarargs
    public static <ELEMENTTYPE> boolean isNotEmpty(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ArrayHelper.getSize(ELEMENTTYPEArray) > 0;
    }

    public static <ELEMENTTYPE> int getFirstIndex(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        int n = ArrayHelper.getSize(ELEMENTTYPEArray);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!EqualsHelper.equals(ELEMENTTYPEArray[i], ELEMENTTYPE)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable boolean[] blArray, boolean bl) {
        int n = ArrayHelper.getSize(blArray);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!EqualsHelper.equals(blArray[i], bl)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable byte[] byArray, byte by) {
        int n = ArrayHelper.getSize(byArray);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!EqualsHelper.equals(byArray[i], by)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable char[] cArray, char c) {
        int n = ArrayHelper.getSize(cArray);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!EqualsHelper.equals(cArray[i], c)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable double[] dArray, double d) {
        int n = ArrayHelper.getSize(dArray);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!EqualsHelper.equals(dArray[i], d)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable float[] fArray, float f) {
        int n = ArrayHelper.getSize(fArray);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!EqualsHelper.equals(fArray[i], f)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable int[] nArray, int n) {
        int n2 = ArrayHelper.getSize(nArray);
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (!EqualsHelper.equals(nArray[i], n)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable long[] lArray, long l) {
        int n = ArrayHelper.getSize(lArray);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!EqualsHelper.equals(lArray[i], l)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getFirstIndex(@Nullable short[] sArray, short s) {
        int n = ArrayHelper.getSize(sArray);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!EqualsHelper.equals(sArray[i], s)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <ELEMENTTYPE> int getLastIndex(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        int n = ArrayHelper.getSize(ELEMENTTYPEArray);
        if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!EqualsHelper.equals(ELEMENTTYPEArray[i], ELEMENTTYPE)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable boolean[] blArray, boolean bl) {
        int n = ArrayHelper.getSize(blArray);
        if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!EqualsHelper.equals(blArray[i], bl)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable byte[] byArray, byte by) {
        int n = ArrayHelper.getSize(byArray);
        if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!EqualsHelper.equals(byArray[i], by)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable char[] cArray, char c) {
        int n = ArrayHelper.getSize(cArray);
        if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!EqualsHelper.equals(cArray[i], c)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable double[] dArray, double d) {
        int n = ArrayHelper.getSize(dArray);
        if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!EqualsHelper.equals(dArray[i], d)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable float[] fArray, float f) {
        int n = ArrayHelper.getSize(fArray);
        if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!EqualsHelper.equals(fArray[i], f)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable int[] nArray, int n) {
        int n2 = ArrayHelper.getSize(nArray);
        if (n2 > 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                if (!EqualsHelper.equals(nArray[i], n)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable long[] lArray, long l) {
        int n = ArrayHelper.getSize(lArray);
        if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!EqualsHelper.equals(lArray[i], l)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getLastIndex(@Nullable short[] sArray, short s) {
        int n = ArrayHelper.getSize(sArray);
        if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!EqualsHelper.equals(sArray[i], s)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <ELEMENTTYPE> boolean contains(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return ArrayHelper.getFirstIndex(ELEMENTTYPEArray, ELEMENTTYPE) >= 0;
    }

    public static boolean contains(@Nullable boolean[] blArray, boolean bl) {
        return ArrayHelper.getFirstIndex(blArray, bl) >= 0;
    }

    public static boolean contains(@Nullable byte[] byArray, byte by) {
        return ArrayHelper.getFirstIndex(byArray, by) >= 0;
    }

    public static boolean contains(@Nullable char[] cArray, char c) {
        return ArrayHelper.getFirstIndex(cArray, c) >= 0;
    }

    public static boolean contains(@Nullable double[] dArray, double d) {
        return ArrayHelper.getFirstIndex(dArray, d) >= 0;
    }

    public static boolean contains(@Nullable float[] fArray, float f) {
        return ArrayHelper.getFirstIndex(fArray, f) >= 0;
    }

    public static boolean contains(@Nullable int[] nArray, int n) {
        return ArrayHelper.getFirstIndex(nArray, n) >= 0;
    }

    public static boolean contains(@Nullable long[] lArray, long l) {
        return ArrayHelper.getFirstIndex(lArray, l) >= 0;
    }

    public static boolean contains(@Nullable short[] sArray, short s) {
        return ArrayHelper.getFirstIndex(sArray, s) >= 0;
    }

    public static boolean getFirst(@Nullable boolean[] blArray, boolean bl) {
        return ArrayHelper.isEmpty(blArray) ? bl : blArray[0];
    }

    public static byte getFirst(@Nullable byte[] byArray, byte by) {
        return ArrayHelper.isEmpty(byArray) ? by : byArray[0];
    }

    public static char getFirst(@Nullable char[] cArray, char c) {
        return ArrayHelper.isEmpty(cArray) ? c : cArray[0];
    }

    public static double getFirst(@Nullable double[] dArray, double d) {
        return ArrayHelper.isEmpty(dArray) ? d : dArray[0];
    }

    public static float getFirst(@Nullable float[] fArray, float f) {
        return ArrayHelper.isEmpty(fArray) ? f : fArray[0];
    }

    public static int getFirst(@Nullable int[] nArray, int n) {
        return ArrayHelper.isEmpty(nArray) ? n : nArray[0];
    }

    public static long getFirst(@Nullable long[] lArray, long l) {
        return ArrayHelper.isEmpty(lArray) ? l : lArray[0];
    }

    public static short getFirst(@Nullable short[] sArray, short s) {
        return ArrayHelper.isEmpty(sArray) ? s : sArray[0];
    }

    @Nullable
    @SafeVarargs
    public static <ELEMENTTYPE> ELEMENTTYPE getFirst(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ArrayHelper.getFirst(ELEMENTTYPEArray, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirst(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return ArrayHelper.isEmpty(ELEMENTTYPEArray) ? ELEMENTTYPE : ELEMENTTYPEArray[0];
    }

    public static boolean getLast(@Nullable boolean[] blArray, boolean bl) {
        int n = ArrayHelper.getSize(blArray);
        return n == 0 ? bl : blArray[n - 1];
    }

    public static byte getLast(@Nullable byte[] byArray, byte by) {
        int n = ArrayHelper.getSize(byArray);
        return n == 0 ? by : byArray[n - 1];
    }

    public static char getLast(@Nullable char[] cArray, char c) {
        int n = ArrayHelper.getSize(cArray);
        return n == 0 ? c : cArray[n - 1];
    }

    public static double getLast(@Nullable double[] dArray, double d) {
        int n = ArrayHelper.getSize(dArray);
        return n == 0 ? d : dArray[n - 1];
    }

    public static float getLast(@Nullable float[] fArray, float f) {
        int n = ArrayHelper.getSize(fArray);
        return n == 0 ? f : fArray[n - 1];
    }

    public static int getLast(@Nullable int[] nArray, int n) {
        int n2 = ArrayHelper.getSize(nArray);
        return n2 == 0 ? n : nArray[n2 - 1];
    }

    public static long getLast(@Nullable long[] lArray, long l) {
        int n = ArrayHelper.getSize(lArray);
        return n == 0 ? l : lArray[n - 1];
    }

    public static short getLast(@Nullable short[] sArray, short s) {
        int n = ArrayHelper.getSize(sArray);
        return n == 0 ? s : sArray[n - 1];
    }

    @Nullable
    @SafeVarargs
    public static <ELEMENTTYPE> ELEMENTTYPE getLast(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ArrayHelper.getLast(ELEMENTTYPEArray, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLast(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        int n = ArrayHelper.getSize(ELEMENTTYPEArray);
        return n == 0 ? ELEMENTTYPE : ELEMENTTYPEArray[n - 1];
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getCopy(boolean ... blArray) {
        return blArray == null ? null : ArrayHelper.getCopy(blArray, 0, blArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getCopy(@Nullable boolean[] blArray, @Nonnegative int n) {
        return blArray == null ? null : ArrayHelper.getCopy(blArray, 0, Math.min(blArray.length, n));
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getCopy(@Nullable boolean[] blArray, @Nonnegative int n, @Nonnegative int n2) {
        if (blArray == null) {
            return null;
        }
        boolean[] blArray2 = new boolean[n2];
        System.arraycopy(blArray, n, blArray2, 0, n2);
        return blArray2;
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getCopy(byte ... byArray) {
        return byArray == null ? null : ArrayHelper.getCopy(byArray, 0, byArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getCopy(@Nullable byte[] byArray, @Nonnegative int n) {
        return byArray == null ? null : ArrayHelper.getCopy(byArray, 0, Math.min(byArray.length, n));
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getCopy(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getCopy(char ... cArray) {
        return cArray == null ? null : ArrayHelper.getCopy(cArray, 0, cArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getCopy(@Nullable char[] cArray, @Nonnegative int n) {
        return cArray == null ? null : ArrayHelper.getCopy(cArray, 0, Math.min(cArray.length, n));
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getCopy(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (cArray == null) {
            return null;
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return cArray2;
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getCopy(double ... dArray) {
        return dArray == null ? null : ArrayHelper.getCopy(dArray, 0, dArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getCopy(@Nullable double[] dArray, @Nonnegative int n) {
        return dArray == null ? null : ArrayHelper.getCopy(dArray, 0, Math.min(dArray.length, n));
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getCopy(@Nullable double[] dArray, @Nonnegative int n, @Nonnegative int n2) {
        if (dArray == null) {
            return null;
        }
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, n, dArray2, 0, n2);
        return dArray2;
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getCopy(float ... fArray) {
        return fArray == null ? null : ArrayHelper.getCopy(fArray, 0, fArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getCopy(@Nullable float[] fArray, @Nonnegative int n) {
        return fArray == null ? null : ArrayHelper.getCopy(fArray, 0, Math.min(fArray.length, n));
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getCopy(@Nullable float[] fArray, @Nonnegative int n, @Nonnegative int n2) {
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, n, fArray2, 0, n2);
        return fArray2;
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getCopy(int ... nArray) {
        return nArray == null ? null : ArrayHelper.getCopy(nArray, 0, nArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getCopy(@Nullable int[] nArray, @Nonnegative int n) {
        return nArray == null ? null : ArrayHelper.getCopy(nArray, 0, Math.min(nArray.length, n));
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getCopy(@Nullable int[] nArray, @Nonnegative int n, @Nonnegative int n2) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        return nArray2;
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getCopy(long ... lArray) {
        return lArray == null ? null : ArrayHelper.getCopy(lArray, 0, lArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getCopy(@Nullable long[] lArray, @Nonnegative int n) {
        return lArray == null ? null : ArrayHelper.getCopy(lArray, 0, Math.min(lArray.length, n));
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getCopy(@Nullable long[] lArray, @Nonnegative int n, @Nonnegative int n2) {
        if (lArray == null) {
            return null;
        }
        long[] lArray2 = new long[n2];
        System.arraycopy(lArray, n, lArray2, 0, n2);
        return lArray2;
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getCopy(short ... sArray) {
        return sArray == null ? null : ArrayHelper.getCopy(sArray, 0, sArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getCopy(@Nullable short[] sArray, @Nonnegative int n) {
        return sArray == null ? null : ArrayHelper.getCopy(sArray, 0, Math.min(sArray.length, n));
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getCopy(@Nullable short[] sArray, @Nonnegative int n, @Nonnegative int n2) {
        if (sArray == null) {
            return null;
        }
        short[] sArray2 = new short[n2];
        System.arraycopy(sArray, n, sArray2, 0, n2);
        return sArray2;
    }

    @Nullable
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getCopy(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ELEMENTTYPEArray == null ? null : ArrayHelper.getCopy(ELEMENTTYPEArray, 0, ELEMENTTYPEArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getCopy(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n) {
        return ELEMENTTYPEArray == null ? null : ArrayHelper.getCopy(ELEMENTTYPEArray, 0, Math.min(ELEMENTTYPEArray.length, n));
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getCopy(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        if (ELEMENTTYPEArray == null) {
            return null;
        }
        ELEMENTTYPE[] ELEMENTTYPEArray2 = ArrayHelper.newArraySameType(ELEMENTTYPEArray, n2);
        System.arraycopy(ELEMENTTYPEArray, n, ELEMENTTYPEArray2, 0, n2);
        return ELEMENTTYPEArray2;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getConcatenated(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray2) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return ArrayHelper.getCopy(ELEMENTTYPEArray2);
        }
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray2)) {
            return ArrayHelper.getCopy(ELEMENTTYPEArray);
        }
        ELEMENTTYPE[] ELEMENTTYPEArray3 = ArrayHelper.newArraySameType(ELEMENTTYPEArray, ELEMENTTYPEArray.length + ELEMENTTYPEArray2.length);
        System.arraycopy(ELEMENTTYPEArray, 0, ELEMENTTYPEArray3, 0, ELEMENTTYPEArray.length);
        System.arraycopy(ELEMENTTYPEArray2, 0, ELEMENTTYPEArray3, ELEMENTTYPEArray.length, ELEMENTTYPEArray2.length);
        return ELEMENTTYPEArray3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getConcatenated(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Class<ELEMENTTYPE> clazz) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return ArrayHelper.newArraySingleElement(ELEMENTTYPE, clazz);
        }
        ELEMENTTYPE[] ELEMENTTYPEArray2 = ArrayHelper.newArray(clazz, 1 + ELEMENTTYPEArray.length);
        ELEMENTTYPEArray2[0] = ELEMENTTYPE;
        System.arraycopy(ELEMENTTYPEArray, 0, ELEMENTTYPEArray2, 1, ELEMENTTYPEArray.length);
        return ELEMENTTYPEArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getConcatenated(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable ELEMENTTYPE ELEMENTTYPE, @Nonnull Class<ELEMENTTYPE> clazz) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return ArrayHelper.newArraySingleElement(ELEMENTTYPE, clazz);
        }
        ELEMENTTYPE[] ELEMENTTYPEArray2 = ArrayHelper.newArray(clazz, ELEMENTTYPEArray.length + 1);
        System.arraycopy(ELEMENTTYPEArray, 0, ELEMENTTYPEArray2, 0, ELEMENTTYPEArray.length);
        ELEMENTTYPEArray2[ELEMENTTYPEArray.length] = ELEMENTTYPE;
        return ELEMENTTYPEArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static boolean[] getConcatenated(@Nullable boolean[] blArray, boolean ... blArray2) {
        if (ArrayHelper.isEmpty(blArray)) {
            return ArrayHelper.getCopy(blArray2);
        }
        if (ArrayHelper.isEmpty(blArray2)) {
            return ArrayHelper.getCopy(blArray);
        }
        boolean[] blArray3 = new boolean[blArray.length + blArray2.length];
        System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
        System.arraycopy(blArray2, 0, blArray3, blArray.length, blArray2.length);
        return blArray3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static boolean[] getConcatenated(boolean bl, boolean ... blArray) {
        if (ArrayHelper.isEmpty(blArray)) {
            return new boolean[]{bl};
        }
        boolean[] blArray2 = new boolean[1 + blArray.length];
        blArray2[0] = bl;
        System.arraycopy(blArray, 0, blArray2, 1, blArray.length);
        return blArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static boolean[] getConcatenated(@Nullable boolean[] blArray, boolean bl) {
        if (ArrayHelper.isEmpty(blArray)) {
            return new boolean[]{bl};
        }
        boolean[] blArray2 = new boolean[blArray.length + 1];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        blArray2[blArray.length] = bl;
        return blArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getConcatenated(@Nullable byte[] byArray, byte ... byArray2) {
        if (ArrayHelper.isEmpty(byArray)) {
            return ArrayHelper.getCopy(byArray2);
        }
        if (ArrayHelper.isEmpty(byArray2)) {
            return ArrayHelper.getCopy(byArray);
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getConcatenated(byte by, byte ... byArray) {
        if (ArrayHelper.isEmpty(byArray)) {
            return new byte[]{by};
        }
        byte[] byArray2 = new byte[1 + byArray.length];
        byArray2[0] = by;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return byArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getConcatenated(@Nullable byte[] byArray, byte by) {
        if (ArrayHelper.isEmpty(byArray)) {
            return new byte[]{by};
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = by;
        return byArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static char[] getConcatenated(@Nullable char[] cArray, char ... cArray2) {
        if (ArrayHelper.isEmpty(cArray)) {
            return ArrayHelper.getCopy(cArray2);
        }
        if (ArrayHelper.isEmpty(cArray2)) {
            return ArrayHelper.getCopy(cArray);
        }
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        return cArray3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static char[][] getConcatenated(@Nullable char[][] cArray, char[] ... cArray2) {
        if (ArrayHelper.isEmpty(cArray)) {
            return (char[][])ArrayHelper.getCopy(cArray2);
        }
        if (ArrayHelper.isEmpty(cArray2)) {
            return (char[][])ArrayHelper.getCopy(cArray);
        }
        char[][] cArrayArray = new char[cArray.length + cArray2.length][];
        System.arraycopy(cArray, 0, cArrayArray, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArrayArray, cArray.length, cArray2.length);
        return cArrayArray;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static char[] getConcatenated(char c, char ... cArray) {
        if (ArrayHelper.isEmpty(cArray)) {
            return new char[]{c};
        }
        char[] cArray2 = new char[1 + cArray.length];
        cArray2[0] = c;
        System.arraycopy(cArray, 0, cArray2, 1, cArray.length);
        return cArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static char[] getConcatenated(@Nullable char[] cArray, char c) {
        if (ArrayHelper.isEmpty(cArray)) {
            return new char[]{c};
        }
        char[] cArray2 = new char[cArray.length + 1];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        cArray2[cArray.length] = c;
        return cArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static double[] getConcatenated(@Nullable double[] dArray, double ... dArray2) {
        if (ArrayHelper.isEmpty(dArray)) {
            return ArrayHelper.getCopy(dArray2);
        }
        if (ArrayHelper.isEmpty(dArray2)) {
            return ArrayHelper.getCopy(dArray);
        }
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return dArray3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static double[] getConcatenated(double d, double ... dArray) {
        if (ArrayHelper.isEmpty(dArray)) {
            return new double[]{d};
        }
        double[] dArray2 = new double[1 + dArray.length];
        dArray2[0] = d;
        System.arraycopy(dArray, 0, dArray2, 1, dArray.length);
        return dArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static double[] getConcatenated(@Nullable double[] dArray, double d) {
        if (ArrayHelper.isEmpty(dArray)) {
            return new double[]{d};
        }
        double[] dArray2 = new double[dArray.length + 1];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        dArray2[dArray.length] = d;
        return dArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static float[] getConcatenated(@Nullable float[] fArray, float ... fArray2) {
        if (ArrayHelper.isEmpty(fArray)) {
            return ArrayHelper.getCopy(fArray2);
        }
        if (ArrayHelper.isEmpty(fArray2)) {
            return ArrayHelper.getCopy(fArray);
        }
        float[] fArray3 = new float[fArray.length + fArray2.length];
        System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
        System.arraycopy(fArray2, 0, fArray3, fArray.length, fArray2.length);
        return fArray3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static float[] getConcatenated(float f, float ... fArray) {
        if (ArrayHelper.isEmpty(fArray)) {
            return new float[]{f};
        }
        float[] fArray2 = new float[1 + fArray.length];
        fArray2[0] = f;
        System.arraycopy(fArray, 0, fArray2, 1, fArray.length);
        return fArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static float[] getConcatenated(@Nullable float[] fArray, float f) {
        if (ArrayHelper.isEmpty(fArray)) {
            return new float[]{f};
        }
        float[] fArray2 = new float[fArray.length + 1];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        fArray2[fArray.length] = f;
        return fArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static int[] getConcatenated(@Nullable int[] nArray, int ... nArray2) {
        if (ArrayHelper.isEmpty(nArray)) {
            return ArrayHelper.getCopy(nArray2);
        }
        if (ArrayHelper.isEmpty(nArray2)) {
            return ArrayHelper.getCopy(nArray);
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static int[] getConcatenated(int n, int ... nArray) {
        if (ArrayHelper.isEmpty(nArray)) {
            return new int[]{n};
        }
        int[] nArray2 = new int[1 + nArray.length];
        nArray2[0] = n;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        return nArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static int[] getConcatenated(@Nullable int[] nArray, int n) {
        if (ArrayHelper.isEmpty(nArray)) {
            return new int[]{n};
        }
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray.length] = n;
        return nArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static long[] getConcatenated(@Nullable long[] lArray, long ... lArray2) {
        if (ArrayHelper.isEmpty(lArray)) {
            return ArrayHelper.getCopy(lArray2);
        }
        if (ArrayHelper.isEmpty(lArray2)) {
            return ArrayHelper.getCopy(lArray);
        }
        long[] lArray3 = new long[lArray.length + lArray2.length];
        System.arraycopy(lArray, 0, lArray3, 0, lArray.length);
        System.arraycopy(lArray2, 0, lArray3, lArray.length, lArray2.length);
        return lArray3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static long[] getConcatenated(long l, long ... lArray) {
        if (ArrayHelper.isEmpty(lArray)) {
            return new long[]{l};
        }
        long[] lArray2 = new long[1 + lArray.length];
        lArray2[0] = l;
        System.arraycopy(lArray, 0, lArray2, 1, lArray.length);
        return lArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static long[] getConcatenated(@Nullable long[] lArray, long l) {
        if (ArrayHelper.isEmpty(lArray)) {
            return new long[]{l};
        }
        long[] lArray2 = new long[lArray.length + 1];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        lArray2[lArray.length] = l;
        return lArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static short[] getConcatenated(@Nullable short[] sArray, short ... sArray2) {
        if (ArrayHelper.isEmpty(sArray)) {
            return ArrayHelper.getCopy(sArray2);
        }
        if (ArrayHelper.isEmpty(sArray2)) {
            return ArrayHelper.getCopy(sArray);
        }
        short[] sArray3 = new short[sArray.length + sArray2.length];
        System.arraycopy(sArray, 0, sArray3, 0, sArray.length);
        System.arraycopy(sArray2, 0, sArray3, sArray.length, sArray2.length);
        return sArray3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static short[] getConcatenated(short s, short ... sArray) {
        if (ArrayHelper.isEmpty(sArray)) {
            return new short[]{s};
        }
        short[] sArray2 = new short[1 + sArray.length];
        sArray2[0] = s;
        System.arraycopy(sArray, 0, sArray2, 1, sArray.length);
        return sArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static short[] getConcatenated(@Nullable short[] sArray, short s) {
        if (ArrayHelper.isEmpty(sArray)) {
            return new short[]{s};
        }
        short[] sArray2 = new short[sArray.length + 1];
        System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
        sArray2[sArray.length] = s;
        return sArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getConcatenated(@Nullable String[] stringArray, String ... stringArray2) {
        if (ArrayHelper.isEmpty(stringArray)) {
            return ArrayHelper.getCopy(stringArray2);
        }
        if (ArrayHelper.isEmpty(stringArray2)) {
            return ArrayHelper.getCopy(stringArray);
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getConcatenated(String string, String ... stringArray) {
        if (ArrayHelper.isEmpty(stringArray)) {
            return new String[]{string};
        }
        String[] stringArray2 = new String[1 + stringArray.length];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getConcatenated(@Nullable String[] stringArray, String string) {
        if (ArrayHelper.isEmpty(stringArray)) {
            return new String[]{string};
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    @Nullable
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getAllExceptFirst(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ArrayHelper.getAllExceptFirst(ELEMENTTYPEArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getAllExceptFirst(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return ELEMENTTYPEArray;
        }
        if (ELEMENTTYPEArray == null || n >= ELEMENTTYPEArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(ELEMENTTYPEArray, n, ELEMENTTYPEArray.length - n);
    }

    @Nullable
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getAllExcept(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, ELEMENTTYPE ... ELEMENTTYPEArray2) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray) || ArrayHelper.isEmpty(ELEMENTTYPEArray2)) {
            return ELEMENTTYPEArray;
        }
        ELEMENTTYPE[] ELEMENTTYPEArray3 = ArrayHelper.getCopy(ELEMENTTYPEArray);
        int n = 0;
        for (int i = 0; i < ELEMENTTYPEArray3.length; ++i) {
            if (ArrayHelper.contains(ELEMENTTYPEArray2, ELEMENTTYPEArray3[i])) continue;
            ELEMENTTYPEArray3[n++] = ELEMENTTYPEArray3[i];
        }
        return ArrayHelper.getCopy(ELEMENTTYPEArray3, 0, n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getAllExcept(@Nullable boolean[] blArray, boolean ... blArray2) {
        if (ArrayHelper.isEmpty(blArray) || ArrayHelper.isEmpty(blArray2)) {
            return blArray;
        }
        boolean[] blArray3 = ArrayHelper.getCopy(blArray);
        int n = 0;
        for (int i = 0; i < blArray3.length; ++i) {
            if (ArrayHelper.contains(blArray2, blArray3[i])) continue;
            blArray3[n++] = blArray3[i];
        }
        return ArrayHelper.getCopy(blArray3, 0, n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getAllExcept(@Nullable byte[] byArray, byte ... byArray2) {
        if (ArrayHelper.isEmpty(byArray) || ArrayHelper.isEmpty(byArray2)) {
            return byArray;
        }
        byte[] byArray3 = ArrayHelper.getCopy(byArray);
        int n = 0;
        for (int i = 0; i < byArray3.length; ++i) {
            if (ArrayHelper.contains(byArray2, byArray3[i])) continue;
            byArray3[n++] = byArray3[i];
        }
        return ArrayHelper.getCopy(byArray3, 0, n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getAllExcept(@Nullable char[] cArray, char ... cArray2) {
        if (ArrayHelper.isEmpty(cArray) || ArrayHelper.isEmpty(cArray2)) {
            return cArray;
        }
        char[] cArray3 = ArrayHelper.getCopy(cArray);
        int n = 0;
        for (int i = 0; i < cArray3.length; ++i) {
            if (ArrayHelper.contains(cArray2, cArray3[i])) continue;
            cArray3[n++] = cArray3[i];
        }
        return ArrayHelper.getCopy(cArray3, 0, n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getAllExcept(@Nullable double[] dArray, double ... dArray2) {
        if (ArrayHelper.isEmpty(dArray) || ArrayHelper.isEmpty(dArray2)) {
            return dArray;
        }
        double[] dArray3 = ArrayHelper.getCopy(dArray);
        int n = 0;
        for (int i = 0; i < dArray3.length; ++i) {
            if (ArrayHelper.contains(dArray2, dArray3[i])) continue;
            dArray3[n++] = dArray3[i];
        }
        return ArrayHelper.getCopy(dArray3, 0, n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getAllExcept(@Nullable float[] fArray, float ... fArray2) {
        if (ArrayHelper.isEmpty(fArray) || ArrayHelper.isEmpty(fArray2)) {
            return fArray;
        }
        float[] fArray3 = ArrayHelper.getCopy(fArray);
        int n = 0;
        for (int i = 0; i < fArray3.length; ++i) {
            if (ArrayHelper.contains(fArray2, fArray3[i])) continue;
            fArray3[n++] = fArray3[i];
        }
        return ArrayHelper.getCopy(fArray3, 0, n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getAllExcept(@Nullable int[] nArray, int ... nArray2) {
        if (ArrayHelper.isEmpty(nArray) || ArrayHelper.isEmpty(nArray2)) {
            return nArray;
        }
        int[] nArray3 = ArrayHelper.getCopy(nArray);
        int n = 0;
        for (int i = 0; i < nArray3.length; ++i) {
            if (ArrayHelper.contains(nArray2, nArray3[i])) continue;
            nArray3[n++] = nArray3[i];
        }
        return ArrayHelper.getCopy(nArray3, 0, n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getAllExcept(@Nullable long[] lArray, long ... lArray2) {
        if (ArrayHelper.isEmpty(lArray) || ArrayHelper.isEmpty(lArray2)) {
            return lArray;
        }
        long[] lArray3 = ArrayHelper.getCopy(lArray);
        int n = 0;
        for (int i = 0; i < lArray3.length; ++i) {
            if (ArrayHelper.contains(lArray2, lArray3[i])) continue;
            lArray3[n++] = lArray3[i];
        }
        return ArrayHelper.getCopy(lArray3, 0, n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getAllExcept(@Nullable short[] sArray, short ... sArray2) {
        if (ArrayHelper.isEmpty(sArray) || ArrayHelper.isEmpty(sArray2)) {
            return sArray;
        }
        short[] sArray3 = ArrayHelper.getCopy(sArray);
        int n = 0;
        for (int i = 0; i < sArray3.length; ++i) {
            if (ArrayHelper.contains(sArray2, sArray3[i])) continue;
            sArray3[n++] = sArray3[i];
        }
        return ArrayHelper.getCopy(sArray3, 0, n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getAllExceptFirst(boolean ... blArray) {
        return ArrayHelper.getAllExceptFirst(blArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getAllExceptFirst(@Nullable boolean[] blArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return blArray;
        }
        if (blArray == null || n >= blArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(blArray, n, blArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getAllExceptFirst(byte ... byArray) {
        return ArrayHelper.getAllExceptFirst(byArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getAllExceptFirst(@Nullable byte[] byArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return byArray;
        }
        if (byArray == null || n >= byArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(byArray, n, byArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getAllExceptFirst(char ... cArray) {
        return ArrayHelper.getAllExceptFirst(cArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getAllExceptFirst(@Nullable char[] cArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return cArray;
        }
        if (cArray == null || n >= cArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(cArray, n, cArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getAllExceptFirst(double ... dArray) {
        return ArrayHelper.getAllExceptFirst(dArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getAllExceptFirst(@Nullable double[] dArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return dArray;
        }
        if (dArray == null || n >= dArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(dArray, n, dArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getAllExceptFirst(float ... fArray) {
        return ArrayHelper.getAllExceptFirst(fArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getAllExceptFirst(@Nullable float[] fArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return fArray;
        }
        if (fArray == null || n >= fArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(fArray, n, fArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getAllExceptFirst(int ... nArray) {
        return ArrayHelper.getAllExceptFirst(nArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getAllExceptFirst(@Nullable int[] nArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return nArray;
        }
        if (nArray == null || n >= nArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(nArray, n, nArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getAllExceptFirst(long ... lArray) {
        return ArrayHelper.getAllExceptFirst(lArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getAllExceptFirst(@Nullable long[] lArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return lArray;
        }
        if (lArray == null || n >= lArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(lArray, n, lArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getAllExceptFirst(short ... sArray) {
        return ArrayHelper.getAllExceptFirst(sArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getAllExceptFirst(@Nullable short[] sArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return sArray;
        }
        if (sArray == null || n >= sArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(sArray, n, sArray.length - n);
    }

    @Nullable
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getAllExceptLast(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ArrayHelper.getAllExceptLast(ELEMENTTYPEArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] getAllExceptLast(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return ELEMENTTYPEArray;
        }
        if (ELEMENTTYPEArray == null || n >= ELEMENTTYPEArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(ELEMENTTYPEArray, 0, ELEMENTTYPEArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getAllExceptLast(boolean ... blArray) {
        return ArrayHelper.getAllExceptLast(blArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static boolean[] getAllExceptLast(@Nullable boolean[] blArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return blArray;
        }
        if (blArray == null || n >= blArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(blArray, 0, blArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getAllExceptLast(byte ... byArray) {
        return ArrayHelper.getAllExceptLast(byArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getAllExceptLast(@Nullable byte[] byArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return byArray;
        }
        if (byArray == null || n >= byArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(byArray, 0, byArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getAllExceptLast(char ... cArray) {
        return ArrayHelper.getAllExceptLast(cArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static char[] getAllExceptLast(@Nullable char[] cArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return cArray;
        }
        if (cArray == null || n >= cArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(cArray, 0, cArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getAllExceptLast(double ... dArray) {
        return ArrayHelper.getAllExceptLast(dArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static double[] getAllExceptLast(@Nullable double[] dArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return dArray;
        }
        if (dArray == null || n >= dArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(dArray, 0, dArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getAllExceptLast(float ... fArray) {
        return ArrayHelper.getAllExceptLast(fArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static float[] getAllExceptLast(@Nullable float[] fArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return fArray;
        }
        if (fArray == null || n >= fArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(fArray, 0, fArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getAllExceptLast(int ... nArray) {
        return ArrayHelper.getAllExceptLast(nArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static int[] getAllExceptLast(@Nullable int[] nArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return nArray;
        }
        if (nArray == null || n >= nArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(nArray, 0, nArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getAllExceptLast(long ... lArray) {
        return ArrayHelper.getAllExceptLast(lArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static long[] getAllExceptLast(@Nullable long[] lArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return lArray;
        }
        if (lArray == null || n >= lArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(lArray, 0, lArray.length - n);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getAllExceptLast(short ... sArray) {
        return ArrayHelper.getAllExceptLast(sArray, 1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static short[] getAllExceptLast(@Nullable short[] sArray, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ElementsToSkip");
        if (n == 0) {
            return sArray;
        }
        if (sArray == null || n >= sArray.length) {
            return null;
        }
        return ArrayHelper.getCopy(sArray, 0, sArray.length - n);
    }

    @Nullable
    @ReturnsMutableObject(value="use getCopy otherwise")
    public static boolean[] newBooleanArray(boolean ... blArray) {
        return blArray;
    }

    @Nullable
    @ReturnsMutableObject(value="use getCopy otherwise")
    public static byte[] newByteArray(byte ... byArray) {
        return byArray;
    }

    @Nullable
    @ReturnsMutableObject(value="use getCopy otherwise")
    public static char[] newCharArray(char ... cArray) {
        return cArray;
    }

    @Nullable
    @ReturnsMutableObject(value="use getCopy otherwise")
    public static double[] newDoubleArray(double ... dArray) {
        return dArray;
    }

    @Nullable
    @ReturnsMutableObject(value="use getCopy otherwise")
    public static float[] newFloatArray(float ... fArray) {
        return fArray;
    }

    @Nullable
    @ReturnsMutableObject(value="use getCopy otherwise")
    public static int[] newIntArray(int ... nArray) {
        return nArray;
    }

    @Nullable
    @ReturnsMutableObject(value="use getCopy otherwise")
    public static long[] newLongArray(long ... lArray) {
        return lArray;
    }

    @Nullable
    @ReturnsMutableObject(value="use getCopy otherwise")
    public static short[] newShortArray(short ... sArray) {
        return sArray;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArray(@Nonnull Class<? extends ELEMENTTYPE> clazz, @Nonnegative int n) {
        ValueEnforcer.notNull(clazz, "class");
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Argument cannot be primitive: " + clazz);
        }
        ValueEnforcer.isGE0(n, "Size");
        Object object = Array.newInstance(clazz, n);
        return (Object[])GenericReflection.uncheckedCast(object);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArraySameType(@Nonnull ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n) {
        return ArrayHelper.newArray(ArrayHelper.getComponentType(ELEMENTTYPEArray), n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArray(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Class<ELEMENTTYPE> clazz) {
        ValueEnforcer.notNull(clazz, "class");
        if (CollectionHelper.isEmpty(collection)) {
            return ArrayHelper.newArray(clazz, 0);
        }
        ELEMENTTYPE[] ELEMENTTYPEArray = ArrayHelper.newArray(clazz, collection.size());
        return collection.toArray(ELEMENTTYPEArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArraySingleElement(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nonnull Class<ELEMENTTYPE> clazz) {
        ValueEnforcer.notNull(clazz, "class");
        ELEMENTTYPE[] ELEMENTTYPEArray = ArrayHelper.newArray(clazz, 1);
        ELEMENTTYPEArray[0] = ELEMENTTYPE;
        return ELEMENTTYPEArray;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableObject(value="use getCopy otherwise")
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArray(ELEMENTTYPE ... ELEMENTTYPEArray) {
        ValueEnforcer.notNull(ELEMENTTYPEArray, "Array");
        return ELEMENTTYPEArray;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ELEMENTTYPE[] newArray(@Nonnegative int n, @Nonnull ELEMENTTYPE ELEMENTTYPE, @Nonnull Class<ELEMENTTYPE> clazz) {
        ValueEnforcer.isGE0(n, "ArraySize");
        ValueEnforcer.notNull(clazz, "class");
        Object[] objectArray = ArrayHelper.newArray(clazz, n);
        Arrays.fill(objectArray, ELEMENTTYPE);
        return objectArray;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> DSTTYPE[] newArrayMapped(@Nonnull Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nonnull Class<DSTTYPE> clazz) {
        ValueEnforcer.notNull(collection, "Collection");
        ValueEnforcer.notNull(function, "Converter");
        ValueEnforcer.notNull(clazz, "DestClass");
        DSTTYPE[] DSTTYPEArray = ArrayHelper.newArray(clazz, collection.size());
        int n = 0;
        for (SRCTYPE SRCTYPE : collection) {
            DSTTYPEArray[n++] = function.apply(SRCTYPE);
        }
        return DSTTYPEArray;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> DSTTYPE[] newArrayMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nonnull Class<DSTTYPE> clazz) {
        ValueEnforcer.notNull(function, "Converter");
        ValueEnforcer.notNull(clazz, "DestClass");
        DSTTYPE[] DSTTYPEArray = ArrayHelper.newArray(clazz, ArrayHelper.getSize(SRCTYPEArray));
        if (SRCTYPEArray != null) {
            int n = 0;
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                DSTTYPEArray[n++] = function.apply(SRCTYPE);
            }
        }
        return DSTTYPEArray;
    }

    @Nullable
    @ReturnsMutableCopy
    public static Object[] getAsObjectArray(@Nullable Collection<?> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return null;
        }
        Object[] objectArray = new Object[collection.size()];
        return collection.toArray(objectArray);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getSafeElement(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, int n) {
        return ArrayHelper.getSafeElement(ELEMENTTYPEArray, n, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getSafeElement(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return ELEMENTTYPEArray != null && n >= 0 && n < ELEMENTTYPEArray.length ? ELEMENTTYPEArray[n] : ELEMENTTYPE;
    }

    public static boolean isArrayEquals(@Nullable Object object, @Nullable Object object2) {
        if (EqualsHelper.identityEqual(object, object2)) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!ArrayHelper.isArray(object) || !ArrayHelper.isArray(object2)) {
            return false;
        }
        if (!object.getClass().getComponentType().equals(object2.getClass().getComponentType())) {
            return false;
        }
        int n = Array.getLength(object);
        if (n != Array.getLength(object2)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object3 = Array.get(object, i);
            Object object4 = Array.get(object2, i);
            if (!(ArrayHelper.isArray(object3) && ArrayHelper.isArray(object4) ? !ArrayHelper.isArrayEquals(object3, object4) : !EqualsHelper.equals(object3, object4))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean containsAnyNullElement(@Nullable T[] TArray) {
        if (TArray != null) {
            for (T t : TArray) {
                if (t != null) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean containsOnlyNullElements(@Nullable T[] TArray) {
        if (ArrayHelper.isEmpty(TArray)) {
            return false;
        }
        for (T t : TArray) {
            if (t == null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE findFirst(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return ArrayHelper.findFirst(ELEMENTTYPEArray, predicate, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE findFirst(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (predicate == null) {
            return ArrayHelper.getFirst(ELEMENTTYPEArray);
        }
        if (ArrayHelper.isNotEmpty(ELEMENTTYPEArray)) {
            for (ELEMENTTYPE ELEMENTTYPE2 : ELEMENTTYPEArray) {
                if (!predicate.test(ELEMENTTYPE2)) continue;
                return ELEMENTTYPE2;
            }
        }
        return ELEMENTTYPE;
    }

    @Nullable
    public static <ELEMENTTYPE, RETTYPE> RETTYPE findFirstMapped(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, RETTYPE> function) {
        return ArrayHelper.findFirstMapped(ELEMENTTYPEArray, predicate, function, null);
    }

    @Nullable
    public static <ELEMENTTYPE, RETTYPE> RETTYPE findFirstMapped(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, RETTYPE> function, @Nullable RETTYPE RETTYPE) {
        ValueEnforcer.notNull(function, "Mapper");
        if (ArrayHelper.isNotEmpty(ELEMENTTYPEArray)) {
            if (predicate == null) {
                return function.apply(ELEMENTTYPEArray[0]);
            }
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                return function.apply(ELEMENTTYPE);
            }
        }
        return RETTYPE;
    }

    @Nonnegative
    public static <ELEMENTTYPE> int getCount(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return ArrayHelper.getSize(ELEMENTTYPEArray);
        }
        int n = 0;
        if (ArrayHelper.isNotEmpty(ELEMENTTYPEArray)) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                ++n;
            }
        }
        return n;
    }

    public static <ELEMENTTYPE> boolean containsAny(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return ArrayHelper.isNotEmpty(ELEMENTTYPEArray);
        }
        if (ArrayHelper.isNotEmpty(ELEMENTTYPEArray)) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                return true;
            }
        }
        return false;
    }

    public static <ELEMENTTYPE> void forEach(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Consumer<? super ELEMENTTYPE> consumer) {
        if (ArrayHelper.isNotEmpty(ELEMENTTYPEArray)) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                consumer.accept(ELEMENTTYPE);
            }
        }
    }

    public static <ELEMENTTYPE> void forEach(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Consumer<? super ELEMENTTYPE> consumer) {
        if (predicate == null) {
            ArrayHelper.forEach(ELEMENTTYPEArray, consumer);
        } else if (ArrayHelper.isNotEmpty(ELEMENTTYPEArray)) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                consumer.accept(ELEMENTTYPE);
            }
        }
    }

    public static boolean startsWith(@Nonnull byte[] byArray, @Nullable byte[] byArray2) {
        if (byArray2 == null) {
            return false;
        }
        return ArrayHelper.startsWith(byArray, byArray.length, byArray2, 0, byArray2.length);
    }

    public static boolean startsWith(@Nonnull byte[] byArray, @Nonnegative int n, @Nullable byte[] byArray2) {
        if (byArray2 == null) {
            return false;
        }
        return ArrayHelper.startsWith(byArray, n, byArray2, 0, byArray2.length);
    }

    public static boolean startsWith(@Nonnull byte[] byArray, @Nullable byte[] byArray2, @Nonnegative int n, @Nonnegative int n2) {
        return ArrayHelper.startsWith(byArray, byArray.length, byArray2, n, n2);
    }

    public static boolean startsWith(@Nonnull byte[] byArray, @Nonnegative int n, @Nullable byte[] byArray2, @Nonnegative int n2, @Nonnegative int n3) {
        if (byArray2 == null || n <= 0 || n < n3) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (byArray[i] == byArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(@Nonnull char[] cArray, @Nullable char[] cArray2) {
        if (cArray2 == null) {
            return false;
        }
        return ArrayHelper.startsWith(cArray, cArray2, 0, cArray2.length);
    }

    public static boolean startsWith(@Nonnull char[] cArray, @Nonnegative int n, @Nullable char[] cArray2) {
        if (cArray2 == null) {
            return false;
        }
        return ArrayHelper.startsWith(cArray, n, cArray2, 0, cArray2.length);
    }

    public static boolean startsWith(@Nonnull char[] cArray, @Nullable char[] cArray2, @Nonnegative int n, @Nonnegative int n2) {
        return ArrayHelper.startsWith(cArray, cArray.length, cArray2, n, n2);
    }

    public static boolean startsWith(@Nonnull char[] cArray, @Nonnegative int n, @Nullable char[] cArray2, @Nonnegative int n2, @Nonnegative int n3) {
        if (cArray2 == null || n <= 0 || n < n3) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (cArray[i] == cArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }
}

