/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.CommonsWeakHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSortedMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.state.EContinue;
import com.helger.commons.typeconvert.ITypeConverter;
import com.helger.commons.typeconvert.ITypeConverterCallback;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import com.helger.commons.typeconvert.ITypeConverterRule;
import com.helger.commons.wrapper.Wrapper;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class TypeConverterRegistry
implements ITypeConverterRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(TypeConverterRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<Class<?>, ICommonsMap<Class<?>, ITypeConverter<?, ?>>> m_aConverter = new CommonsWeakHashMap();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSortedMap<ITypeConverterRule.ESubType, ICommonsList<ITypeConverterRule<?, ?>>> m_aRules = new CommonsTreeMap();

    private TypeConverterRegistry() {
        this._reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static TypeConverterRegistry getInstance() {
        TypeConverterRegistry typeConverterRegistry = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return typeConverterRegistry;
    }

    @Nonnull
    @ReturnsMutableObject(value="internal use only")
    private ICommonsMap<Class<?>, ITypeConverter<?, ?>> _getOrCreateConverterMap(@Nonnull Class<?> clazz) {
        ICommonsMap iCommonsMap = this.m_aRWLock.readLocked(() -> (ICommonsMap)this.m_aConverter.get(clazz));
        if (iCommonsMap == null) {
            iCommonsMap = this.m_aRWLock.writeLocked(() -> this.m_aConverter.computeIfAbsent(clazz, clazz -> new CommonsWeakHashMap()));
        }
        return iCommonsMap;
    }

    private void _registerTypeConverter(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull ITypeConverter<?, ?> iTypeConverter) {
        ICommonsMap<Class<?>, ITypeConverter<?, ?>> iCommonsMap;
        ValueEnforcer.notNull(clazz, "SrcClass");
        ValueEnforcer.isTrue(ClassHelper.isPublic(clazz), () -> "Source " + clazz + " is no public class!");
        ValueEnforcer.notNull(clazz2, "DstClass");
        ValueEnforcer.isTrue(ClassHelper.isPublic(clazz2), () -> "Destination " + clazz2 + " is no public class!");
        ValueEnforcer.isFalse(clazz.equals(clazz2), "Source and destination class are equal and therefore no converter is required.");
        ValueEnforcer.notNull(iTypeConverter, "Converter");
        ValueEnforcer.isFalse(iTypeConverter instanceof ITypeConverterRule, "Type converter rules must be registered via registerTypeConverterRule");
        if (ClassHelper.areConvertibleClasses(clazz, clazz2)) {
            s_aLogger.warn("No type converter needed between " + clazz + " and " + clazz2 + " because types are convertible!");
        }
        if ((iCommonsMap = this._getOrCreateConverterMap(clazz)).containsKey(clazz2)) {
            throw new IllegalArgumentException("A mapping from " + clazz + " to " + clazz2 + " is already defined!");
        }
        this.m_aRWLock.writeLocked(() -> {
            for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz2)) {
                Class clazz3 = (Class)weakReference.get();
                if (clazz3 == null || iCommonsMap.containsKey(clazz3)) continue;
                if (iCommonsMap.put(clazz3, iTypeConverter) != null) {
                    s_aLogger.warn("Overwriting converter from " + clazz + " to " + clazz3);
                    continue;
                }
                if (!s_aLogger.isTraceEnabled()) continue;
                s_aLogger.trace("Registered type converter from '" + clazz.toString() + "' to '" + clazz3.toString() + "'");
            }
        });
    }

    @Override
    public <SRC, DST> void registerTypeConverter(@Nonnull Class<SRC> clazz, @Nonnull Class<DST> clazz2, @Nonnull ITypeConverter<SRC, DST> iTypeConverter) {
        this._registerTypeConverter(clazz, clazz2, iTypeConverter);
    }

    @Override
    public <DST> void registerTypeConverter(@Nonnull Class<?>[] classArray, @Nonnull Class<DST> clazz, @Nonnull ITypeConverter<?, DST> iTypeConverter) {
        for (Class<?> clazz2 : classArray) {
            this._registerTypeConverter(clazz2, clazz, iTypeConverter);
        }
    }

    @Nullable
    ITypeConverter<?, ?> getExactConverter(@Nullable Class<?> clazz, @Nullable Class<?> clazz2) {
        return this.m_aRWLock.readLocked(() -> {
            Map map = (Map)this.m_aConverter.get(clazz);
            return map == null ? null : (ITypeConverter)map.get(clazz2);
        });
    }

    @Nullable
    ITypeConverter<?, ?> getRuleBasedConverter(@Nullable Class<?> clazz, @Nullable Class<?> clazz2) {
        if (clazz == null || clazz2 == null) {
            return null;
        }
        return this.m_aRWLock.readLocked(() -> {
            for (Map.Entry entry : this.m_aRules.entrySet()) {
                for (ITypeConverterRule iTypeConverterRule : (ICommonsList)entry.getValue()) {
                    if (!iTypeConverterRule.canConvert(clazz, clazz2)) continue;
                    return iTypeConverterRule;
                }
            }
            return null;
        });
    }

    private void _iterateFuzzyConverters(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull ITypeConverterCallback iTypeConverterCallback) {
        ITypeConverter iTypeConverter;
        Map map;
        WeakReference weakReference;
        Class clazz3;
        Iterator iterator = ClassHierarchyCache.getClassHierarchyIterator(clazz).iterator();
        while (iterator.hasNext() && ((clazz3 = (Class)(weakReference = (WeakReference)iterator.next()).get()) == null || (map = (Map)this.m_aConverter.get(clazz3)) == null || (iTypeConverter = (ITypeConverter)map.get(clazz2)) == null || !iTypeConverterCallback.call(clazz3, clazz2, iTypeConverter).isBreak())) {
        }
    }

    @Nullable
    ITypeConverter<?, ?> getFuzzyConverter(@Nullable Class<?> clazz, @Nullable Class<?> clazz2) {
        if (clazz == null || clazz2 == null) {
            return null;
        }
        return this.m_aRWLock.readLocked(() -> {
            Serializable serializable;
            if (GlobalDebug.isDebugMode()) {
                serializable = new CommonsArrayList();
                this._iterateFuzzyConverters(clazz, clazz2, (clazz3, clazz4, iTypeConverter) -> {
                    boolean bl = clazz.equals(clazz3) && clazz2.equals(clazz4);
                    serializable.add("[" + clazz3.getName() + "->" + clazz4.getName() + "]");
                    return bl ? EContinue.BREAK : EContinue.CONTINUE;
                });
                if (serializable.size() > 1) {
                    s_aLogger.warn("The fuzzy type converter resolver returned more than 1 match for the conversion from " + clazz + " to " + clazz2 + ": " + serializable);
                }
            }
            serializable = new Wrapper();
            this._iterateFuzzyConverters(clazz, clazz2, (clazz, clazz2, iTypeConverter) -> {
                serializable.set(iTypeConverter);
                return EContinue.BREAK;
            });
            return (ITypeConverter)((Wrapper)serializable).get();
        });
    }

    public void iterateAllRegisteredTypeConverters(@Nonnull ITypeConverterCallback iTypeConverterCallback) {
        Map map = this.m_aRWLock.readLocked(() -> new CommonsHashMap((Map<Class<?>, ICommonsMap<Class<?>, ITypeConverter<?, ?>>>)this.m_aConverter));
        block0: for (Map.Entry entry : map.entrySet()) {
            Class clazz = (Class)entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                if (!iTypeConverterCallback.call(clazz, (Class)entry2.getKey(), (ITypeConverter)entry2.getValue()).isBreak()) continue;
                break block0;
            }
        }
    }

    @Nonnegative
    public int getRegisteredTypeConverterCount() {
        return this.m_aRWLock.readLocked(() -> {
            int n = 0;
            for (Map map : this.m_aConverter.values()) {
                n += map.size();
            }
            return n;
        });
    }

    @Override
    public void registerTypeConverterRule(@Nonnull ITypeConverterRule<?, ?> iTypeConverterRule) {
        ValueEnforcer.notNull(iTypeConverterRule, "TypeConverterRule");
        this.m_aRWLock.writeLocked(() -> this.m_aRules.computeIfAbsent(iTypeConverterRule.getSubType(), eSubType -> new CommonsArrayList()).add(iTypeConverterRule));
        if (s_aLogger.isTraceEnabled()) {
            s_aLogger.trace("Registered type converter rule " + ClassHelper.getClassLocalName(iTypeConverterRule) + " with type " + (Object)((Object)iTypeConverterRule.getSubType()));
        }
    }

    @Nonnegative
    public long getRegisteredTypeConverterRuleCount() {
        return this.m_aRWLock.readLocked(() -> {
            int n = 0;
            for (ICommonsList iCommonsList : this.m_aRules.values()) {
                n += iCommonsList.size();
            }
            return n;
        });
    }

    private void _reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aConverter.clear();
            this.m_aRules.clear();
            for (ITypeConverterRegistrarSPI iTypeConverterRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(ITypeConverterRegistrarSPI.class)) {
                if (s_aLogger.isDebugEnabled()) {
                    s_aLogger.debug("Calling registerTypeConverter on " + iTypeConverterRegistrarSPI.getClass().getName());
                }
                iTypeConverterRegistrarSPI.registerTypeConverter(this);
            }
        });
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug(this.getRegisteredTypeConverterCount() + " type converters and " + this.getRegisteredTypeConverterRuleCount() + " rules registered");
        }
    }

    public void reinitialize() {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Reinitializing " + this.getClass().getName());
        }
        this._reinitialize();
    }

    private static final class SingletonHolder {
        private static final TypeConverterRegistry s_aInstance = new TypeConverterRegistry();

        private SingletonHolder() {
        }
    }
}

