/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.transform;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.error.IHasResourceErrorGroup;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.IResourceErrorGroup;
import com.helger.commons.error.ResourceErrorGroup;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.transform.AbstractTransformErrorListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.ErrorListener;

@ThreadSafe
public class CollectingTransformErrorListener
extends AbstractTransformErrorListener
implements IHasResourceErrorGroup {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ResourceErrorGroup m_aErrors = new ResourceErrorGroup();

    public CollectingTransformErrorListener() {
    }

    public CollectingTransformErrorListener(@Nullable ErrorListener errorListener) {
        super(errorListener);
    }

    @Override
    protected void internalLog(@Nonnull IResourceError iResourceError) {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aErrors.addResourceError(iResourceError);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IResourceErrorGroup getResourceErrors() {
        this.m_aRWLock.readLock().lock();
        try {
            ResourceErrorGroup resourceErrorGroup = this.m_aErrors.getClone();
            return resourceErrorGroup;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    public EChange clearResourceErrors() {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aErrors.clear();
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("errors", this.m_aErrors).toString();
    }
}

