/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.ls;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.xml.ls.AbstractLSResourceResolver;
import com.helger.commons.xml.ls.LSResourceData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;

@ThreadSafe
public class CollectingLSResourceResolver
extends AbstractLSResourceResolver {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CollectingLSResourceResolver.class);
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final List<LSResourceData> m_aList = new ArrayList<LSResourceData>();

    @Nonnull
    @ReturnsMutableCopy
    public List<LSResourceData> getAllRequestedResources() {
        this.m_aRWLock.readLock().lock();
        try {
            List<LSResourceData> list = CollectionHelper.newList(this.m_aList);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LSInput mainResolveResource(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) {
        LSResourceData lSResourceData = new LSResourceData(string, string2, string3, string4, string5);
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aList.add(lSResourceData);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        return null;
    }
}

