/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.name.IHasName;
import com.helger.commons.xml.EXMLParserFeatureType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public enum EXMLParserFeature implements IHasName
{
    SECURE_PROCESSING(EXMLParserFeatureType.GENERAL, "http://javax.xml.XMLConstants/feature/secure-processing"),
    NAMESPACES(EXMLParserFeatureType.GENERAL, "http://xml.org/sax/features/namespaces"),
    USE_ENTITY_RESOLVER2(EXMLParserFeatureType.GENERAL, "http://xml.org/sax/features/use-entity-resolver2"),
    VALIDATION(EXMLParserFeatureType.GENERAL, "http://xml.org/sax/features/validation"),
    DYNAMIC(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/dynamic"),
    SCHEMA(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema"),
    SCHEMA_FULL_CHECKING(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema-full-checking"),
    NORMALIZED_VALUE(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema/normalized-value"),
    ELEMENT_DEFAULT(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema/element-default"),
    AUGMENT_PSVI(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema/augment-psvi"),
    IGNORE_XSI_TYPE_UNTIL_ELEMDECL(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema/ignore-xsi-type-until-elemdecl"),
    GENERATE_SYNTHETIC_ANNOTATIONS(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/generate-synthetic-annotations"),
    VALIDATE_ANNOTATIONS(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validate-annotations"),
    HONOUR_ALL_SCHEMA_LOCATIONS(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/honour-all-schemaLocations"),
    EXTERNAL_GENERAL_ENTITIES(EXMLParserFeatureType.GENERAL, "http://xml.org/sax/features/external-general-entities"),
    EXTERNAL_PARAMETER_ENTITIES(EXMLParserFeatureType.GENERAL, "http://xml.org/sax/features/external-parameter-entities"),
    BALANCE_SYNTAX_TREES(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/balance-syntax-trees"),
    ID_IDREF_CHECKING(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/id-idref-checking"),
    IDENTITY_CONSTRAINT_CHECKING(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/identity-constraint-checking"),
    UNPARSED_ENTITY_CHECKING(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/unparsed-entity-checking"),
    WARN_ON_DUPLICATE_ATTDEF(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/warn-on-duplicate-attdef"),
    WARN_ON_UNDECLARED_ELEMDEF(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/warn-on-undeclared-elemdef"),
    WARN_ON_DUPLICATE_ENTITYDEF(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/warn-on-duplicate-entitydef"),
    ALLOW_JAVA_ENCODINGS(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/allow-java-encodings"),
    CONTINUE_AFTER_FATAL_ERROR(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/continue-after-fatal-error"),
    LOAD_DTD_GRAMMAR(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar"),
    LOAD_EXTERNAL_DTD(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/nonvalidating/load-external-dtd"),
    NOTIFY_CHAR_REFS(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/scanner/notify-char-refs"),
    NOTIFY_BUILTIN_REFS(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/scanner/notify-builtin-refs"),
    DISALLOW_DOCTYPE_DECL(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/disallow-doctype-decl"),
    STANDARD_URI_CONFORMANT(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/standard-uri-conformant"),
    XINCLUDE(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/xinclude"),
    XINCLUDE_FIXUP_BASE_URIS(EXMLParserFeatureType.XINCLUDE, "http://apache.org/xml/features/xinclude/fixup-base-uris"),
    XINCLUDE_FIXUP_LANGUAGE(EXMLParserFeatureType.XINCLUDE, "http://apache.org/xml/features/xinclude/fixup-language"),
    DOM_DEFER_NODE_EXPANSION(EXMLParserFeatureType.DOM, "http://apache.org/xml/features/dom/defer-node-expansion"),
    DOM_CREATE_ENTITY_REF_NODES(EXMLParserFeatureType.DOM, "http://apache.org/xml/features/dom/create-entity-ref-nodes"),
    DOM_INCLUDE_IGNORABLE_WHITESPACE(EXMLParserFeatureType.DOM, "http://apache.org/xml/features/dom/include-ignorable-whitespace"),
    SAX_NAMESPACE_PREFIXES(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/namespace-prefixes"),
    SAX_STRING_INTERNING(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/string-interning"),
    SAX_PARAMETER_ENTITIES(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/lexical-handler/parameter-entities"),
    SAX_FEATURE_IS_STANDALONE(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/is-standalone"),
    SAX_RESOLVE_DTD_URIS(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/resolve-dtd-uris"),
    SAX_UNICODE_NORMALIZATION_CHECKING(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/unicode-normalization-checking"),
    SAX_USE_ATTRIBUTES2(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/use-attributes2"),
    SAX_USE_LOCATOR2(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/use-locator2"),
    SAX_XMLNS_URIS(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/xmlns-uris"),
    SAX_IS_XML11_PARSER(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/xml-1.1");

    public static final Map<EXMLParserFeature, Boolean> AVOID_XXE_SETTINGS;
    public static final Map<EXMLParserFeature, Boolean> AVOID_DOS_SETTINGS;
    public static final Map<EXMLParserFeature, Boolean> AVOID_XML_ATTACKS;
    private static final Logger s_aLogger;
    private final EXMLParserFeatureType m_eType;
    private final String m_sName;
    @CodingStyleguideUnaware
    private boolean m_bWarnedOnce = false;

    private EXMLParserFeature(EXMLParserFeatureType eXMLParserFeatureType, String string2) {
        this.m_eType = eXMLParserFeatureType;
        this.m_sName = string2;
    }

    @Nonnull
    public EXMLParserFeatureType getFeatureType() {
        return this.m_eType;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    public void applyTo(@Nonnull XMLReader xMLReader, boolean bl) {
        ValueEnforcer.notNull(xMLReader, "Parser");
        if (this.m_eType != EXMLParserFeatureType.GENERAL && this.m_eType != EXMLParserFeatureType.SAX) {
            s_aLogger.warn("Parser feature '" + this.name() + "' is not applicable for SAX parsers!");
        }
        try {
            xMLReader.setFeature(this.m_sName, bl);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            if (!this.m_bWarnedOnce) {
                s_aLogger.warn("XML Parser does not recognize feature '" + this.name() + "'");
                this.m_bWarnedOnce = true;
            }
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            s_aLogger.warn("XML Parser does not support feature '" + this.name() + "'");
        }
    }

    public void applyTo(@Nonnull DocumentBuilderFactory documentBuilderFactory, boolean bl) {
        ValueEnforcer.notNull(documentBuilderFactory, "DocumentBuilderFactory");
        if (this.m_eType != EXMLParserFeatureType.GENERAL && this.m_eType != EXMLParserFeatureType.DOM) {
            s_aLogger.warn("Parser feature '" + this.name() + "' is not applicable for DOM parsers!");
        }
        try {
            documentBuilderFactory.setFeature(this.m_sName, bl);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            s_aLogger.warn("DOM parser does not support feature '" + this.name() + "'");
        }
    }

    @Nullable
    public static EXMLParserFeature getFromNameOrNull(@Nullable String string) {
        return EnumHelper.getFromNameOrNull(EXMLParserFeature.class, string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<EXMLParserFeature> getAllFeaturesOfType(@Nonnull EXMLParserFeatureType eXMLParserFeatureType) {
        ValueEnforcer.notNull(eXMLParserFeatureType, "FeatureType");
        ArrayList<EXMLParserFeature> arrayList = new ArrayList<EXMLParserFeature>();
        for (EXMLParserFeature eXMLParserFeature : EXMLParserFeature.values()) {
            if (eXMLParserFeature.getFeatureType() != eXMLParserFeatureType) continue;
            arrayList.add(eXMLParserFeature);
        }
        return arrayList;
    }

    static {
        AVOID_XXE_SETTINGS = CollectionHelper.newUnmodifiableMap(new EXMLParserFeature[]{DISALLOW_DOCTYPE_DECL, EXTERNAL_GENERAL_ENTITIES, EXTERNAL_PARAMETER_ENTITIES}, new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE});
        AVOID_DOS_SETTINGS = CollectionHelper.newUnmodifiableMap(new EXMLParserFeature[]{SECURE_PROCESSING}, new Boolean[]{Boolean.TRUE});
        AVOID_XML_ATTACKS = CollectionHelper.newUnmodifiableMap(ArrayHelper.newArray(AVOID_XXE_SETTINGS, AVOID_DOS_SETTINGS));
        s_aLogger = LoggerFactory.getLogger(EXMLParserFeature.class);
    }
}

