/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.regex;

import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.IsLocked;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.cache.AbstractNotifyingCache;
import com.helger.commons.regex.RegExPattern;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.RegEx;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RegExPool
extends AbstractNotifyingCache<RegExPattern, Pattern> {
    public static final int MAX_CACHE_SIZE = 1000;
    private static boolean s_bDefaultInstantiated = false;

    private RegExPool() {
        super(1000, RegExPool.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static RegExPool getInstance() {
        RegExPool regExPool = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return regExPool;
    }

    @Override
    @Nonnull
    @IsLocked(value=ELockType.WRITE)
    protected Pattern getValueToCache(@Nonnull RegExPattern regExPattern) {
        return regExPattern.getAsPattern();
    }

    @Nonnull
    public static Pattern getPattern(@Nonnull @RegEx @Nonempty String string) {
        return (Pattern)RegExPool.getInstance().getFromCache(new RegExPattern(string));
    }

    @Nonnull
    public static Pattern getPattern(@Nonnull @RegEx @Nonempty String string, @Nonnegative int n) {
        return (Pattern)RegExPool.getInstance().getFromCache(new RegExPattern(string, n));
    }

    private static final class SingletonHolder {
        static final RegExPool s_aInstance = new RegExPool();

        private SingletonHolder() {
        }
    }
}

