/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.microdom.IMicroQName;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.CXMLRegEx;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MicroQName
implements IMicroQName,
Comparable<MicroQName> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroQName.class);
    private final String m_sNamespaceURI;
    private final String m_sName;
    private Integer m_aHashCode;

    public MicroQName(@Nonnull @Nonempty String string) {
        this("", string);
    }

    public MicroQName(@Nullable String string, @Nonnull @Nonempty String string2) {
        int n;
        ValueEnforcer.notEmpty(string2, string2);
        this.m_sNamespaceURI = StringHelper.hasNoText(string) ? null : string;
        int n2 = n = string != null ? string2.indexOf(58) : -1;
        if (n == -1) {
            this.m_sName = string2;
        } else {
            s_aLogger.warn("Removing namespace prefix '" + string2.substring(0, n) + "' from micro XML name '" + string2 + "'");
            this.m_sName = string2.substring(n + 1);
        }
        if (GlobalDebug.isDebugMode() && !CXMLRegEx.PATTERN_NAME_QUICK.matcher(this.m_sName).matches() && !CXMLRegEx.PATTERN_NAME.matcher(this.m_sName).matches()) {
            throw new IllegalArgumentException("The micro XML name '" + this.m_sName + "' is not a valid XML name!");
        }
    }

    @Override
    @Nullable
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    public boolean hasNamespaceURI() {
        return StringHelper.hasText(this.m_sNamespaceURI);
    }

    @Override
    public boolean hasNoNamespaceURI() {
        return StringHelper.hasNoText(this.m_sNamespaceURI);
    }

    @Override
    public boolean hasNamespaceURI(@Nullable String string) {
        return EqualsHelper.equals(this.m_sNamespaceURI, string);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public QName getAsXMLQName() {
        return new QName(this.m_sNamespaceURI, this.m_sName);
    }

    @Override
    @Nonnull
    public QName getAsXMLQName(@Nonnull String string) {
        return new QName(this.m_sNamespaceURI, this.m_sName, string);
    }

    @Override
    public int compareTo(@Nonnull MicroQName microQName) {
        int n = CompareHelper.compare(this.m_sNamespaceURI, microQName.m_sNamespaceURI);
        if (n == 0) {
            n = this.m_sName.compareTo(microQName.m_sName);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MicroQName microQName = (MicroQName)object;
        return EqualsHelper.equals(this.m_sNamespaceURI, microQName.m_sNamespaceURI) && this.m_sName.equals(microQName.m_sName);
    }

    public int hashCode() {
        if (this.m_aHashCode == null) {
            this.m_aHashCode = new HashCodeGenerator(this).append(this.m_sNamespaceURI).append(this.m_sName).getHashCodeObj();
        }
        return this.m_aHashCode;
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("NamespaceURI", this.m_sNamespaceURI).append("Name", this.m_sName).toString();
    }
}

