/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.id.IHasID;
import com.helger.commons.id.IHasIntID;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.name.IHasName;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class EnumHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(EnumHelper.class);
    private static final Object[] NOT_CACHABLE = ArrayHelper.EMPTY_OBJECT_ARRAY;
    private static final ReadWriteLock s_aRWLockInt = new ReentrantReadWriteLock();
    private static final Map<String, Object[]> s_aIntCache = new HashMap<String, Object[]>();
    private static final EnumHelper s_aInstance = new EnumHelper();

    private EnumHelper() {
    }

    @Nullable
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE) {
        return EnumHelper.getFromIDOrDefault(clazz, KEYTYPE, null);
    }

    @Nullable
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (KEYTYPE != null) {
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                if (!((IHasID)((Object)enum_)).getID().equals(KEYTYPE)) continue;
                return (ENUMTYPE)enum_;
            }
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDOrNull(clazz, KEYTYPE);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + KEYTYPE + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromIDCaseInsensitiveOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (string != null) {
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                if (!((String)((IHasID)((Object)enum_)).getID()).equalsIgnoreCase(string)) continue;
                return (ENUMTYPE)enum_;
            }
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDCaseInsensitiveOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + string + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrNull(@Nonnull Class<ENUMTYPE> clazz, int n) {
        return EnumHelper.getFromIDOrDefault(clazz, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrDefault(@Nonnull Class<ENUMTYPE> clazz, int n, @Nullable ENUMTYPE ENUMTYPE) {
        Object[] objectArray;
        ValueEnforcer.notNull(clazz, "Class");
        String string = clazz.getName();
        s_aRWLockInt.readLock().lock();
        try {
            objectArray = s_aIntCache.get(string);
        }
        finally {
            s_aRWLockInt.readLock().unlock();
        }
        if (objectArray == null) {
            s_aRWLockInt.writeLock().lock();
            try {
                objectArray = s_aIntCache.get(string);
                if (objectArray == null) {
                    int n2 = Integer.MAX_VALUE;
                    int n3 = Integer.MIN_VALUE;
                    for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                        int n4 = ((IHasIntID)((Object)enum_)).getID();
                        if (n4 < n2) {
                            n2 = n4;
                        }
                        if (n4 <= n3) continue;
                        n3 = n4;
                    }
                    if (n2 >= 0 && n3 <= 255) {
                        objectArray = new Object[n3 + 1];
                        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                            objectArray[((IHasIntID)((Object)enum_)).getID()] = enum_;
                        }
                    } else {
                        objectArray = NOT_CACHABLE;
                    }
                    s_aIntCache.put(string, objectArray);
                }
            }
            finally {
                s_aRWLockInt.writeLock().unlock();
            }
        }
        if (objectArray != NOT_CACHABLE) {
            if (n < 0 || n >= objectArray.length) {
                return ENUMTYPE;
            }
            return (ENUMTYPE)((Enum)GenericReflection.uncheckedCast(objectArray[n]));
        }
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            if (((IHasIntID)((Object)enum_)).getID() != n) continue;
            return (ENUMTYPE)enum_;
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrThrow(@Nonnull Class<ENUMTYPE> clazz, int n) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDOrNull(clazz, n);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + n + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromNameOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (StringHelper.hasText(string)) {
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                if (!((IHasName)((Object)enum_)).getName().equals(string)) continue;
                return (ENUMTYPE)enum_;
            }
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromNameOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve name " + string + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromNameCaseInsensitiveOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (StringHelper.hasText(string)) {
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                if (!((IHasName)((Object)enum_)).getName().equalsIgnoreCase(string)) continue;
                return (ENUMTYPE)enum_;
            }
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromNameCaseInsensitiveOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve name " + string + " within class " + clazz);
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static String getEnumID(@Nonnull Enum<?> enum_) {
        return enum_.getClass().getName() + '.' + enum_.name();
    }

    @Nonnull
    public static EChange clearCache() {
        s_aRWLockInt.writeLock().lock();
        try {
            if (s_aIntCache.isEmpty()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            s_aIntCache.clear();
        }
        finally {
            s_aRWLockInt.writeLock().unlock();
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Cache was cleared: " + EnumHelper.class.getName());
        }
        return EChange.CHANGED;
    }
}

