/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file;

import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SimpleFileIO {
    private static final SimpleFileIO s_aInstance = new SimpleFileIO();

    private SimpleFileIO() {
    }

    @Nullable
    public static byte[] getAllFileBytes(@Nullable File file) {
        return file == null ? null : StreamHelper.getAllBytes(FileHelper.getInputStream(file));
    }

    @Nullable
    public static String getFileAsString(@Nullable File file, @Nonnull Charset charset) {
        return file == null ? null : StreamHelper.getAllBytesAsString(FileHelper.getInputStream(file), charset);
    }

    @Nullable
    public static List<String> getAllFileLines(@Nullable File file, @Nonnull Charset charset) {
        return file == null ? null : StreamHelper.readStreamLines(FileHelper.getInputStream(file), charset);
    }

    public static void readFileLines(@Nullable File file, @Nonnull Charset charset, @Nonnull List<String> list) {
        if (file != null) {
            StreamHelper.readStreamLines(FileHelper.getInputStream(file), charset, list);
        }
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull byte[] byArray) {
        OutputStream outputStream = FileHelper.getOutputStream(file);
        return outputStream == null ? ESuccess.FAILURE : StreamHelper.writeStream(outputStream, byArray);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        OutputStream outputStream = FileHelper.getOutputStream(file);
        return outputStream == null ? ESuccess.FAILURE : StreamHelper.writeStream(outputStream, byArray, n, n2);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull String string, @Nonnull Charset charset) {
        OutputStream outputStream = FileHelper.getOutputStream(file);
        return outputStream == null ? ESuccess.FAILURE : StreamHelper.writeStream(outputStream, string, charset);
    }
}

