/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.format;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.format.IFormatableObject;
import com.helger.commons.format.IFormatter;
import com.helger.commons.format.IHasFormatter;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FormatableObject
implements IFormatableObject {
    private final Object m_aValue;
    private final IFormatter m_aFormatter;

    public FormatableObject(@Nullable Object object, @Nullable IFormatter iFormatter) {
        this.m_aValue = object;
        this.m_aFormatter = iFormatter;
    }

    public FormatableObject(@Nullable Object object, @Nonnull IHasFormatter iHasFormatter) {
        this(object, iHasFormatter.getFormatter());
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.m_aValue;
    }

    @Override
    @Nullable
    public IFormatter getFormatter() {
        return this.m_aFormatter;
    }

    @Override
    @Nullable
    public String getAsString() {
        return this.m_aFormatter != null ? this.m_aFormatter.getFormattedValue(this.m_aValue) : String.valueOf(this.m_aValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormatableObject formatableObject = (FormatableObject)object;
        return EqualsHelper.equals(this.m_aValue, formatableObject.m_aValue) && EqualsHelper.equals(this.m_aFormatter, formatableObject.m_aFormatter);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aValue).append(this.m_aFormatter).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_aValue).appendIfNotNull("formatter", this.m_aFormatter).toString();
    }
}

