/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.pair;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.pair.ComparatorPairFirstComparable;
import com.helger.commons.collection.pair.ComparatorPairSecondComparable;
import com.helger.commons.collection.pair.IPair;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PairHelper {
    private PairHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <V1 extends Comparable<? super V1>, V2> List<IPair<V1, V2>> getSortedByPairFirst(@Nonnull Collection<? extends IPair<V1, V2>> collection) {
        return CollectionHelper.getSorted(collection, new ComparatorPairFirstComparable());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <V1, V2 extends Comparable<? super V2>> List<IPair<V1, V2>> getSortedByPairSecond(@Nonnull Collection<? extends IPair<V1, V2>> collection) {
        return CollectionHelper.getSorted(collection, new ComparatorPairSecondComparable());
    }
}

