/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.factory.FactoryNull;
import com.helger.commons.factory.IFactory;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.ArrayList;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SafeArrayList<ELEMENTTYPE>
extends ArrayList<ELEMENTTYPE> {
    @MustImplementEqualsAndHashcode
    private final IFactory<ELEMENTTYPE> m_aFactory;

    public SafeArrayList() {
        this(new FactoryNull());
    }

    public SafeArrayList(@Nonnull IFactory<ELEMENTTYPE> iFactory) {
        this.m_aFactory = ValueEnforcer.notNull(iFactory, "Factory");
    }

    @Nonnull
    public IFactory<ELEMENTTYPE> getFactory() {
        return this.m_aFactory;
    }

    private void _ensureSize(@Nonnegative int n) {
        while (this.size() <= n) {
            this.add(this.m_aFactory.create());
        }
    }

    @Override
    public ELEMENTTYPE get(@Nonnegative int n) {
        this._ensureSize(n);
        return (ELEMENTTYPE)super.get(n);
    }

    @Override
    public ELEMENTTYPE set(@Nonnegative int n, @Nonnull ELEMENTTYPE ELEMENTTYPE) {
        this._ensureSize(n);
        return super.set(n, ELEMENTTYPE);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SafeArrayList safeArrayList = (SafeArrayList)object;
        return this.m_aFactory.equals(safeArrayList.m_aFactory);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("factory", this.m_aFactory).toString();
    }
}

