/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser.exp;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.string.StringHelper;
import java.util.Set;
import javax.annotation.Nonnull;

public class Expansion {
    protected static final String EOL = System.getProperty("line.separator", "\n");
    private int m_nLine;
    private int m_nColumn;
    private String m_sInternalName = "";
    private int m_nInternalIndex = -1;
    private Object m_parent;
    private int m_ordinalBase;
    private static long s_nextGenerationIndex = 1L;
    private long m_myGeneration = 0L;
    private boolean m_inMinimumSize = false;

    public static void reInit() {
        s_nextGenerationIndex = 1L;
    }

    public static long getNextGenerationIndex() {
        return s_nextGenerationIndex++;
    }

    public final void setInternalName(String string, int n) {
        this.m_sInternalName = string + n;
        this.m_nInternalIndex = n;
    }

    public final void setInternalNameOnly(String string) {
        this.m_sInternalName = string;
    }

    public final boolean hasNoInternalName() {
        return StringHelper.hasNoText((String)this.m_sInternalName);
    }

    public final String getInternalName() {
        return this.m_sInternalName;
    }

    public final int getInternalIndex() {
        return this.m_nInternalIndex;
    }

    private String _getSimpleName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1);
    }

    @Nonnull
    protected static StringBuilder dumpPrefix(int n) {
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        return stringBuilder;
    }

    @OverrideOnDemand
    public StringBuilder dump(int n, Set<? super Expansion> set) {
        return Expansion.dumpPrefix(n).append(System.identityHashCode(this)).append(" ").append(this._getSimpleName());
    }

    public final int getColumn() {
        return this.m_nColumn;
    }

    public final void setColumn(int n) {
        this.m_nColumn = n;
    }

    public final int getLine() {
        return this.m_nLine;
    }

    public final void setLine(int n) {
        this.m_nLine = n;
    }

    public final Object getParent() {
        return this.m_parent;
    }

    public final void setParent(Object object) {
        this.m_parent = object;
    }

    public final int getOrdinalBase() {
        return this.m_ordinalBase;
    }

    public final void setOrdinalBase(int n) {
        this.m_ordinalBase = n;
    }

    public final long getMyGeneration() {
        return this.m_myGeneration;
    }

    public final void setMyGeneration(long l) {
        this.m_myGeneration = l;
    }

    public final boolean isInMinimumSize() {
        return this.m_inMinimumSize;
    }

    public final void setInMinimumSize(boolean bl) {
        this.m_inMinimumSize = bl;
    }

    public int hashCode() {
        return this.getLine() + this.getColumn();
    }

    public String toString() {
        return "[" + this.getLine() + "," + this.getColumn() + " " + System.identityHashCode(this) + " " + this._getSimpleName() + "]";
    }
}

