/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser.exp;

import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.exp.ICCCharacter;
import javax.annotation.Nonnull;

public final class CharacterRange
implements ICCCharacter {
    private int m_nColumn;
    private int m_nLine;
    private char m_nRight;
    private char m_nLeft;

    public CharacterRange(char c, char c2) {
        if (c > c2) {
            JavaCCErrors.semantic_error(this, "Invalid range : \"" + c + "\" - \"" + c2 + "\". First character shoud be less than or equal to the second one in a range.");
        }
        this.setLeft(c);
        this.setRight(c2);
    }

    public CharacterRange(@Nonnull Token token, char c, char c2) {
        this(c, c2);
        this.m_nLine = token.beginLine;
        this.m_nColumn = token.beginColumn;
    }

    public int getLine() {
        return this.m_nLine;
    }

    public int getColumn() {
        return this.m_nColumn;
    }

    public char getLeft() {
        return this.m_nLeft;
    }

    public void setLeft(char c) {
        this.m_nLeft = c;
    }

    public char getRight() {
        return this.m_nRight;
    }

    public void setRight(char c) {
        this.m_nRight = c;
    }

    public boolean isInRange(char c) {
        return c >= this.m_nLeft && c <= this.m_nRight;
    }

    public boolean isSubRangeOf(@Nonnull CharacterRange characterRange) {
        return this.m_nLeft >= characterRange.getLeft() && this.m_nRight <= characterRange.getRight();
    }
}

