/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.MetaParseException;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.ParseEngine;
import com.helger.pgcc.parser.ParseGenJava;
import com.helger.pgcc.parser.Token;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ParseGenCPP
extends ParseGenJava {
    public void start() throws MetaParseException {
        Object object;
        String[] stringArray;
        Object object2;
        if (JavaCCErrors.getErrorCount() != 0) {
            throw new MetaParseException("Error count is already present!");
        }
        ArrayList<String> arrayList = new ArrayList<String>(JavaCCGlobals.s_toolNames);
        arrayList.add("ParserGeneratorCC");
        this.switchToStaticsFile();
        this.switchToIncludeFile();
        this.genCodeLine("#include \"JavaCC.h\"");
        this.genCodeLine("#include \"CharStream.h\"");
        this.genCodeLine("#include \"Token.h\"");
        this.genCodeLine("#include \"TokenManager.h\"");
        Object object3 = Options.objectValue("PARSER_INCLUDES");
        if (object3 instanceof String) {
            object2 = (String)object3;
            if (((String)object2).length() > 0) {
                if (((String)object2).charAt(0) == '<') {
                    this.genCodeLine("#include " + (String)object2);
                } else {
                    this.genCodeLine("#include \"" + (String)object2 + "\"");
                }
            }
        } else if (object3 instanceof List) {
            for (Object object4 : (List)object3) {
                if (((String)object4).length() <= 0) continue;
                if (((String)object4).charAt(0) == '<') {
                    this.genCodeLine("#include " + (String)object4);
                    continue;
                }
                this.genCodeLine("#include \"" + (String)object4 + "\"");
            }
        }
        this.genCodeLine("#include \"" + JavaCCGlobals.s_cu_name + "Constants.h\"");
        if (JavaCCGlobals.s_jjtreeGenerated) {
            this.genCodeLine("#include \"JJT" + JavaCCGlobals.s_cu_name + "State.h\"");
        }
        this.genCodeLine("#include \"ErrorHandler.h\"");
        if (JavaCCGlobals.s_jjtreeGenerated) {
            this.genCodeLine("#include \"" + JavaCCGlobals.s_cu_name + "Tree.h\"");
        }
        if (Options.stringValue("NAMESPACE").length() > 0) {
            this.genCodeLine("namespace " + Options.stringValue("NAMESPACE_OPEN"));
        }
        this.genCodeLine("  struct JJCalls {");
        this.genCodeLine("    int        gen;");
        this.genCodeLine("    int        arg;");
        this.genCodeLine("    JJCalls*   next;");
        this.genCodeLine("    Token*     first;");
        this.genCodeLine("    ~JJCalls() { if (next) delete next; }");
        this.genCodeLine("     JJCalls() { next = nullptr; arg = 0; gen = -1; first = nullptr; }");
        this.genCodeLine("  };");
        this.genCodeNewLine();
        object2 = Options.stringValue("PARSER_SUPER_CLASS");
        String[] stringArray2 = new String[]{};
        if (object2 == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "public " + (String)object2;
        }
        this.genClassStart("", JavaCCGlobals.s_cu_name, stringArray2, stringArray);
        this.switchToMainFile();
        if (JavaCCGlobals.CU_TO_INSERTION_POINT_2.size() != 0) {
            this.printTokenSetup((Token)JavaCCGlobals.CU_TO_INSERTION_POINT_2.get(0));
            for (Token token : JavaCCGlobals.CU_TO_INSERTION_POINT_2) {
                this.printToken(token);
            }
        }
        this.switchToMainFile();
        this.genCodeNewLine();
        this.genCodeNewLine();
        new ParseEngine().build(this);
        this.switchToIncludeFile();
        this.genCodeNewLine();
        this.genCodeLine("public: ");
        this.genCodeLine("  void setErrorHandler(ErrorHandler *eh) {");
        this.genCodeLine("    if (errorHandler) delete errorHandler;");
        this.genCodeLine("    errorHandler = eh;");
        this.genCodeLine("  }");
        this.genCodeNewLine();
        this.genCodeLine("  TokenManager *token_source = nullptr;");
        this.genCodeLine("  CharStream   *jj_input_stream = nullptr;");
        this.genCodeLine("  /** Current token. */");
        this.genCodeLine("  Token        *token = nullptr;");
        this.genCodeLine("  /** Next token. */");
        this.genCodeLine("  Token        *jj_nt = nullptr;");
        this.genCodeNewLine();
        this.genCodeLine("private: ");
        this.genCodeLine("  int           jj_ntk;");
        this.genCodeLine("  JJCalls       jj_2_rtns[" + (JavaCCGlobals.s_jj2index + 1) + "];");
        this.genCodeLine("  bool          jj_rescan;");
        this.genCodeLine("  int           jj_gc;");
        this.genCodeLine("  Token        *jj_scanpos, *jj_lastpos;");
        this.genCodeLine("  int           jj_la;");
        this.genCodeLine("  /** Whether we are looking ahead. */");
        this.genCodeLine("  bool          jj_lookingAhead;");
        this.genCodeLine("  bool          jj_semLA;");
        this.genCodeLine("  int           jj_gen;");
        this.genCodeLine("  int           jj_la1[" + (JavaCCGlobals.s_maskindex + 1) + "];");
        this.genCodeLine("  ErrorHandler *errorHandler = nullptr;");
        this.genCodeNewLine();
        this.genCodeLine("protected: ");
        this.genCodeLine("  bool          hasError;");
        this.genCodeNewLine();
        int n = (JavaCCGlobals.s_tokenCount - 1) / 32 + 1;
        if (Options.isErrorReporting() && n > 0) {
            this.switchToStaticsFile();
            for (int i = 0; i < n; ++i) {
                if (JavaCCGlobals.MASK_VALS.size() <= 0) continue;
                this.genCodeLine("  unsigned int jj_la1_" + i + "[] = {");
                for (Object object5 : JavaCCGlobals.MASK_VALS) {
                    this.genCode("0x" + Integer.toHexString(object5[i]) + ",");
                }
                this.genCodeLine("};");
            }
        }
        if (Options.hasDepthLimit()) {
            this.genCodeLine("  private: int jj_depth;");
            this.genCodeLine("  private: bool jj_depth_error;");
            this.genCodeLine("  friend class __jj_depth_inc;");
            this.genCodeLine("  class __jj_depth_inc {public:");
            this.genCodeLine("    " + JavaCCGlobals.s_cu_name + "* parent;");
            this.genCodeLine("    __jj_depth_inc(" + JavaCCGlobals.s_cu_name + "* p): parent(p) { parent->jj_depth++; };");
            this.genCodeLine("    ~__jj_depth_inc(){ parent->jj_depth--; }");
            this.genCodeLine("  };");
        }
        if (Options.hasCPPStackLimit()) {
            this.genCodeLine("  public: size_t jj_stack_limit;");
            this.genCodeLine("  private: void* jj_stack_base;");
            this.genCodeLine("  private: bool jj_stack_error;");
        }
        this.genCodeNewLine();
        this.genCodeLine("  /** Constructor with user supplied TokenManager. */");
        this.switchToIncludeFile();
        this.genCodeLine("  Token *head; ");
        this.genCodeLine("public: ");
        this.generateMethodDefHeader(" ", JavaCCGlobals.s_cu_name, JavaCCGlobals.s_cu_name + "(TokenManager *tokenManager)");
        if (object2 != null) {
            this.genCodeLine(" : " + (String)object2 + "()");
        }
        this.genCodeLine("{");
        this.genCodeLine("    head = nullptr;");
        this.genCodeLine("    ReInit(tokenManager);");
        if (Options.isTokenManagerUsesParser()) {
            this.genCodeLine("    tokenManager->setParser(this);");
        }
        this.genCodeLine("}");
        this.switchToIncludeFile();
        this.genCodeLine("  virtual ~" + JavaCCGlobals.s_cu_name + "();");
        this.switchToMainFile();
        this.genCodeLine(JavaCCGlobals.s_cu_name + "::~" + JavaCCGlobals.s_cu_name + "()");
        this.genCodeLine("{");
        this.genCodeLine("  clear();");
        this.genCodeLine("}");
        this.generateMethodDefHeader("void", JavaCCGlobals.s_cu_name, "ReInit(TokenManager* tokenManager)");
        this.genCodeLine("{");
        this.genCodeLine("    clear();");
        this.genCodeLine("    errorHandler = new ErrorHandler();");
        this.genCodeLine("    hasError = false;");
        this.genCodeLine("    token_source = tokenManager;");
        this.genCodeLine("    head = token = new Token();");
        this.genCodeLine("    token->kind = 0;");
        this.genCodeLine("    token->next = nullptr;");
        this.genCodeLine("    jj_lookingAhead = false;");
        this.genCodeLine("    jj_rescan = false;");
        this.genCodeLine("    jj_done = false;");
        this.genCodeLine("    jj_scanpos = jj_lastpos = nullptr;");
        this.genCodeLine("    jj_gc = 0;");
        this.genCodeLine("    jj_kind = -1;");
        this.genCodeLine("    indent = 0;");
        this.genCodeLine("    trace = " + Options.isDebugParser() + ";");
        if (Options.hasCPPStackLimit()) {
            this.genCodeLine("    jj_stack_limit = " + Options.getCPPStackLimit() + ";");
            this.genCodeLine("    jj_stack_error = jj_stack_check(true);");
        }
        if (Options.isCacheTokens()) {
            this.genCodeLine("    token->next = jj_nt = token_source->getNextToken();");
        } else {
            this.genCodeLine("    jj_ntk = -1;");
        }
        if (JavaCCGlobals.s_jjtreeGenerated) {
            this.genCodeLine("    jjtree.reset();");
        }
        if (Options.hasDepthLimit()) {
            this.genCodeLine("    jj_depth = 0;");
            this.genCodeLine("    jj_depth_error = false;");
        }
        if (Options.isErrorReporting()) {
            this.genCodeLine("    jj_gen = 0;");
            if (JavaCCGlobals.s_maskindex > 0) {
                this.genCodeLine("    for (int i = 0; i < " + JavaCCGlobals.s_maskindex + "; i++) jj_la1[i] = -1;");
            }
        }
        this.genCodeLine("  }");
        this.genCodeNewLine();
        this.generateMethodDefHeader("void", JavaCCGlobals.s_cu_name, "clear()");
        this.genCodeLine("{");
        this.genCodeLine("  //Since token manager was generate from outside,");
        this.genCodeLine("  //parser should not take care of deleting");
        this.genCodeLine("  //if (token_source) delete token_source;");
        this.genCodeLine("  if (head) {");
        this.genCodeLine("    Token *next, *t = head;");
        this.genCodeLine("    while (t) {");
        this.genCodeLine("      next = t->next;");
        this.genCodeLine("      delete t;");
        this.genCodeLine("      t = next;");
        this.genCodeLine("    }");
        this.genCodeLine("  }");
        this.genCodeLine("  if (errorHandler) {");
        this.genCodeLine("    delete errorHandler, errorHandler = nullptr;");
        this.genCodeLine("  }");
        if (Options.hasDepthLimit()) {
            this.genCodeLine("  assert(jj_depth==0);");
        }
        this.genCodeLine("}");
        this.genCodeNewLine();
        if (Options.hasCPPStackLimit()) {
            this.genCodeNewLine();
            this.switchToIncludeFile();
            this.genCodeLine(" virtual");
            this.switchToMainFile();
            this.generateMethodDefHeader("bool ", JavaCCGlobals.s_cu_name, "jj_stack_check(bool init)");
            this.genCodeLine("  {");
            this.genCodeLine("     if(init) {");
            this.genCodeLine("       jj_stack_base = nullptr;");
            this.genCodeLine("       return false;");
            this.genCodeLine("     } else {");
            this.genCodeLine("       volatile int q = 0;");
            this.genCodeLine("       if(!jj_stack_base) {");
            this.genCodeLine("         jj_stack_base = (void*)&q;");
            this.genCodeLine("         return false;");
            this.genCodeLine("       } else {");
            this.genCodeLine("         // Stack can grow in both directions, depending on arch");
            this.genCodeLine("         std::ptrdiff_t used = (char*)jj_stack_base-(char*)&q;");
            this.genCodeLine("         return (std::abs(used) > jj_stack_limit);");
            this.genCodeLine("       }");
            this.genCodeLine("     }");
            this.genCodeLine("  }");
        }
        this.generateMethodDefHeader("Token *", JavaCCGlobals.s_cu_name, "jj_consume_token(int kind)", "ParseException");
        this.genCodeLine("  {");
        if (Options.hasCPPStackLimit()) {
            this.genCodeLine("    if(kind != -1 && (jj_stack_error || jj_stack_check(false))) {");
            this.genCodeLine("      if (!jj_stack_error) {");
            this.genCodeLine("        errorHandler->handleOtherError(\"Stack overflow while trying to parse\", this);");
            this.genCodeLine("        jj_stack_error=true;");
            this.genCodeLine("      }");
            this.genCodeLine("      return jj_consume_token(-1);");
            this.genCodeLine("    }");
        }
        if (Options.isCacheTokens()) {
            this.genCodeLine("    Token *oldToken = token;");
            this.genCodeLine("    if ((token = jj_nt)->next != nullptr) jj_nt = jj_nt->next;");
            this.genCodeLine("    else jj_nt = jj_nt->next = token_source->getNextToken();");
        } else {
            this.genCodeLine("    Token *oldToken;");
            this.genCodeLine("    if ((oldToken = token)->next != nullptr) token = token->next;");
            this.genCodeLine("    else token = token->next = token_source->getNextToken();");
            this.genCodeLine("    jj_ntk = -1;");
        }
        this.genCodeLine("    if (token->kind == kind) {");
        if (Options.isErrorReporting()) {
            this.genCodeLine("      jj_gen++;");
            if (JavaCCGlobals.s_jj2index != 0) {
                this.genCodeLine("      if (++jj_gc > 100) {");
                this.genCodeLine("        jj_gc = 0;");
                this.genCodeLine("        for (int i = 0; i < " + JavaCCGlobals.s_jj2index + "; i++) {");
                this.genCodeLine("          JJCalls *c = &jj_2_rtns[i];");
                this.genCodeLine("          while (c != nullptr) {");
                this.genCodeLine("            if (c->gen < jj_gen) c->first = nullptr;");
                this.genCodeLine("            c = c->next;");
                this.genCodeLine("          }");
                this.genCodeLine("        }");
                this.genCodeLine("      }");
            }
        }
        if (Options.isDebugParser()) {
            this.genCodeLine("      trace_token(token, \"\");");
        }
        this.genCodeLine("      return token;");
        this.genCodeLine("    }");
        if (Options.isCacheTokens()) {
            this.genCodeLine("    jj_nt = token;");
        }
        this.genCodeLine("    token = oldToken;");
        if (Options.isErrorReporting()) {
            this.genCodeLine("    jj_kind = kind;");
        }
        if (Options.hasCPPStackLimit()) {
            this.genCodeLine("    if (!jj_stack_error) {");
        }
        this.genCodeLine("    JJString image = kind >= 0 ? tokenImage[kind] : tokenImage[0];");
        this.genCodeLine("    errorHandler->handleUnexpectedToken(kind, image.substr(1, image.size() - 2), getToken(1), this);");
        if (Options.hasCPPStackLimit()) {
            this.genCodeLine("    }");
        }
        this.genCodeLine("    hasError = true;");
        this.genCodeLine("    return token;");
        this.genCodeLine("  }");
        this.genCodeNewLine();
        if (JavaCCGlobals.s_jj2index != 0) {
            this.switchToMainFile();
            this.generateMethodDefHeader("bool ", JavaCCGlobals.s_cu_name, "jj_scan_token(int kind)");
            this.genCodeLine("{");
            if (Options.hasCPPStackLimit()) {
                this.genCodeLine("    if(kind != -1 && (jj_stack_error || jj_stack_check(false))) {");
                this.genCodeLine("      if (!jj_stack_error) {");
                this.genCodeLine("        errorHandler->handleOtherError(\"Stack overflow while trying to parse\", this);");
                this.genCodeLine("        jj_stack_error=true;");
                this.genCodeLine("      }");
                this.genCodeLine("      return jj_consume_token(-1);");
                this.genCodeLine("    }");
            }
            this.genCodeLine("    if (jj_scanpos == jj_lastpos) {");
            this.genCodeLine("      jj_la--;");
            this.genCodeLine("      if (jj_scanpos->next == nullptr) {");
            this.genCodeLine("        jj_lastpos = jj_scanpos = jj_scanpos->next = token_source->getNextToken();");
            this.genCodeLine("      } else {");
            this.genCodeLine("        jj_lastpos = jj_scanpos = jj_scanpos->next;");
            this.genCodeLine("      }");
            this.genCodeLine("    } else {");
            this.genCodeLine("      jj_scanpos = jj_scanpos->next;");
            this.genCodeLine("    }");
            if (Options.isErrorReporting()) {
                this.genCodeLine("    if (jj_rescan) {");
                this.genCodeLine("      int i = 0; Token *tok = token;");
                this.genCodeLine("      while (tok != nullptr && tok != jj_scanpos) { i++; tok = tok->next; }");
                this.genCodeLine("      if (tok != nullptr) jj_add_error_token(kind, i);");
                if (Options.isDebugLookahead()) {
                    this.genCodeLine("    } else {");
                    this.genCodeLine("      trace_scan(jj_scanpos, kind);");
                }
                this.genCodeLine("    }");
            } else if (Options.isDebugLookahead()) {
                this.genCodeLine("    trace_scan(jj_scanpos, kind);");
            }
            this.genCodeLine("    if (jj_scanpos->kind != kind) return true;");
            this.genCodeLine("    if (jj_la == 0 && jj_scanpos == jj_lastpos) { return jj_done = true; }");
            this.genCodeLine("    return false;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
        }
        this.genCodeNewLine();
        this.genCodeLine("/** Get the next Token. */");
        this.generateMethodDefHeader("Token *", JavaCCGlobals.s_cu_name, "getNextToken()");
        this.genCodeLine("{");
        if (Options.isCacheTokens()) {
            this.genCodeLine("    if ((token = jj_nt)->next != nullptr) jj_nt = jj_nt->next;");
            this.genCodeLine("    else jj_nt = jj_nt->next = token_source->getNextToken();");
        } else {
            this.genCodeLine("    if (token->next != nullptr) token = token->next;");
            this.genCodeLine("    else token = token->next = token_source->getNextToken();");
            this.genCodeLine("    jj_ntk = -1;");
        }
        if (Options.isErrorReporting()) {
            this.genCodeLine("    jj_gen++;");
        }
        if (Options.isDebugParser()) {
            this.genCodeLine("      trace_token(token, \" (in getNextToken)\");");
        }
        this.genCodeLine("    return token;");
        this.genCodeLine("  }");
        this.genCodeNewLine();
        this.genCodeLine("/** Get the specific Token. */");
        this.generateMethodDefHeader("Token *", JavaCCGlobals.s_cu_name, "getToken(int index)");
        this.genCodeLine("{");
        if (JavaCCGlobals.isLookAheadNeeded()) {
            this.genCodeLine("    Token *t = jj_lookingAhead ? jj_scanpos : token;");
        } else {
            this.genCodeLine("    Token *t = token;");
        }
        this.genCodeLine("    for (int i = 0; i < index; i++) {");
        this.genCodeLine("      if (t->next != nullptr) t = t->next;");
        this.genCodeLine("      else t = t->next = token_source->getNextToken();");
        this.genCodeLine("    }");
        this.genCodeLine("    return t;");
        this.genCodeLine("  }");
        this.genCodeNewLine();
        if (!Options.isCacheTokens()) {
            this.generateMethodDefHeader("int", JavaCCGlobals.s_cu_name, "jj_ntk_f()");
            this.genCodeLine("{");
            this.genCodeLine("    if ((jj_nt=token->next) == nullptr)");
            this.genCodeLine("      return (jj_ntk = (token->next=token_source->getNextToken())->kind);");
            this.genCodeLine("    else");
            this.genCodeLine("      return (jj_ntk = jj_nt->kind);");
            this.genCodeLine("  }");
            this.genCodeNewLine();
        }
        this.switchToIncludeFile();
        this.genCodeLine("private:");
        this.genCodeLine("  int jj_kind;");
        if (Options.isErrorReporting()) {
            this.genCodeLine("  int **jj_expentries;");
            this.genCodeLine("  int *jj_expentry;");
            if (JavaCCGlobals.s_jj2index != 0) {
                this.switchToStaticsFile();
                this.genCodeNewLine();
                this.generateMethodDefHeader("  void", JavaCCGlobals.s_cu_name, "jj_add_error_token(int kind, int pos)");
                this.genCodeLine("  {");
                this.genCodeLine("  }");
            }
            this.genCodeNewLine();
            this.switchToIncludeFile();
            this.genCodeLine("protected:");
            this.genCodeLine("  /** Generate ParseException. */");
            this.generateMethodDefHeader("  virtual void ", JavaCCGlobals.s_cu_name, "parseError()");
            this.genCodeLine("   {");
            if (Options.isErrorReporting()) {
                this.genCodeLine("      fprintf(stderr, \"Parse error at: %d:%d, after token: %s encountered: %s\\n\", token->beginLine, token->beginColumn, addUnicodeEscapes(token->image).c_str(), addUnicodeEscapes(getToken(1)->image).c_str());");
            }
            this.genCodeLine("   }");
        } else {
            this.genCodeLine("protected:");
            this.genCodeLine("  /** Generate ParseException. */");
            this.generateMethodDefHeader("virtual void ", JavaCCGlobals.s_cu_name, "parseError()");
            this.genCodeLine("   {");
            if (Options.isErrorReporting()) {
                this.genCodeLine("      fprintf(stderr, \"Parse error at: %d:%d, after token: %s encountered: %s\\n\", token->beginLine, token->beginColumn, addUnicodeEscapes(token->image).c_str(), addUnicodeEscapes(getToken(1)->image).c_str());");
            }
            this.genCodeLine("   }");
        }
        this.genCodeNewLine();
        this.switchToIncludeFile();
        this.genCodeLine("private:");
        this.genCodeLine("  int  indent;\t// trace indentation");
        this.genCodeLine("  bool trace = " + Options.isDebugParser() + "; // trace enabled if true");
        this.genCodeNewLine();
        this.genCodeLine("public:");
        this.generateMethodDefHeader("  bool", JavaCCGlobals.s_cu_name, "trace_enabled()");
        this.genCodeLine("  {");
        this.genCodeLine("    return trace;");
        this.genCodeLine("  }");
        this.genCodeNewLine();
        if (Options.isDebugParser()) {
            this.switchToIncludeFile();
            this.generateMethodDefHeader("  void", JavaCCGlobals.s_cu_name, "enable_tracing()");
            this.genCodeLine("{");
            this.genCodeLine("    trace = true;");
            this.genCodeLine("}");
            this.genCodeNewLine();
            this.switchToIncludeFile();
            this.generateMethodDefHeader("  void", JavaCCGlobals.s_cu_name, "disable_tracing()");
            this.genCodeLine("{");
            this.genCodeLine("    trace = false;");
            this.genCodeLine("}");
            this.genCodeNewLine();
            this.switchToIncludeFile();
            this.generateMethodDefHeader("  void", JavaCCGlobals.s_cu_name, "trace_call(const char *s)");
            this.genCodeLine("  {");
            this.genCodeLine("    if (trace_enabled()) {");
            this.genCodeLine("      for (int i = 0; i < indent; i++) { printf(\" \"); }");
            this.genCodeLine("      printf(\"Call:   %s\\n\", s);");
            this.genCodeLine("    }");
            this.genCodeLine("    indent = indent + 2;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.switchToIncludeFile();
            this.generateMethodDefHeader("  void", JavaCCGlobals.s_cu_name, "trace_return(const char *s)");
            this.genCodeLine("  {");
            this.genCodeLine("    indent = indent - 2;");
            this.genCodeLine("    if (trace_enabled()) {");
            this.genCodeLine("      for (int i = 0; i < indent; i++) { printf(\" \"); }");
            this.genCodeLine("      printf(\"Return: %s\\n\", s);");
            this.genCodeLine("    }");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.switchToIncludeFile();
            this.generateMethodDefHeader("  void", JavaCCGlobals.s_cu_name, "trace_token(Token *t, const char *where)");
            this.genCodeLine("  {");
            this.genCodeLine("    if (trace_enabled()) {");
            this.genCodeLine("      for (int i = 0; i < indent; i++) { printf(\" \"); }");
            this.genCodeLine("      printf(\"Consumed token: <kind: %d(%s), \\\"%s\\\"\", t->kind, addUnicodeEscapes(tokenImage[t->kind]).c_str(), addUnicodeEscapes(t->image).c_str());");
            this.genCodeLine("      printf(\" at line %d column %d> %s\\n\", t->beginLine, t->beginColumn, where);");
            this.genCodeLine("    }");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.switchToIncludeFile();
            this.generateMethodDefHeader("  void", JavaCCGlobals.s_cu_name, "trace_scan(Token *t1, int t2)");
            this.genCodeLine("  {");
            this.genCodeLine("    if (trace_enabled()) {");
            this.genCodeLine("      for (int i = 0; i < indent; i++) { printf(\" \"); }");
            this.genCodeLine("      printf(\"Visited token: <Kind: %d(%s), \\\"%s\\\"\", t1->kind, addUnicodeEscapes(tokenImage[t1->kind]).c_str(), addUnicodeEscapes(t1->image).c_str());");
            this.genCodeLine("      printf(\" at line %d column %d>; Expected token: %s\\n\", t1->beginLine, t1->beginColumn, addUnicodeEscapes(tokenImage[t2]).c_str());");
            this.genCodeLine("    }");
            this.genCodeLine("  }");
            this.genCodeNewLine();
        } else {
            this.switchToIncludeFile();
            this.generateMethodDefHeader("  void", JavaCCGlobals.s_cu_name, "enable_tracing()");
            this.genCodeLine("  {");
            this.genCodeLine("  }");
            this.switchToIncludeFile();
            this.generateMethodDefHeader("  void", JavaCCGlobals.s_cu_name, "disable_tracing()");
            this.genCodeLine("  {");
            this.genCodeLine("  }");
            this.genCodeNewLine();
        }
        if (JavaCCGlobals.s_jj2index != 0 && Options.isErrorReporting()) {
            this.generateMethodDefHeader("  void", JavaCCGlobals.s_cu_name, "jj_rescan_token()");
            this.genCodeLine("{");
            this.genCodeLine("    jj_rescan = true;");
            this.genCodeLine("    for (int i = 0; i < " + JavaCCGlobals.s_jj2index + "; i++) {");
            this.genCodeLine("      JJCalls *p = &jj_2_rtns[i];");
            this.genCodeLine("      do {");
            this.genCodeLine("        if (p->gen > jj_gen) {");
            this.genCodeLine("          jj_la = p->arg; jj_lastpos = jj_scanpos = p->first;");
            this.genCodeLine("          switch (i) {");
            for (int i = 0; i < JavaCCGlobals.s_jj2index; ++i) {
                this.genCodeLine("            case " + i + ": jj_3_" + (i + 1) + "(); break;");
            }
            this.genCodeLine("          }");
            this.genCodeLine("        }");
            this.genCodeLine("        p = p->next;");
            this.genCodeLine("      } while (p != nullptr);");
            this.genCodeLine("    }");
            this.genCodeLine("    jj_rescan = false;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.generateMethodDefHeader("  void", JavaCCGlobals.s_cu_name, "jj_save(int index, int xla)");
            this.genCodeLine("{");
            this.genCodeLine("    JJCalls *p = &jj_2_rtns[index];");
            this.genCodeLine("    while (p->gen > jj_gen) {");
            this.genCodeLine("      if (p->next == nullptr) { p = p->next = new JJCalls(); break; }");
            this.genCodeLine("      p = p->next;");
            this.genCodeLine("    }");
            this.genCodeLine("    p->gen = jj_gen + xla - jj_la; p->first = token; p->arg = xla;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
        }
        if (JavaCCGlobals.CU_FROM_INSERTION_POINT_2.isNotEmpty()) {
            this.printTokenSetup((Token)JavaCCGlobals.CU_FROM_INSERTION_POINT_2.get(0));
            this.setColToStart();
            Object object6 = null;
            object = JavaCCGlobals.CU_FROM_INSERTION_POINT_2.iterator();
            while (object.hasNext()) {
                Object object5;
                object6 = object5 = (Object)((Token)object.next());
                this.printToken((Token)object6);
            }
            this.printTrailingComments((Token)object6);
        }
        this.genCodeNewLine();
        this.switchToIncludeFile();
        Token token = JavaCCGlobals.getOtherLanguageDeclTokenBegin();
        object = JavaCCGlobals.getOtherLanguageDeclTokenEnd();
        while (token != object) {
            this.printToken(token);
            token = token.next;
        }
        this.genCodeLine("\n");
        if (JavaCCGlobals.s_jjtreeGenerated) {
            this.genCodeLine("  JJT" + JavaCCGlobals.s_cu_name + "State jjtree;");
        }
        this.genCodeLine("private:");
        this.genCodeLine("  bool jj_done;");
        this.genCodeLine("};");
        this.saveOutput(Options.getOutputDirectory() + File.separator + JavaCCGlobals.s_cu_name + JavaCCGlobals.getFileExtension());
    }

    public static void reInit() {
        JavaCCGlobals.setLookAheadNeeded(false);
    }
}

