/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.utils;

import com.helger.commons.compare.IComparable;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.pgcc.utils.EOptionType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OptionInfo
implements IComparable<OptionInfo> {
    private final String m_name;
    private final EOptionType m_type;
    private final Comparable<?> m_default;

    public OptionInfo(@Nonnull String string, @Nonnull EOptionType eOptionType, @Nullable Comparable<?> comparable) {
        this.m_name = string;
        this.m_type = eOptionType;
        this.m_default = comparable;
    }

    @Nonnull
    public String getName() {
        return this.m_name;
    }

    @Nonnull
    public EOptionType getType() {
        return this.m_type;
    }

    @Nullable
    public Comparable<?> getDefault() {
        return this.m_default;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_name).append((Enum)this.m_type).append(this.m_default).getHashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        OptionInfo optionInfo = (OptionInfo)object;
        return this.m_name.equals(optionInfo.m_name) && this.m_type.equals((Object)optionInfo.m_type) && EqualsHelper.equals(this.m_default, optionInfo.m_default);
    }

    public int compareTo(OptionInfo optionInfo) {
        return this.m_name.compareTo(optionInfo.m_name);
    }
}

