/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.commons.string.StringHelper;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.parser.CodeGenerator;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.TokenManagerCodeGenerator;
import com.helger.pgcc.parser.TokenizerData;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TableDrivenJavaCodeGenerator
implements TokenManagerCodeGenerator {
    private static final String TokenManagerTemplate = "/templates/TableDrivenTokenManager.template";
    private final CodeGenerator m_codeGenerator = new CodeGenerator();

    @Override
    public void generateCode(TokenizerData tokenizerData) {
        block2: {
            String string = (String)Options.getAllOptions().get("TOKEN_MANAGER_SUPER_CLASS");
            Map<String, Object> map = Options.getAllOptions();
            map.put("maxOrdinal", tokenizerData.m_allMatches.size());
            map.put("maxLexStates", tokenizerData.m_lexStateNames.length);
            map.put("stateSetSize", tokenizerData.m_nfa.size());
            map.put("parserName", tokenizerData.m_parserName);
            map.put("maxLongs", tokenizerData.m_allMatches.size() / 64 + 1);
            map.put("parserName", tokenizerData.m_parserName);
            map.put("charStreamName", CodeGenerator.getCharStreamName());
            map.put("defaultLexState", tokenizerData.m_defaultLexState);
            map.put("decls", tokenizerData.m_decls);
            map.put("superClass", StringHelper.hasNoText((String)string) ? "" : "extends " + string);
            map.put("noDfa", Options.isNoDfa());
            map.put("generatedStates", tokenizerData.m_nfa.size());
            try {
                this.m_codeGenerator.writeTemplate(TokenManagerTemplate, map);
                this._dumpDfaTables(this.m_codeGenerator, tokenizerData);
                this.dumpNfaTables(this.m_codeGenerator, tokenizerData);
                this._dumpMatchInfo(this.m_codeGenerator, tokenizerData);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void finish(TokenizerData tokenizerData) {
        this.m_codeGenerator.genCodeLine("\n}");
        if (!Options.isBuildParser()) {
            return;
        }
        String string = Options.getOutputDirectory() + File.separator + tokenizerData.m_parserName + "TokenManager.java";
        this.m_codeGenerator.saveOutput(string);
    }

    private void _dumpDfaTables(CodeGenerator codeGenerator, TokenizerData tokenizerData) {
        int[] nArray;
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        int n = 0;
        codeGenerator.genCodeLine("private static final int[] stringLiterals = {");
        for (int n2 : tokenizerData.m_literalSequence.keySet()) {
            nArray = new int[2];
            List<String> list = tokenizerData.m_literalSequence.get(n2);
            List<Integer> list2 = tokenizerData.m_literalKinds.get(n2);
            nArray[0] = n;
            nArray[1] = list.size();
            int n3 = 0;
            if (n > 0) {
                codeGenerator.genCodeLine(", ");
            }
            for (String string : list) {
                int n4;
                if (n3 > 0) {
                    codeGenerator.genCodeLine(", ");
                }
                codeGenerator.genCode(Integer.toString(string.length()));
                for (n4 = 0; n4 < string.length(); ++n4) {
                    codeGenerator.genCode(", ");
                    codeGenerator.genCode(Integer.toString(string.charAt(n4)));
                    ++n;
                }
                n4 = list2.get(n3);
                codeGenerator.genCode(", " + n4);
                codeGenerator.genCode(", " + tokenizerData.m_kindToNfaStartState.get(n4));
                n += 3;
                ++n3;
            }
            hashMap.put(n2, nArray);
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final java.util.Map<Integer, int[]> startAndSize =\n    new java.util.HashMap<Integer, int[]>();");
        codeGenerator.genCodeLine("static {");
        for (int n2 : tokenizerData.m_literalSequence.keySet()) {
            nArray = (int[])hashMap.get(n2);
            codeGenerator.genCodeLine("startAndSize.put(" + n2 + ", new int[]{" + nArray[0] + ", " + nArray[1] + "});");
        }
        codeGenerator.genCodeLine("}");
    }

    private void dumpNfaTables(CodeGenerator codeGenerator, TokenizerData tokenizerData) {
        Iterator<Integer> iterator;
        int n;
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        codeGenerator.genCodeLine("private static final " + eOutputLanguage.getTypeLong() + "[][] jjCharData = {");
        Map<Integer, TokenizerData.NfaState> map = tokenizerData.m_nfa;
        for (n = 0; n < map.size(); ++n) {
            int n2;
            iterator = map.get(n);
            if (n > 0) {
                codeGenerator.genCodeLine(",");
            }
            if (iterator == null) {
                codeGenerator.genCode("{}");
                continue;
            }
            codeGenerator.genCode("{");
            BitSet bitSet = new BitSet();
            Iterator<Integer> iterator2 = ((TokenizerData.NfaState)((Object)iterator)).m_characters.iterator();
            while (iterator2.hasNext()) {
                n2 = iterator2.next().charValue();
                bitSet.set(n2);
            }
            iterator2 = (Iterator<Integer>)bitSet.toLongArray();
            for (n2 = 0; n2 < ((Object)iterator2).length; ++n2) {
                int n3 = 1;
                while (n2 + n3 < ((Object)iterator2).length && iterator2[n2 + n3] == iterator2[n2]) {
                    ++n3;
                }
                if (n2 > 0) {
                    codeGenerator.genCode(", ");
                }
                codeGenerator.genCode(n3 + ", ");
                codeGenerator.genCode(eOutputLanguage.getLongHex((long)iterator2[n2]));
                n2 += n3 - 1;
            }
            codeGenerator.genCode("}");
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final long[][] jjChars = ");
        codeGenerator.genCodeLine("    new long[" + tokenizerData.m_nfa.size() + "][(Character.MAX_VALUE >> 6) + 1]; ");
        codeGenerator.genCodeLine("static { ");
        codeGenerator.genCodeLine("  for (int i = 0; i < " + tokenizerData.m_nfa.size() + "; i++) { ");
        codeGenerator.genCodeLine("    int ind = 0; ");
        codeGenerator.genCodeLine("    for (int j = 0; j < jjCharData[i].length; j += 2) { ");
        codeGenerator.genCodeLine("      for (int k = 0; k < (int)jjCharData[i][j]; k++) { ");
        codeGenerator.genCodeLine("        jjChars[i][ind++] = jjCharData[i][j + 1]; ");
        codeGenerator.genCodeLine("      } ");
        codeGenerator.genCodeLine("    } ");
        codeGenerator.genCodeLine("  } ");
        codeGenerator.genCodeLine("} ");
        codeGenerator.genCodeLine("private static final int[][] jjcompositeState = {");
        for (n = 0; n < map.size(); ++n) {
            iterator = map.get(n);
            if (n > 0) {
                codeGenerator.genCodeLine(", ");
            }
            if (iterator == null) {
                codeGenerator.genCode("{}");
                continue;
            }
            codeGenerator.genCode("{");
            int n4 = 0;
            for (Integer n5 : ((TokenizerData.NfaState)((Object)iterator)).m_compositeStates) {
                if (n4++ > 0) {
                    codeGenerator.genCode(", ");
                }
                codeGenerator.genCode(n5.toString());
            }
            codeGenerator.genCode("}");
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final int[] jjmatchKinds = {");
        for (n = 0; n < map.size(); ++n) {
            iterator = map.get(n);
            if (n > 0) {
                codeGenerator.genCodeLine(", ");
            }
            if (iterator == null) {
                codeGenerator.genCode(Integer.toString(Integer.MAX_VALUE));
                continue;
            }
            codeGenerator.genCode(Integer.toString(((TokenizerData.NfaState)((Object)iterator)).m_kind));
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final int[][] jjnextStateSet = {");
        for (n = 0; n < map.size(); ++n) {
            iterator = map.get(n);
            if (n > 0) {
                codeGenerator.genCodeLine(", ");
            }
            if (iterator == null) {
                codeGenerator.genCode("{}");
                continue;
            }
            int n6 = 0;
            codeGenerator.genCode("{");
            for (Integer n7 : ((TokenizerData.NfaState)((Object)iterator)).m_nextStates) {
                if (n6++ > 0) {
                    codeGenerator.genCode(", ");
                }
                codeGenerator.genCode(n7.toString());
            }
            codeGenerator.genCode("}");
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final int[] jjInitStates = {");
        n = 0;
        for (Integer n8 : tokenizerData.m_initialStates.values()) {
            if (n++ > 0) {
                codeGenerator.genCode(", ");
            }
            codeGenerator.genCode(n8.toString());
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final int[] canMatchAnyChar = {");
        n = 0;
        for (Integer n9 : tokenizerData.m_wildcardKind.values()) {
            if (n++ > 0) {
                codeGenerator.genCode(", ");
            }
            codeGenerator.genCode(n9.toString());
        }
        codeGenerator.genCodeLine("};");
    }

    private void _dumpMatchInfo(CodeGenerator codeGenerator, TokenizerData tokenizerData) {
        Map<Integer, TokenizerData.MatchInfo> map = tokenizerData.m_allMatches;
        BitSet bitSet = new BitSet(map.size());
        BitSet bitSet2 = new BitSet(map.size());
        BitSet bitSet3 = new BitSet(map.size());
        BitSet bitSet4 = new BitSet(map.size());
        int[] nArray = new int[map.size()];
        bitSet.set(map.size() + 1, true);
        bitSet4.set(map.size() + 1, true);
        bitSet3.set(map.size() + 1, true);
        bitSet2.set(map.size() + 1, true);
        codeGenerator.genCodeLine("public static final String[] jjstrLiteralImages = {");
        int n = 0;
        for (Map.Entry<Integer, TokenizerData.MatchInfo> entry : map.entrySet()) {
            int n2 = entry.getKey();
            TokenizerData.MatchInfo matchInfo = entry.getValue();
            switch (matchInfo.m_matchType) {
                case SKIP: {
                    bitSet.set(n2);
                    break;
                }
                case SPECIAL_TOKEN: {
                    bitSet2.set(n2);
                    break;
                }
                case MORE: {
                    bitSet3.set(n2);
                    break;
                }
                case TOKEN: {
                    bitSet4.set(n2);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            nArray[n2] = matchInfo.m_newLexState;
            String string = matchInfo.m_image;
            if (n++ > 0) {
                codeGenerator.genCodeLine(", ");
            }
            if (string != null) {
                codeGenerator.genCode("\"");
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) <= '\u00ff') {
                        codeGenerator.genCode("\\" + Integer.toOctalString(string.charAt(i)));
                        continue;
                    }
                    String string2 = Integer.toHexString(string.charAt(i));
                    if (string2.length() == 3) {
                        string2 = "0" + string2;
                    }
                    codeGenerator.genCode("\\u" + string2);
                }
                codeGenerator.genCode("\"");
                continue;
            }
            codeGenerator.genCodeLine("null");
        }
        codeGenerator.genCodeLine("};");
        TableDrivenJavaCodeGenerator.generateBitVector("jjtoSkip", bitSet, codeGenerator);
        TableDrivenJavaCodeGenerator.generateBitVector("jjtoSpecial", bitSet2, codeGenerator);
        TableDrivenJavaCodeGenerator.generateBitVector("jjtoMore", bitSet3, codeGenerator);
        TableDrivenJavaCodeGenerator.generateBitVector("jjtoToken", bitSet4, codeGenerator);
        codeGenerator.genCodeLine("private static final int[] jjnewLexState = {");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                codeGenerator.genCode(", ");
            }
            codeGenerator.genCode("0x" + Integer.toHexString(nArray[i]));
        }
        codeGenerator.genCodeLine("};");
        String string = Options.isStatic() ? "static " : "";
        codeGenerator.genCodeLine(string + "void TokenLexicalActions(Token matchedToken) {");
        this._dumpLexicalActions(map, TokenizerData.EMatchType.TOKEN, "matchedToken.kind", codeGenerator);
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine(string + "void SkipLexicalActions(Token matchedToken) {");
        this._dumpLexicalActions(map, TokenizerData.EMatchType.SKIP, "jjmatchedKind", codeGenerator);
        this._dumpLexicalActions(map, TokenizerData.EMatchType.SPECIAL_TOKEN, "jjmatchedKind", codeGenerator);
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine(string + "void MoreLexicalActions() {");
        codeGenerator.genCodeLine("jjimageLen += (lengthOfMatch = jjmatchedPos + 1);");
        this._dumpLexicalActions(map, TokenizerData.EMatchType.MORE, "jjmatchedKind", codeGenerator);
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine("public String[] lexStateNames = {");
        for (int i = 0; i < tokenizerData.m_lexStateNames.length; ++i) {
            if (i > 0) {
                codeGenerator.genCode(", ");
            }
            codeGenerator.genCode("\"" + tokenizerData.m_lexStateNames[i] + "\"");
        }
        codeGenerator.genCodeLine("};");
    }

    private void _dumpLexicalActions(Map<Integer, TokenizerData.MatchInfo> map, TokenizerData.EMatchType eMatchType, String string, CodeGenerator codeGenerator) {
        codeGenerator.genCodeLine("  switch(" + string + ") {");
        for (int n : map.keySet()) {
            TokenizerData.MatchInfo matchInfo = map.get(n);
            if (matchInfo.m_action == null || matchInfo.m_matchType != eMatchType) continue;
            codeGenerator.genCodeLine("    case " + n + ": {\n");
            codeGenerator.genCodeLine("      " + matchInfo.m_action);
            codeGenerator.genCodeLine("      break;");
            codeGenerator.genCodeLine("    }");
        }
        codeGenerator.genCodeLine("    default: break;");
        codeGenerator.genCodeLine("  }");
    }

    private static void generateBitVector(String string, BitSet bitSet, CodeGenerator codeGenerator) {
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        codeGenerator.genCodeLine("private static final " + eOutputLanguage.getTypeLong() + "[] " + string + " = {");
        long[] lArray = bitSet.toLongArray();
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                codeGenerator.genCode(", ");
            }
            codeGenerator.genCode(eOutputLanguage.getLongHex(lArray[i]));
        }
        codeGenerator.genCodeLine("};");
    }
}

