/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.output.cpp.OtherFilesGenCPP;
import com.helger.pgcc.output.java.FilesJava;
import com.helger.pgcc.output.java.OtherFilesGenJava;
import com.helger.pgcc.parser.ExpRStringLiteral;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.JavaCCParser;
import com.helger.pgcc.parser.JavaCCParserInternals;
import com.helger.pgcc.parser.LexGenCpp;
import com.helger.pgcc.parser.LexGenJava;
import com.helger.pgcc.parser.LookaheadWalk;
import com.helger.pgcc.parser.MatchInfo;
import com.helger.pgcc.parser.MetaParseException;
import com.helger.pgcc.parser.NfaState;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.ParseException;
import com.helger.pgcc.parser.ParseGenCPP;
import com.helger.pgcc.parser.ParseGenJava;
import com.helger.pgcc.parser.Semanticize;
import com.helger.pgcc.utils.EOptionType;
import com.helger.pgcc.utils.OptionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;

public class Main {
    public static LexGenJava lg;

    protected Main() {
    }

    static void help_message() {
        System.out.println("Usage:");
        System.out.println("    javacc option-settings inputfile");
        System.out.println("");
        System.out.println("\"option-settings\" is a sequence of settings separated by spaces.");
        System.out.println("Each option setting must be of one of the following forms:");
        System.out.println("");
        System.out.println("    -optionname=value (e.g., -STATIC=false)");
        System.out.println("    -optionname:value (e.g., -STATIC:false)");
        System.out.println("    -optionname       (equivalent to -optionname=true.  e.g., -STATIC)");
        System.out.println("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOSTATIC)");
        System.out.println("");
        System.out.println("Option settings are not case-sensitive, so one can say \"-nOsTaTiC\" instead");
        System.out.println("of \"-NOSTATIC\".  Option values must be appropriate for the corresponding");
        System.out.println("option, and must be either an integer, a boolean, or a string value.");
        System.out.println("");
        Main.printOptions();
        System.out.println("EXAMPLE:");
        System.out.println("    javacc -STATIC=false -LOOKAHEAD:2 -debug_parser mygrammar.jj");
        System.out.println("");
    }

    private static void printOptions() {
        Set<OptionInfo> set = Options.getUserOptions();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (OptionInfo optionInfo : set) {
            int n4 = optionInfo.getName().length();
            if (optionInfo.getType() == EOptionType.INTEGER) {
                n = n4 > n ? n4 : n;
                continue;
            }
            if (optionInfo.getType() == EOptionType.BOOLEAN) {
                n2 = n4 > n2 ? n4 : n2;
                continue;
            }
            if (optionInfo.getType() != EOptionType.STRING) continue;
            n3 = n4 > n3 ? n4 : n3;
        }
        if (n > 0) {
            System.out.println("The integer valued options are:");
            System.out.println("");
            for (OptionInfo optionInfo : set) {
                Main.printOptionInfo(EOptionType.INTEGER, optionInfo, n);
            }
            System.out.println("");
        }
        if (n2 > 0) {
            System.out.println("The boolean valued options are:");
            System.out.println("");
            for (OptionInfo optionInfo : set) {
                Main.printOptionInfo(EOptionType.BOOLEAN, optionInfo, n2);
            }
            System.out.println("");
        }
        if (n3 > 0) {
            System.out.println("The string valued options are:");
            System.out.println("");
            for (OptionInfo optionInfo : set) {
                Main.printOptionInfo(EOptionType.STRING, optionInfo, n3);
            }
            System.out.println("");
        }
    }

    private static void printOptionInfo(EOptionType eOptionType, OptionInfo optionInfo, int n) {
        if (optionInfo.getType() == eOptionType) {
            Comparable<?> comparable = optionInfo.getDefault();
            System.out.println("    " + Main.padRight(optionInfo.getName(), n + 1) + (comparable == null ? "" : "(default : " + (comparable.toString().length() == 0 ? "<<empty>>" : comparable) + ")"));
        }
    }

    private static String padRight(String string, int n) {
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        int n3 = n - n2;
        StringBuilder stringBuilder = new StringBuilder(n3);
        stringBuilder.append(string);
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        int n = Main.mainProgram(stringArray);
        System.exit(n);
    }

    public static int mainProgram(String[] stringArray) throws Exception {
        Object object;
        Main.reInitAll();
        JavaCCGlobals.bannerLine("Parser Generator", "");
        JavaCCParser javaCCParser = null;
        if (stringArray.length == 0) {
            System.out.println("");
            Main.help_message();
            return 1;
        }
        System.out.println("(type \"javacc\" with no arguments for help)");
        if (Options.isOption(stringArray[stringArray.length - 1])) {
            System.out.println("Last argument \"" + stringArray[stringArray.length - 1] + "\" is not a filename.");
            return 1;
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!Options.isOption(stringArray[i])) {
                System.out.println("Argument \"" + stringArray[i] + "\" must be an option setting.");
                return 1;
            }
            Options.setCmdLineOption(stringArray[i]);
        }
        try {
            object = new File(stringArray[stringArray.length - 1]);
            if (!((File)object).exists()) {
                System.out.println("File " + stringArray[stringArray.length - 1] + " not found.");
                return 1;
            }
            if (((File)object).isDirectory()) {
                System.out.println(stringArray[stringArray.length - 1] + " is a directory. Please use a valid file name.");
                return 1;
            }
            javaCCParser = new JavaCCParser((Reader)new NonBlockingBufferedReader((Reader)new InputStreamReader((InputStream)new FileInputStream(stringArray[stringArray.length - 1]), Options.getGrammarEncoding())));
        }
        catch (SecurityException securityException) {
            System.out.println("Security violation while trying to open " + stringArray[stringArray.length - 1]);
            return 1;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + stringArray[stringArray.length - 1] + " not found.");
            return 1;
        }
        try {
            System.out.println("Reading from file " + stringArray[stringArray.length - 1] + " . . .");
            JavaCCGlobals.s_fileName = JavaCCGlobals.s_origFileName = stringArray[stringArray.length - 1];
            JavaCCGlobals.s_jjtreeGenerated = JavaCCGlobals.isGeneratedBy("JJTree", stringArray[stringArray.length - 1]);
            JavaCCGlobals.s_toolNames = JavaCCGlobals.getToolNames(stringArray[stringArray.length - 1]);
            javaCCParser.javacc_input();
            object = Options.getOutputLanguage();
            boolean bl = ((EOutputLanguage)((Object)object)).isJava() && Options.getJavaTemplateType().equals("modern");
            switch (1.$SwitchMap$com$helger$pgcc$output$EOutputLanguage[((Enum)object).ordinal()]) {
                case 1: {
                    lg = new LexGenJava();
                    break;
                }
                case 2: {
                    lg = new LexGenCpp();
                    break;
                }
                default: {
                    return Main.unhandledLanguageExit((EOutputLanguage)((Object)object));
                }
            }
            JavaCCGlobals.createOutputDir(Options.getOutputDirectory());
            if (Options.isUnicodeInput()) {
                NfaState.s_unicodeWarningGiven = true;
                System.out.println("Note: UNICODE_INPUT option is specified. Please make sure you create the parser/lexer using a Reader with the correct character encoding.");
            }
            Semanticize.start();
            boolean bl2 = Options.isBuildParser();
            switch (1.$SwitchMap$com$helger$pgcc$output$EOutputLanguage[((Enum)object).ordinal()]) {
                case 1: {
                    if (bl2) {
                        new ParseGenJava().start(bl);
                    }
                    new LexGenJava().start();
                    Options.setStringOption("PARSER_NAME", JavaCCGlobals.s_cu_name);
                    OtherFilesGenJava.start(bl);
                    break;
                }
                case 2: {
                    if (bl2) {
                        new ParseGenCPP().start();
                    }
                    if (bl2) {
                        new LexGenCpp().start();
                    }
                    Options.setStringOption("PARSER_NAME", JavaCCGlobals.s_cu_name);
                    OtherFilesGenCPP.start();
                    break;
                }
                default: {
                    Main.unhandledLanguageExit((EOutputLanguage)((Object)object));
                }
            }
            if (JavaCCErrors.getErrorCount() == 0 && (bl2 || Options.isBuildTokenManager())) {
                if (JavaCCErrors.getWarningCount() == 0) {
                    if (bl2) {
                        System.out.println("Parser generated successfully.");
                    }
                } else {
                    System.out.println("Parser generated with 0 errors and " + JavaCCErrors.getWarningCount() + " warnings.");
                }
                return 0;
            }
            System.out.println("Detected " + JavaCCErrors.getErrorCount() + " errors and " + JavaCCErrors.getWarningCount() + " warnings.");
            return JavaCCErrors.getErrorCount() == 0 ? 0 : 1;
        }
        catch (MetaParseException metaParseException) {
            System.out.println("Detected " + JavaCCErrors.getErrorCount() + " errors and " + JavaCCErrors.getWarningCount() + " warnings.");
            return 1;
        }
        catch (ParseException parseException) {
            System.out.println(parseException.toString());
            System.out.println("Detected " + (JavaCCErrors.getErrorCount() + 1) + " errors and " + JavaCCErrors.getWarningCount() + " warnings.");
            return 1;
        }
    }

    private static int unhandledLanguageExit(EOutputLanguage eOutputLanguage) {
        System.out.println("Invalid 'OUTPUT_LANGUAGE' specified : " + (Object)((Object)eOutputLanguage));
        return 1;
    }

    public static void reInitAll() {
        Expansion.reInit();
        JavaCCErrors.reInit();
        JavaCCGlobals.reInitStatic();
        Options.init();
        JavaCCParserInternals.reInit();
        ExpRStringLiteral.reInit();
        FilesJava.reInit();
        NfaState.reInit();
        MatchInfo.reInitStatic();
        LookaheadWalk.reInit();
        Semanticize.reInit();
        OtherFilesGenJava.reInit();
        LexGenJava.reInit();
    }
}

