/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.pgcc.parser.CharacterRange;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.SingleCharacter;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.TokenProduction;

public final class JavaCCErrors {
    private static int s_parse_error_count = 0;
    private static int s_semantic_error_count = 0;
    private static int s_warning_count = 0;

    private JavaCCErrors() {
    }

    private static void _printLocationInfo(Object object) {
        if (object instanceof NormalProduction) {
            NormalProduction normalProduction = (NormalProduction)object;
            System.err.print("Line " + normalProduction.getLine() + ", Column " + normalProduction.getColumn() + ": ");
        } else if (object instanceof TokenProduction) {
            TokenProduction tokenProduction = (TokenProduction)object;
            System.err.print("Line " + tokenProduction.getLine() + ", Column " + tokenProduction.getColumn() + ": ");
        } else if (object instanceof Expansion) {
            Expansion expansion = (Expansion)object;
            System.err.print("Line " + expansion.getLine() + ", Column " + expansion.getColumn() + ": ");
        } else if (object instanceof CharacterRange) {
            CharacterRange characterRange = (CharacterRange)object;
            System.err.print("Line " + characterRange.getLine() + ", Column " + characterRange.getColumn() + ": ");
        } else if (object instanceof SingleCharacter) {
            SingleCharacter singleCharacter = (SingleCharacter)object;
            System.err.print("Line " + singleCharacter.getLine() + ", Column " + singleCharacter.getColumn() + ": ");
        } else if (object instanceof Token) {
            Token token = (Token)object;
            System.err.print("Line " + token.beginLine + ", Column " + token.beginColumn + ": ");
        }
    }

    public static void parse_error(Object object, String string) {
        System.err.print("Error: ");
        JavaCCErrors._printLocationInfo(object);
        System.err.println(string);
        ++s_parse_error_count;
    }

    public static void parse_error(String string) {
        System.err.print("Error: ");
        System.err.println(string);
        ++s_parse_error_count;
    }

    public static int getParseErrorCount() {
        return s_parse_error_count;
    }

    public static void semantic_error(Object object, String string) {
        System.err.print("Error: ");
        JavaCCErrors._printLocationInfo(object);
        System.err.println(string);
        ++s_semantic_error_count;
    }

    public static void semantic_error(String string) {
        System.err.println("Error: " + string);
        ++s_semantic_error_count;
    }

    public static int getSemanticErrorCount() {
        return s_semantic_error_count;
    }

    public static void warning(Object object, String string) {
        System.err.print("Warning: ");
        JavaCCErrors._printLocationInfo(object);
        System.err.println(string);
        ++s_warning_count;
    }

    public static void warning(String string) {
        System.err.println("Warning: " + string);
        ++s_warning_count;
    }

    public static int getWarningCount() {
        return s_warning_count;
    }

    public static int getErrorCount() {
        return s_parse_error_count + s_semantic_error_count;
    }

    public static void fatal(String string) throws IllegalStateException {
        System.err.println("Fatal Error: " + string);
        throw new IllegalStateException("Fatal Error: " + string);
    }

    public static void internalError() throws IllegalStateException {
        JavaCCErrors.fatal("Internal error in JavaCC: Please file an issue at https://github.com/phax/ParserGeneratorCC/issues . Thank you.");
    }

    public static void reInit() {
        s_parse_error_count = 0;
        s_semantic_error_count = 0;
        s_warning_count = 0;
    }
}

