/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.output.cpp;

import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.pgcc.PGVersion;
import com.helger.pgcc.output.OutputFile;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.utils.OutputFileGenerator;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;

public class FilesCpp {
    static final String charStreamVersion = PGVersion.MAJOR_DOT_MINOR;
    static final String tokenManagerVersion = PGVersion.MAJOR_DOT_MINOR;
    static final String tokenVersion = PGVersion.MAJOR_DOT_MINOR;
    static final String parseExceptionVersion = PGVersion.MAJOR_DOT_MINOR;
    static final String tokenMgrErrorVersion = PGVersion.MAJOR_DOT_MINOR;

    /*
     * Loose catch block
     */
    public static double getVersion(String string) {
        double d;
        Throwable throwable;
        NonBlockingBufferedReader nonBlockingBufferedReader;
        block21: {
            block22: {
                String string2;
                String string3 = "/* " + JavaCCGlobals.getIdString("ParserGeneratorCC", string) + " Version ";
                File file = new File(Options.getOutputDirectory(), JavaCCGlobals.replaceBackslash(string));
                if (!file.exists()) {
                    try {
                        String string4 = PGVersion.s_versionNumber.replaceAll("[^0-9.]+.*", "");
                        return Double.parseDouble(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return 0.0;
                    }
                }
                nonBlockingBufferedReader = new NonBlockingBufferedReader((Reader)new FileReader(file));
                throwable = null;
                double d2 = 0.0;
                while ((string2 = nonBlockingBufferedReader.readLine()) != null) {
                    if (!string2.startsWith(string3)) continue;
                    int n = (string2 = string2.substring(string3.length())).indexOf(32);
                    if (n >= 0) {
                        string2 = string2.substring(0, n);
                    }
                    if (string2.length() <= 0) break;
                    try {
                        d2 = Double.parseDouble(string2);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                        break;
                    }
                }
                d = d2;
                if (nonBlockingBufferedReader == null) break block21;
                if (throwable == null) break block22;
                try {
                    nonBlockingBufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block21;
            }
            nonBlockingBufferedReader.close();
        }
        return d;
        catch (Throwable throwable3) {
            try {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (nonBlockingBufferedReader != null) {
                        if (throwable != null) {
                            try {
                                nonBlockingBufferedReader.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            nonBlockingBufferedReader.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (IOException iOException) {
                return 0.0;
            }
        }
    }

    private static void genFile(String string, String string2, String[] stringArray) {
        File file = new File(Options.getOutputDirectory(), string);
        try (OutputFile outputFile = new OutputFile(file, string2, stringArray);){
            if (!outputFile.needToWrite) {
                return;
            }
            try (PrintWriter printWriter = outputFile.getPrintWriter();){
                OutputFileGenerator outputFileGenerator = new OutputFileGenerator("/templates/cpp/" + string + ".template", Options.getAllOptions());
                outputFileGenerator.generate(printWriter);
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to create file: " + file);
            iOException.printStackTrace();
            JavaCCErrors.semantic_error("Could not open file: " + file + " for writing.");
            throw new UncheckedIOException(iOException);
        }
    }

    public static void gen_CharStream() {
        String[] stringArray = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        FilesCpp.genFile("CharStream.h", charStreamVersion, stringArray);
        FilesCpp.genFile("CharStream.cc", charStreamVersion, stringArray);
    }

    public static void gen_ParseException() {
        String[] stringArray = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        FilesCpp.genFile("ParseException.h", parseExceptionVersion, stringArray);
        FilesCpp.genFile("ParseException.cc", parseExceptionVersion, stringArray);
    }

    public static void gen_TokenMgrError() {
        String[] stringArray = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        FilesCpp.genFile("TokenMgrError.h", tokenMgrErrorVersion, stringArray);
        FilesCpp.genFile("TokenMgrError.cc", tokenMgrErrorVersion, stringArray);
    }

    public static void gen_Token() {
        String[] stringArray = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC", "TOKEN_INCLUDES", "TOKEN_EXTENDS"};
        FilesCpp.genFile("Token.h", tokenMgrErrorVersion, stringArray);
        FilesCpp.genFile("Token.cc", tokenMgrErrorVersion, stringArray);
    }

    public static void gen_TokenManager() {
        String[] stringArray = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        FilesCpp.genFile("TokenManager.h", tokenManagerVersion, stringArray);
    }

    public static void gen_JavaCCDefs() {
        String[] stringArray = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        FilesCpp.genFile("JavaCC.h", tokenManagerVersion, stringArray);
    }

    public static void gen_ErrorHandler() {
        String[] stringArray = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC", "BUILD_PARSER", "BUILD_TOKEN_MANAGER"};
        FilesCpp.genFile("ErrorHandler.h", parseExceptionVersion, stringArray);
    }

    public static void reInit() {
    }
}

