/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.output;

import com.helger.commons.io.stream.NonBlockingBufferedOutputStream;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.NullOutputStream;
import com.helger.pgcc.PGVersion;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.Options;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.WillCloseWhenClosed;

public class OutputFile
implements AutoCloseable {
    private static final String MD5_LINE_PART_1 = "/* JavaCC - OriginalChecksum=";
    private static final String MD5_LINE_PART_1q = "/\\* JavaCC - OriginalChecksum=";
    private static final String MD5_LINE_PART_2 = " (do not edit this line) */";
    private static final String MD5_LINE_PART_2q = " \\(do not edit this line\\) \\*/";
    TrapClosePrintWriter m_pw;
    DigestOutputStream dos;
    String m_toolName;
    final File m_file;
    final String m_compatibleVersion;
    final String[] m_options;
    public boolean needToWrite;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public OutputFile(File file, String string, String[] stringArray) throws IOException {
        block45: {
            this.m_toolName = "ParserGeneratorCC";
            this.needToWrite = true;
            this.m_file = file;
            this.m_compatibleVersion = string;
            this.m_options = stringArray;
            if (file.exists()) {
                try (NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader((Reader)new FileReader(file));){
                    MessageDigest messageDigest;
                    try {
                        messageDigest = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new IOException("No MD5 implementation", noSuchAlgorithmException);
                    }
                    try (DigestOutputStream digestOutputStream = new DigestOutputStream((OutputStream)new NullOutputStream(), messageDigest);
                         PrintWriter printWriter = new PrintWriter(digestOutputStream);){
                        String string2;
                        String string3 = null;
                        while ((string2 = nonBlockingBufferedReader.readLine()) != null) {
                            if (string2.startsWith(MD5_LINE_PART_1)) {
                                string3 = string2.replaceAll(MD5_LINE_PART_1q, "").replaceAll(MD5_LINE_PART_2q, "");
                                continue;
                            }
                            printWriter.println(string2);
                        }
                        String string4 = OutputFile.toHexString(digestOutputStream.getMessageDigest().digest());
                        if (string3 == null || !string3.equals(string4)) {
                            this.needToWrite = false;
                            if (string != null) {
                                this.checkVersion(file, string);
                            }
                            if (stringArray != null) {
                                this.checkOptions(file, stringArray);
                            }
                        } else {
                            System.out.println("File \"" + file.getName() + "\" is being rebuilt.");
                            this.needToWrite = true;
                        }
                        break block45;
                    }
                }
            }
            System.out.println("File \"" + file.getName() + "\" does not exist.  Will create one.");
            this.needToWrite = true;
        }
    }

    public OutputFile(File file) throws IOException {
        this(file, null, null);
    }

    private void checkVersion(File file, String string) {
        String string2 = "/* " + JavaCCGlobals.getIdString(this.m_toolName, file.getName()) + " Version ";
        try (NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader((Reader)new FileReader(file));){
            String string3;
            while ((string3 = nonBlockingBufferedReader.readLine()) != null) {
                if (!string3.startsWith(string2)) continue;
                String string4 = string3.replaceFirst(".*Version ", "").replaceAll(" \\*/", "");
                if (!string4.equals(string)) {
                    JavaCCErrors.warning(file.getName() + ": File is obsolete.  Please rename or delete this file so that a new one can be generated for you.");
                    JavaCCErrors.warning(file.getName() + " file   version: " + string4 + " javacc version: " + string);
                }
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JavaCCErrors.semantic_error("Could not open file " + file.getName() + " for writing.");
            throw new UncheckedIOException(fileNotFoundException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkOptions(File file, String[] stringArray) {
        try (NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader((Reader)new FileReader(file));){
            String string;
            while ((string = nonBlockingBufferedReader.readLine()) != null) {
                if (!string.startsWith("/* JavaCCOptions:")) continue;
                String string2 = Options.getOptionsString(stringArray);
                if (string.indexOf(string2) == -1) {
                    JavaCCErrors.warning(file.getName() + ": Generated using incompatible options. Please rename or delete this file so that a new one can be generated for you.");
                }
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JavaCCErrors.semantic_error("Could not open file " + file.getName() + " for writing.");
            throw new UncheckedIOException(fileNotFoundException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @WillCloseWhenClosed
    public PrintWriter getPrintWriter() throws IOException {
        if (this.m_pw == null) {
            MessageDigest messageDigest = EMessageDigestAlgorithm.MD5.createMessageDigest();
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException("No MD5 implementation", noSuchAlgorithmException);
            }
            this.dos = new DigestOutputStream((OutputStream)new NonBlockingBufferedOutputStream((OutputStream)new FileOutputStream(this.m_file)), messageDigest);
            this.m_pw = new TrapClosePrintWriter(this.dos);
            String string = this.m_compatibleVersion == null ? PGVersion.s_versionNumber : this.m_compatibleVersion;
            this.m_pw.println("/* " + JavaCCGlobals.getIdString(this.m_toolName, this.m_file.getName()) + " Version " + string + " */");
            if (this.m_options != null) {
                this.m_pw.println("/* JavaCCOptions:" + Options.getOptionsString(this.m_options) + " */");
            }
        }
        return this.m_pw;
    }

    @Override
    public void close() {
        if (this.m_pw != null) {
            this.m_pw.println(MD5_LINE_PART_1 + this._getMD5sum() + MD5_LINE_PART_2);
            this.m_pw.closePrintWriter();
        }
    }

    private String _getMD5sum() {
        this.m_pw.flush();
        byte[] byArray = this.dos.getMessageDigest().digest();
        return OutputFile.toHexString(byArray);
    }

    private static final String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append(HEX_DIGITS[(by & 0xF0) >> 4]).append(HEX_DIGITS[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    public String getToolName() {
        return this.m_toolName;
    }

    public void setToolName(String string) {
        this.m_toolName = string;
    }

    public String getPath() {
        return this.m_file.getAbsolutePath();
    }

    private final class TrapClosePrintWriter
    extends PrintWriter {
        public TrapClosePrintWriter(OutputStream outputStream) {
            super(outputStream);
        }

        void closePrintWriter() {
            super.close();
        }

        @Override
        public void close() {
            OutputFile.this.close();
        }
    }
}

