/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.main;

import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCParser;
import com.helger.pgcc.parser.LexGenJava;
import com.helger.pgcc.parser.Main;
import com.helger.pgcc.parser.MetaParseException;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.Semanticize;
import com.helger.pgcc.parser.TokenizerData;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;

public class JavaCCInterpreter {
    public static void main(String[] stringArray) throws Exception {
        Main.reInitAll();
        for (int i = 0; i < stringArray.length - 2; ++i) {
            if (!Options.isOption(stringArray[i])) {
                System.out.println("Argument \"" + stringArray[i] + "\" must be an option setting.");
                System.exit(1);
            }
            Options.setCmdLineOption(stringArray[i]);
        }
        String string = "";
        String string2 = "";
        try {
            File file = new File(stringArray[stringArray.length - 2]);
            byte[] byArray = new byte[(int)file.length()];
            Object object = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            Object object2 = null;
            try {
                ((DataInputStream)object).readFully(byArray);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((FilterInputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((FilterInputStream)object).close();
                    }
                }
            }
            string2 = new String(byArray);
            object = new File(stringArray[stringArray.length - 1]);
            byArray = new byte[(int)((File)object).length()];
            object2 = new DataInputStream(new BufferedInputStream(new FileInputStream((File)object)));
            Throwable throwable = null;
            try {
                ((DataInputStream)object2).readFully(byArray);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((FilterInputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FilterInputStream)object2).close();
                    }
                }
            }
            string = new String(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (Throwable throwable) {
            System.exit(1);
        }
        long l = System.currentTimeMillis();
        new JavaCCInterpreter().runTokenizer(string2, string);
        System.err.println("Tokenized in: " + (System.currentTimeMillis() - l));
    }

    public void runTokenizer(String string, String string2) {
        try {
            JavaCCParser javaCCParser = new JavaCCParser(new StringReader(string));
            javaCCParser.javacc_input();
            Semanticize.start();
            LexGenJava lexGenJava = new LexGenJava();
            LexGenJava.s_generateDataOnly = true;
            lexGenJava.start();
            TokenizerData tokenizerData = LexGenJava.s_tokenizerData;
            if (JavaCCErrors.getErrorCount() == 0) {
                JavaCCInterpreter.tokenize(tokenizerData, string2);
            }
        }
        catch (MetaParseException metaParseException) {
            System.out.println("Detected " + JavaCCErrors.getErrorCount() + " errors and " + JavaCCErrors.getWarningCount() + " warnings.");
            System.exit(1);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            System.out.println("Detected " + (JavaCCErrors.getErrorCount() + 1) + " errors and " + JavaCCErrors.getWarningCount() + " warnings.");
            System.exit(1);
        }
    }

    public static void tokenize(TokenizerData tokenizerData, String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = tokenizerData.m_defaultLexState;
        Object object = new HashSet<Integer>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        while (n2 < n) {
            int n4;
            int n5;
            List<String> list;
            int n6;
            int n7 = n6 = n2;
            int n8 = Integer.MAX_VALUE;
            int n9 = tokenizerData.m_initialStates.get(n3);
            char c = string.charAt(n2);
            if (Options.isIgnoreCase()) {
                c = Character.toLowerCase(c);
            }
            if ((list = tokenizerData.m_literalSequence.get(n5 = n3 << 16 | c)) != null) {
                n4 = 0;
                for (String string2 : list) {
                    int n10;
                    for (n10 = 1; n10 < string2.length() && n2 + n10 < n; ++n10) {
                        c = string.charAt(n2 + n10);
                        if (Options.isIgnoreCase()) {
                            c = Character.toLowerCase(c);
                        }
                        if (c != string2.charAt(n10)) break;
                    }
                    if (n10 == string2.length()) {
                        n8 = tokenizerData.m_literalKinds.get(n5).get(n4);
                        n7 = n2 + n10 - 1;
                        n9 = tokenizerData.m_kindToNfaStartState.get(n8);
                        n2 += n10;
                        break;
                    }
                    ++n4;
                }
            }
            if (n9 != -1) {
                n4 = Integer.MAX_VALUE;
                object.add(n9);
                object.addAll(tokenizerData.m_nfa.get((Object)Integer.valueOf((int)n9)).m_compositeStates);
                do {
                    c = string.charAt(n2);
                    if (Options.isIgnoreCase()) {
                        c = Character.toLowerCase(c);
                    }
                    Object object2 = object.iterator();
                    while (object2.hasNext()) {
                        int n11 = (Integer)((Object)object2.next());
                        TokenizerData.NfaState nfaState = tokenizerData.m_nfa.get(n11);
                        if (!nfaState.m_characters.contains(Character.valueOf(c))) continue;
                        if (n4 > nfaState.m_kind) {
                            n4 = nfaState.m_kind;
                        }
                        hashSet.addAll(nfaState.m_nextStates);
                    }
                    object2 = hashSet;
                    hashSet = object;
                    object = object2;
                    hashSet.clear();
                    if (n4 == Integer.MAX_VALUE) continue;
                    n8 = n4;
                    n7 = n2;
                    n4 = Integer.MAX_VALUE;
                } while (!object.isEmpty() && ++n2 < n);
            }
            if (n7 == n6 && n8 > tokenizerData.m_wildcardKind.get(n3)) {
                n8 = tokenizerData.m_wildcardKind.get(n3);
            }
            if (n8 != Integer.MAX_VALUE) {
                TokenizerData.MatchInfo matchInfo = tokenizerData.m_allMatches.get(n8);
                if (matchInfo.m_action != null) {
                    System.err.println("Actions not implemented (yet) in intererpreted mode");
                }
                if (matchInfo.m_matchType == TokenizerData.EMatchType.TOKEN) {
                    System.err.println("Token: " + n8 + "; image: \"" + string.substring(n6, n7 + 1) + "\"");
                }
                if (matchInfo.m_newLexState != -1) {
                    n3 = matchInfo.m_newLexState;
                }
                n2 = n7 + 1;
                continue;
            }
            System.err.println("Encountered token error at char: " + string.charAt(n2));
            System.exit(1);
        }
        System.err.println("Matched EOF");
    }
}

