/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree.output;

import com.helger.commons.string.StringHelper;
import com.helger.pgcc.PGVersion;
import com.helger.pgcc.jjtree.ASTNodeDescriptor;
import com.helger.pgcc.jjtree.JJTreeGlobals;
import com.helger.pgcc.jjtree.JJTreeOptions;
import com.helger.pgcc.output.OutputFile;
import com.helger.pgcc.output.cpp.OtherFilesGenCPP;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.utils.OutputFileGenerator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class NodeFilesCpp {
    private static final List<String> s_headersForJJTreeH = new ArrayList<String>();
    static final String s_nodeVersion = PGVersion.MAJOR_DOT_MINOR;
    static final Set<String> s_nodesToGenerate = new HashSet<String>();

    private NodeFilesCpp() {
    }

    public static void addType(String string) {
        if (!string.equals("Node") && !string.equals("SimpleNode")) {
            s_nodesToGenerate.add(string);
        }
    }

    public static String nodeIncludeFile() {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), "Node.h").getAbsolutePath();
    }

    public static String simpleNodeIncludeFile() {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), "SimpleNode.h").getAbsolutePath();
    }

    public static String simpleNodeCodeFile() {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), "SimpleNode.cc").getAbsolutePath();
    }

    public static String jjtreeIncludeFile() {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), JJTreeGlobals.s_parserName + "Tree.h").getAbsolutePath();
    }

    public static String jjtreeImplFile() {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), JJTreeGlobals.s_parserName + "Tree.cc").getAbsolutePath();
    }

    public static String jjtreeIncludeFile(String string) {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".h").getAbsolutePath();
    }

    public static String jjtreeImplFile(String string) {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".cc").getAbsolutePath();
    }

    public static String jjtreeASTIncludeFile(String string) {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".h").getAbsolutePath();
    }

    public static String jjtreeASTCodeFile(String string) {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".cc").getAbsolutePath();
    }

    private static String _getVisitorIncludeFile() {
        String string = NodeFilesCpp.getVisitorClass();
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".h").getAbsolutePath();
    }

    public static void generateTreeClasses() {
        NodeFilesCpp._generateNodeHeader();
        NodeFilesCpp._generateSimpleNodeHeader();
        NodeFilesCpp._generateSimpleNodeCode();
        NodeFilesCpp._generateMultiTreeInterface();
        NodeFilesCpp._generateMultiTreeImpl();
        NodeFilesCpp._generateOneTreeInterface();
    }

    private static void _generateNodeHeader() {
        File file = new File(NodeFilesCpp.nodeIncludeFile());
        String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        try (OutputFile outputFile = new OutputFile(file, s_nodeVersion, stringArray);){
            outputFile.setToolName("JJTree");
            if (file.exists() && !outputFile.needToWrite) {
                return;
            }
            Map<String, Object> map = Options.getAllOptions();
            map.put("PARSER_NAME", JJTreeGlobals.s_parserName);
            map.put("VISITOR_RETURN_TYPE", NodeFilesCpp._getVisitorReturnType());
            map.put("VISITOR_DATA_TYPE", NodeFilesCpp._getVisitorArgumentType());
            map.put("VISITOR_RETURN_TYPE_VOID", NodeFilesCpp._getVisitorReturnType().equals("void"));
            NodeFilesCpp.generateFile(outputFile, "/templates/jjtree/cpp/Node.h.template", map, false);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static void _generateSimpleNodeHeader() {
        File file = new File(NodeFilesCpp.simpleNodeIncludeFile());
        String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        try (OutputFile outputFile = new OutputFile(file, s_nodeVersion, stringArray);){
            outputFile.setToolName("JJTree");
            if (file.exists() && !outputFile.needToWrite) {
                return;
            }
            Map<String, Object> map = Options.getAllOptions();
            map.put("PARSER_NAME", JJTreeGlobals.s_parserName);
            map.put("VISITOR_RETURN_TYPE", NodeFilesCpp._getVisitorReturnType());
            map.put("VISITOR_DATA_TYPE", NodeFilesCpp._getVisitorArgumentType());
            map.put("VISITOR_RETURN_TYPE_VOID", NodeFilesCpp._getVisitorReturnType().equals("void"));
            NodeFilesCpp.generateFile(outputFile, "/templates/jjtree/cpp/SimpleNode.h.template", map, false);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static void _generateSimpleNodeCode() {
        File file = new File(NodeFilesCpp.simpleNodeCodeFile());
        String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        try (OutputFile outputFile = new OutputFile(file, s_nodeVersion, stringArray);){
            outputFile.setToolName("JJTree");
            if (file.exists() && !outputFile.needToWrite) {
                return;
            }
            Map<String, Object> map = Options.getAllOptions();
            map.put("PARSER_NAME", JJTreeGlobals.s_parserName);
            map.put("VISITOR_RETURN_TYPE", NodeFilesCpp._getVisitorReturnType());
            map.put("VISITOR_DATA_TYPE", NodeFilesCpp._getVisitorArgumentType());
            map.put("VISITOR_RETURN_TYPE_VOID", NodeFilesCpp._getVisitorReturnType().equals("void"));
            NodeFilesCpp.generateFile(outputFile, "/templates/jjtree/cpp/SimpleNode.cc.template", map, false);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static void _generateMultiTreeInterface() {
        String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        try {
            Iterator<String> iterator = s_nodesToGenerate.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next();
                File file = new File(NodeFilesCpp.jjtreeIncludeFile(string2));
                OutputFile outputFile = new OutputFile(file, s_nodeVersion, stringArray);
                Throwable throwable = null;
                try {
                    outputFile.setToolName("JJTree");
                    if (file.exists() && !outputFile.needToWrite) {
                        return;
                    }
                    Map<String, Object> map = Options.getAllOptions();
                    map.put("PARSER_NAME", JJTreeGlobals.s_parserName);
                    map.put("VISITOR_RETURN_TYPE", NodeFilesCpp._getVisitorReturnType());
                    map.put("VISITOR_DATA_TYPE", NodeFilesCpp._getVisitorArgumentType());
                    map.put("VISITOR_RETURN_TYPE_VOID", NodeFilesCpp._getVisitorReturnType().equals("void"));
                    map.put("NODE_TYPE", string2);
                    NodeFilesCpp.generateFile(outputFile, "/templates/jjtree/cpp/MultiNodeInterface.template", map, false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputFile == null) continue;
                    if (throwable != null) {
                        try {
                            outputFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    outputFile.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static void _generateMultiTreeImpl() {
        String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        try {
            Iterator<String> iterator = s_nodesToGenerate.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next();
                File file = new File(NodeFilesCpp.jjtreeImplFile(string2));
                OutputFile outputFile = new OutputFile(file, s_nodeVersion, stringArray);
                Throwable throwable = null;
                try {
                    outputFile.setToolName("JJTree");
                    if (file.exists() && !outputFile.needToWrite) {
                        return;
                    }
                    Map<String, Object> map = Options.getAllOptions();
                    map.put("PARSER_NAME", JJTreeGlobals.s_parserName);
                    map.put("VISITOR_RETURN_TYPE", NodeFilesCpp._getVisitorReturnType());
                    map.put("VISITOR_DATA_TYPE", NodeFilesCpp._getVisitorArgumentType());
                    map.put("VISITOR_RETURN_TYPE_VOID", NodeFilesCpp._getVisitorReturnType().equals("void"));
                    map.put("NODE_TYPE", string2);
                    NodeFilesCpp.generateFile(outputFile, "/templates/jjtree/cpp/MultiNodeImpl.template", map, false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputFile == null) continue;
                    if (throwable != null) {
                        try {
                            outputFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    outputFile.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static void _generateOneTreeInterface() {
        File file = new File(NodeFilesCpp.jjtreeIncludeFile());
        try {
            String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
            try (OutputFile outputFile = new OutputFile(file, s_nodeVersion, stringArray);){
                outputFile.setToolName("JJTree");
                if (file.exists() && !outputFile.needToWrite) {
                    return;
                }
                Map<String, Object> map = Options.getAllOptions();
                map.put("PARSER_NAME", JJTreeGlobals.s_parserName);
                map.put("VISITOR_RETURN_TYPE", NodeFilesCpp._getVisitorReturnType());
                map.put("VISITOR_DATA_TYPE", NodeFilesCpp._getVisitorArgumentType());
                map.put("VISITOR_RETURN_TYPE_VOID", NodeFilesCpp._getVisitorReturnType().equals("void"));
                try (PrintWriter printWriter = outputFile.getPrintWriter();){
                    String string = file.getName().replace('.', '_').toUpperCase(Locale.US);
                    printWriter.println("#ifndef " + string);
                    printWriter.println("#define " + string);
                    printWriter.println("#include \"SimpleNode.h\"");
                    Iterator<String> iterator = s_nodesToGenerate.iterator();
                    while (iterator.hasNext()) {
                        String string2;
                        String string3 = string2 = iterator.next();
                        printWriter.println("#include \"" + string3 + ".h\"");
                    }
                    printWriter.println("#endif");
                }
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static void _generateOneTreeImpl() {
        File file = new File(NodeFilesCpp.jjtreeImplFile());
        String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        try (OutputFile outputFile = new OutputFile(file, s_nodeVersion, stringArray);){
            boolean bl;
            outputFile.setToolName("JJTree");
            if (file.exists() && !outputFile.needToWrite) {
                return;
            }
            Map<String, Object> map = Options.getAllOptions();
            map.put("PARSER_NAME", JJTreeGlobals.s_parserName);
            map.put("VISITOR_RETURN_TYPE", NodeFilesCpp._getVisitorReturnType());
            map.put("VISITOR_DATA_TYPE", NodeFilesCpp._getVisitorArgumentType());
            map.put("VISITOR_RETURN_TYPE_VOID", NodeFilesCpp._getVisitorReturnType().equals("void"));
            NodeFilesCpp.generateFile(outputFile, "/templates/jjtree/cpp/_unused_TreeImplHeader.template", map, false);
            boolean bl2 = bl = Options.stringValue("NAMESPACE").length() > 0;
            if (bl) {
                outputFile.getPrintWriter().println("namespace " + Options.stringValue("NAMESPACE_OPEN"));
            }
            Iterator<String> iterator = s_nodesToGenerate.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next();
                map.put("NODE_TYPE", string2);
                NodeFilesCpp.generateFile(outputFile, "/templates/jjtree/cpp/MultiNodeImpl.template", map, false);
            }
            if (bl) {
                outputFile.getPrintWriter().println(Options.stringValue("NAMESPACE_CLOSE"));
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    static void generatePrologue() {
    }

    static String nodeConstants() {
        return JJTreeGlobals.s_parserName + "TreeConstants";
    }

    public static void generateTreeConstants() {
        String string = NodeFilesCpp.nodeConstants();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".h");
        s_headersForJJTreeH.add(file.getName());
        try (OutputFile outputFile = new OutputFile(file);){
            String string2;
            int n;
            boolean bl;
            PrintWriter printWriter = outputFile.getPrintWriter();
            List<String> list = ASTNodeDescriptor.getNodeIds();
            List<String> list2 = ASTNodeDescriptor.getNodeNames();
            NodeFilesCpp.generatePrologue();
            printWriter.println("#ifndef " + file.getName().replace('.', '_').toUpperCase(Locale.US));
            printWriter.println("#define " + file.getName().replace('.', '_').toUpperCase(Locale.US));
            printWriter.println("\n#include \"JavaCC.h\"");
            boolean bl2 = bl = Options.stringValue("NAMESPACE").length() > 0;
            if (bl) {
                printWriter.println("namespace " + Options.stringValue("NAMESPACE_OPEN"));
            }
            printWriter.println("enum {");
            for (n = 0; n < list.size(); ++n) {
                string2 = list.get(n);
                printWriter.println("  " + string2 + " = " + n + ",");
            }
            printWriter.println("};");
            printWriter.println();
            for (n = 0; n < list2.size(); ++n) {
                printWriter.println("  static JJChar jjtNodeName_arr_" + n + "[] = ");
                string2 = list2.get(n);
                OtherFilesGenCPP.printCharArray(printWriter, string2);
                printWriter.println(";");
            }
            printWriter.println("  static JJString jjtNodeName[] = {");
            for (n = 0; n < list2.size(); ++n) {
                printWriter.println("jjtNodeName_arr_" + n + ", ");
            }
            printWriter.println("  };");
            if (bl) {
                printWriter.println(Options.stringValue("NAMESPACE_CLOSE"));
            }
            printWriter.println("#endif");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    static String getVisitorClass() {
        return JJTreeGlobals.s_parserName + "Visitor";
    }

    private static String _getVisitMethodName(String string) {
        StringBuilder stringBuilder = new StringBuilder("visit");
        if (Options.booleanValue("VISITOR_METHOD_NAME_INCLUDES_TYPE_NAME")) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0)));
            for (int i = 1; i < string.length(); ++i) {
                stringBuilder.append(string.charAt(i));
            }
        }
        return stringBuilder.toString();
    }

    private static String _getVisitorArgumentType() {
        String string = Options.stringValue("VISITOR_DATA_TYPE");
        return string == null || string.length() == 0 || string.equals("Object") ? "void *" : string;
    }

    private static String _getVisitorReturnType() {
        String string = Options.stringValue("VISITOR_RETURN_TYPE");
        return string == null || string.length() == 0 || string.equals("Object") ? "void " : string;
    }

    public static void generateVisitors() {
        if (!JJTreeOptions.isVisitor()) {
            return;
        }
        File file = new File(NodeFilesCpp._getVisitorIncludeFile());
        try (OutputFile outputFile = new OutputFile(file);
             PrintWriter printWriter = outputFile.getPrintWriter();){
            boolean bl;
            NodeFilesCpp.generatePrologue();
            printWriter.println("#ifndef " + file.getName().replace('.', '_').toUpperCase(Locale.US));
            printWriter.println("#define " + file.getName().replace('.', '_').toUpperCase(Locale.US));
            printWriter.println("\n#include \"JavaCC.h\"");
            printWriter.println("#include \"" + JJTreeGlobals.s_parserName + "Tree.h\"");
            boolean bl2 = bl = Options.stringValue("NAMESPACE").length() > 0;
            if (bl) {
                printWriter.println("namespace " + Options.stringValue("NAMESPACE_OPEN"));
            }
            NodeFilesCpp._generateVisitorInterface(printWriter);
            NodeFilesCpp._generateDefaultVisitor(printWriter);
            if (bl) {
                printWriter.println(Options.stringValue("NAMESPACE_CLOSE"));
            }
            printWriter.println("#endif");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static void _generateVisitorInterface(PrintWriter printWriter) {
        String string = NodeFilesCpp.getVisitorClass();
        List<String> list = ASTNodeDescriptor.getNodeNames();
        printWriter.println("class " + string);
        printWriter.println("{");
        String string2 = NodeFilesCpp._getVisitorArgumentType();
        String string3 = NodeFilesCpp._getVisitorReturnType();
        if (StringHelper.hasText((String)JJTreeOptions.getVisitorDataType())) {
            string2 = JJTreeOptions.getVisitorDataType();
        }
        printWriter.println("  public:");
        printWriter.println("  virtual " + string3 + " visit(const SimpleNode *node, " + string2 + " data) = 0;");
        if (JJTreeOptions.isMulti()) {
            for (int i = 0; i < list.size(); ++i) {
                String string4 = list.get(i);
                if (string4.equals("void")) continue;
                String string5 = JJTreeOptions.getNodePrefix() + string4;
                printWriter.println("  virtual " + string3 + " " + NodeFilesCpp._getVisitMethodName(string5) + "(const " + string5 + " *node, " + string2 + " data) = 0;");
            }
        }
        printWriter.println("  virtual ~" + string + "() { }");
        printWriter.println("};");
    }

    static String defaultVisitorClass() {
        return JJTreeGlobals.s_parserName + "DefaultVisitor";
    }

    private static void _generateDefaultVisitor(PrintWriter printWriter) {
        String string = NodeFilesCpp.defaultVisitorClass();
        List<String> list = ASTNodeDescriptor.getNodeNames();
        printWriter.println("class " + string + " : public " + NodeFilesCpp.getVisitorClass() + " {");
        String string2 = NodeFilesCpp._getVisitorArgumentType();
        String string3 = NodeFilesCpp._getVisitorReturnType();
        printWriter.println("public:");
        printWriter.println("  virtual " + string3 + " defaultVisit(const SimpleNode *node, " + string2 + " data) = 0;");
        printWriter.println("  virtual " + string3 + " visit(const SimpleNode *node, " + string2 + " data) {");
        printWriter.println("    " + (string3.trim().equals("void") ? "" : "return ") + "defaultVisit(node, data);");
        printWriter.println("}");
        if (JJTreeOptions.isMulti()) {
            for (int i = 0; i < list.size(); ++i) {
                String string4 = list.get(i);
                if (string4.equals("void")) continue;
                String string5 = JJTreeOptions.getNodePrefix() + string4;
                printWriter.println("  virtual " + string3 + " " + NodeFilesCpp._getVisitMethodName(string5) + "(const " + string5 + " *node, " + string2 + " data) {");
                printWriter.println("    " + (string3.trim().equals("void") ? "" : "return ") + "defaultVisit(node, data);");
                printWriter.println("  }");
            }
        }
        printWriter.println("  ~" + string + "() { }");
        printWriter.println("};");
    }

    public static void generateFile(OutputFile outputFile, String string, Map<String, Object> map, boolean bl) throws IOException {
        PrintWriter printWriter = outputFile.getPrintWriter();
        NodeFilesCpp.generatePrologue();
        OutputFileGenerator outputFileGenerator = new OutputFileGenerator(string, map);
        outputFileGenerator.generate(printWriter);
        if (bl) {
            printWriter.close();
        }
    }
}

