/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree;

import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.pgcc.jjtree.JJTreeOptions;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.Options;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public final class JJTreeIO {
    private String m_sInputFilename = "<uninitialized input>";
    private String m_sOutputFilename;
    private Reader m_in;
    private PrintWriter m_out;
    private final PrintStream msg = System.out;
    private final PrintStream err = System.err;

    JJTreeIO() {
    }

    String getInputFilename() {
        return this.m_sInputFilename;
    }

    Reader getIn() {
        return this.m_in;
    }

    String getOutputFilename() {
        return this.m_sOutputFilename;
    }

    PrintWriter getOut() {
        return this.m_out;
    }

    PrintStream getMsg() {
        return this.msg;
    }

    PrintStream getErr() {
        return this.err;
    }

    void print(String string) {
        this.m_out.print(string);
    }

    public void println(String string) {
        this.m_out.println(string);
    }

    public void println() {
        this.m_out.println();
    }

    void closeAll() {
        StreamHelper.close((AutoCloseable)this.m_out);
        if (this.msg != null) {
            this.msg.flush();
        }
        if (this.err != null) {
            this.err.flush();
        }
    }

    private static String _createOutputFilename(String string) {
        String string2 = JJTreeOptions.getOutputFile();
        if (StringHelper.hasNoText((String)string2)) {
            String string3;
            int n;
            String string4 = string;
            int n2 = string4.lastIndexOf(File.separatorChar);
            if (n2 >= 0) {
                string4 = string4.substring(n2 + 1);
            }
            string2 = (n = string4.lastIndexOf(46)) == -1 ? string4 + ".jj" : ((string3 = string4.substring(n)).equals(".jj") ? string4 + ".jj" : string4.substring(0, n) + ".jj");
        }
        return string2;
    }

    void setInput(String string) throws IOException {
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new IOException("File " + string + " not found.");
            }
            if (file.isDirectory()) {
                throw new IOException(string + " is a directory. Please use a valid file name.");
            }
            if (JavaCCGlobals.isGeneratedBy("JJTree", string)) {
                throw new IOException(string + " was generated by jjtree.  Cannot run jjtree again.");
            }
            this.m_sInputFilename = file.getPath();
            this.m_in = new NonBlockingBufferedReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this.m_sInputFilename), Options.getGrammarEncoding()));
        }
        catch (SecurityException securityException) {
            throw new IOException("Security violation while trying to open " + string, securityException);
        }
    }

    void setOutput() throws IOException {
        JavaCCGlobals.createOutputDir(JJTreeOptions.getJJTreeOutputDirectory());
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), JJTreeIO._createOutputFilename(this.m_sInputFilename));
        this.m_sOutputFilename = file.toString();
        NonBlockingBufferedWriter nonBlockingBufferedWriter = FileHelper.getBufferedWriter((File)file, (Charset)Options.getOutputEncoding());
        if (nonBlockingBufferedWriter == null) {
            throw new IOException("Failed to open file " + file);
        }
        this.m_out = new PrintWriter((Writer)nonBlockingBufferedWriter);
    }
}

