/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree;

import com.helger.pgcc.jjtree.ASTGrammar;
import com.helger.pgcc.jjtree.ASTNodeDescriptor;
import com.helger.pgcc.jjtree.JJTreeGlobals;
import com.helger.pgcc.jjtree.JJTreeIO;
import com.helger.pgcc.jjtree.JJTreeOptions;
import com.helger.pgcc.jjtree.JJTreeParser;
import com.helger.pgcc.jjtree.ParseException;
import com.helger.pgcc.jjtree.output.JJTreeStateCpp;
import com.helger.pgcc.jjtree.output.JJTreeStateJava;
import com.helger.pgcc.jjtree.output.NodeFilesCpp;
import com.helger.pgcc.jjtree.output.NodeFilesJava;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.Main;
import com.helger.pgcc.parser.Options;
import java.io.IOException;

public class JJTree {
    private JJTreeIO io;

    private void _println(String string) {
        this.io.getMsg().println(string);
    }

    private void help_message() {
        this._println("Usage:");
        this._println("    jjtree option-settings inputfile");
        this._println("");
        this._println("\"option-settings\" is a sequence of settings separated by spaces.");
        this._println("Each option setting must be of one of the following forms:");
        this._println("");
        this._println("    -optionname=value (e.g., -STATIC=false)");
        this._println("    -optionname:value (e.g., -STATIC:false)");
        this._println("    -optionname       (equivalent to -optionname=true.  e.g., -STATIC)");
        this._println("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOSTATIC)");
        this._println("");
        this._println("Option settings are not case-sensitive, so one can say \"-nOsTaTiC\" instead");
        this._println("of \"-NOSTATIC\".  Option values must be appropriate for the corresponding");
        this._println("option, and must be either an integer or a string value.");
        this._println("");
        this._println("The boolean valued options are:");
        this._println("");
        this._println("    STATIC                   (default true)");
        this._println("    MULTI                    (default false)");
        this._println("    NODE_DEFAULT_VOID        (default false)");
        this._println("    NODE_SCOPE_HOOK          (default false)");
        this._println("    NODE_USES_PARSER         (default false)");
        this._println("    BUILD_NODE_FILES         (default true)");
        this._println("    TRACK_TOKENS             (default false)");
        this._println("    VISITOR                  (default false)");
        this._println("");
        this._println("The string valued options are:");
        this._println("");
        this._println("    JDK_VERSION              (default \"1.5\")");
        this._println("    NODE_CLASS               (default \"\")");
        this._println("    NODE_PREFIX              (default \"AST\")");
        this._println("    NODE_PACKAGE             (default \"\")");
        this._println("    NODE_EXTENDS             (default \"\")");
        this._println("    NODE_FACTORY             (default \"\")");
        this._println("    OUTPUT_FILE              (default remove input file suffix, add .jj)");
        this._println("    OUTPUT_DIRECTORY         (default \"\")");
        this._println("    JJTREE_OUTPUT_DIRECTORY  (default value of OUTPUT_DIRECTORY option)");
        this._println("    VISITOR_DATA_TYPE        (default \"\")");
        this._println("    VISITOR_RETURN_TYPE      (default \"Object\")");
        this._println("    VISITOR_EXCEPTION        (default \"\")");
        this._println("");
        this._println("JJTree also accepts JavaCC options, which it inserts into the generated file.");
        this._println("");
        this._println("EXAMPLES:");
        this._println("    jjtree -STATIC=false mygrammar.jjt");
        this._println("");
        this._println("ABOUT JJTree:");
        this._println("    JJTree is a preprocessor for JavaCC that inserts actions into a");
        this._println("    JavaCC grammar to build parse trees for the input.");
        this._println("");
        this._println("    For more information, see the online JJTree documentation at ");
        this._println("    https://javacc.dev.java.net/doc/JJTree.html ");
        this._println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int main(String[] stringArray) {
        ASTNodeDescriptor.reInit();
        Main.reInitAll();
        JavaCCGlobals.bannerLine("Tree Builder", "");
        this.io = new JJTreeIO();
        try {
            this.initializeOptions();
            if (stringArray.length == 0) {
                this._println("");
                this.help_message();
                int n = 1;
                return n;
            }
            this._println("(type \"jjtree\" with no arguments for help)");
            String string = stringArray[stringArray.length - 1];
            if (Options.isOption(string)) {
                this._println("Last argument \"" + string + "\" is not a filename");
                int n = 1;
                return n;
            }
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (!Options.isOption(stringArray[i])) {
                    this._println("Argument \"" + stringArray[i] + "\" must be an option setting.");
                    int n = 1;
                    return n;
                }
                Options.setCmdLineOption(stringArray[i]);
            }
            JJTreeOptions.validate();
            try {
                this.io.setInput(string);
            }
            catch (IOException iOException) {
                this._println("Error setting input: " + iOException.getMessage());
                int n = 1;
                this.io.closeAll();
                return n;
            }
            this._println("Reading from file " + this.io.getInputFilename() + " . . .");
            JJTreeGlobals.toolList.clear();
            JJTreeGlobals.toolList.addAll(JavaCCGlobals.getToolNames(string));
            JJTreeGlobals.toolList.add("JJTree");
            JJTreeParser jJTreeParser = new JJTreeParser(this.io.getIn());
            jJTreeParser.javacc_input();
            ASTGrammar aSTGrammar = (ASTGrammar)jJTreeParser.jjtree.rootNode();
            if (Boolean.getBoolean("jjtree-dump")) {
                aSTGrammar.dump(" ");
            }
            try {
                this.io.setOutput();
            }
            catch (IOException iOException) {
                this._println("Error setting output: " + iOException.getMessage());
                int n = 1;
                this.io.closeAll();
                return n;
            }
            aSTGrammar.generate(this.io);
            this.io.getOut().close();
            switch (Options.getOutputLanguage()) {
                case JAVA: {
                    NodeFilesJava.generateTreeConstants_java();
                    NodeFilesJava.generateVisitor_java();
                    NodeFilesJava.generateDefaultVisitor_java();
                    JJTreeStateJava.generateTreeState_java();
                    break;
                }
                case CPP: {
                    NodeFilesCpp.generateTreeConstants();
                    NodeFilesCpp.generateVisitors();
                    JJTreeStateCpp.generateTreeState();
                    break;
                }
                default: {
                    this._println("Unsupported JJTree output language : " + (Object)((Object)Options.getOutputLanguage()));
                    int n = 1;
                    return n;
                }
            }
            try {
                this._println("Annotated grammar generated successfully in " + this.io.getOutputFilename());
            }
            catch (ParseException parseException) {
                this._println("Error parsing input: " + parseException.toString());
                int n = 1;
                return n;
            }
            catch (Exception exception) {
                this._println("Error parsing input: " + exception.toString());
                exception.printStackTrace(this.io.getMsg());
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.io.closeAll();
        }
    }

    private void initializeOptions() {
        JJTreeOptions.init();
        JJTreeGlobals.initialize();
    }
}

