/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree;

import com.helger.pgcc.jjtree.ASTNodeDescriptorExpression;
import com.helger.pgcc.jjtree.JJTreeNode;
import com.helger.pgcc.jjtree.JJTreeOptions;
import com.helger.pgcc.jjtree.JJTreeParserVisitor;
import com.helger.pgcc.jjtree.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ASTNodeDescriptor
extends JJTreeNode {
    private static final List<String> s_nodeIds = new ArrayList<String>();
    private static final List<String> s_nodeNames = new ArrayList<String>();
    private static final Map<String, String> s_nodeSeen = new HashMap<String, String>();
    private boolean m_faked = false;
    String m_name;
    boolean m_isGT;
    ASTNodeDescriptorExpression m_expression;

    static ASTNodeDescriptor indefinite(String string) {
        ASTNodeDescriptor aSTNodeDescriptor = new ASTNodeDescriptor(39);
        aSTNodeDescriptor.m_name = string;
        aSTNodeDescriptor.setNodeIdValue();
        aSTNodeDescriptor.m_faked = true;
        return aSTNodeDescriptor;
    }

    public static List<String> getNodeIds() {
        return s_nodeIds;
    }

    public static List<String> getNodeNames() {
        return s_nodeNames;
    }

    static void reInit() {
        s_nodeIds.clear();
        s_nodeNames.clear();
        s_nodeSeen.clear();
    }

    ASTNodeDescriptor(int n) {
        super(n);
    }

    void setNodeIdValue() {
        String string = this.getNodeId();
        if (!s_nodeSeen.containsKey(string)) {
            s_nodeSeen.put(string, string);
            s_nodeNames.add(this.m_name);
            s_nodeIds.add(string);
        }
    }

    String getNodeId() {
        return "JJT" + this.m_name.toUpperCase(Locale.US).replace('.', '_');
    }

    boolean isVoid() {
        return this.m_name.equals("void");
    }

    @Override
    public String toString() {
        if (this.m_faked) {
            return "(faked) " + this.m_name;
        }
        return super.toString() + ": " + this.m_name;
    }

    String getDescriptor() {
        if (this.m_expression == null) {
            return this.m_name;
        }
        return "#" + this.m_name + "(" + (this.m_isGT ? ">" : "") + this.expression_text() + ")";
    }

    String getNodeType() {
        if (JJTreeOptions.isMulti()) {
            return JJTreeOptions.getNodePrefix() + this.m_name;
        }
        return "SimpleNode";
    }

    String getNodeName() {
        return this.m_name;
    }

    String openNode(String string) {
        return "jjtree.openNodeScope(" + string + ");";
    }

    String expression_text() {
        if (this.m_expression.getFirstToken().image.equals(")") && this.m_expression.getLastToken().image.equals("(")) {
            return "true";
        }
        String string = "";
        Token token = this.m_expression.getFirstToken();
        while (true) {
            string = string + " " + token.image;
            if (token == this.m_expression.getLastToken()) break;
            token = token.next;
        }
        return string;
    }

    String closeNode(String string) {
        if (this.m_expression == null) {
            return "jjtree.closeNodeScope(" + string + ", true);";
        }
        if (this.m_isGT) {
            return "jjtree.closeNodeScope(" + string + ", jjtree.nodeArity() > " + this.expression_text() + ");";
        }
        return "jjtree.closeNodeScope(" + string + ", " + this.expression_text() + ");";
    }

    @Override
    String translateImage(Token token) {
        return ASTNodeDescriptor.whiteOut(token);
    }

    @Override
    public Object jjtAccept(JJTreeParserVisitor jJTreeParserVisitor, Object object) {
        return jJTreeParserVisitor.visit(this, object);
    }
}

