/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjdoc;

import com.helger.pgcc.jjdoc.JJDoc;
import com.helger.pgcc.jjdoc.JJDocGlobals;
import com.helger.pgcc.jjdoc.TextGenerator;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.CodeProductionCpp;
import com.helger.pgcc.parser.CodeProductionJava;
import com.helger.pgcc.parser.ExpNonTerminal;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.RegExprSpec;
import com.helger.pgcc.parser.TokenProduction;
import java.util.HashMap;
import java.util.Map;

public class XTextGenerator
extends TextGenerator {
    private final Map<String, String> id_map = new HashMap<String, String>();
    private int id = 1;
    static final String sep = "\n";

    @Override
    public void handleTokenProduction(TokenProduction tokenProduction) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RegExprSpec regExprSpec : tokenProduction.m_respecs) {
            String string = JJDoc.emitRE(regExprSpec.rexp);
            stringBuilder.append(string);
            if (regExprSpec.nsTok != null) {
                stringBuilder.append(" : " + regExprSpec.nsTok.image);
            }
            stringBuilder.append(sep);
        }
    }

    protected String get_id(String string2) {
        return this.id_map.computeIfAbsent(string2, string -> "prod" + this.id++);
    }

    private void println(String string) {
        this.print(string + sep);
    }

    @Override
    public void text(String string) {
        this.print(string);
    }

    @Override
    public void print(String string) {
        this.m_ostr.print(string);
    }

    @Override
    public void documentStart() {
        this.m_ostr = this.createOutputStream();
        this.println("grammar " + JJDocGlobals.s_input_file + " with org.eclipse.xtext.common.Terminals");
        this.println("import \"http://www.eclipse.org/emf/2002/Ecore\" as ecore");
        this.println("");
    }

    @Override
    public void documentEnd() {
        this.m_ostr.close();
    }

    @Override
    public void specialTokens(String string) {
        this.print(string);
    }

    @Override
    public void nonterminalsStart() {
    }

    @Override
    public void nonterminalsEnd() {
    }

    @Override
    public void tokensStart() {
    }

    @Override
    public void tokensEnd() {
    }

    @Override
    public void javacode(CodeProductionJava codeProductionJava) {
    }

    @Override
    public void cppcode(CodeProductionCpp codeProductionCpp) {
    }

    @Override
    public void productionStart(NormalProduction normalProduction) {
    }

    @Override
    public void productionEnd(NormalProduction normalProduction) {
    }

    @Override
    public void expansionStart(Expansion expansion, boolean bl) {
    }

    @Override
    public void expansionEnd(Expansion expansion, boolean bl) {
        this.println(";");
    }

    @Override
    public void nonTerminalStart(ExpNonTerminal expNonTerminal) {
        this.print("terminal ");
    }

    @Override
    public void nonTerminalEnd(ExpNonTerminal expNonTerminal) {
        this.print(";");
    }

    @Override
    public void reStart(AbstractExpRegularExpression abstractExpRegularExpression) {
    }

    @Override
    public void reEnd(AbstractExpRegularExpression abstractExpRegularExpression) {
    }
}

