/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjdoc;

import com.helger.commons.string.StringHelper;
import com.helger.pgcc.jjdoc.IDocGenerator;
import com.helger.pgcc.jjdoc.JJDoc;
import com.helger.pgcc.jjdoc.JJDocGlobals;
import com.helger.pgcc.jjdoc.JJDocOptions;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.CodeProductionCpp;
import com.helger.pgcc.parser.CodeProductionJava;
import com.helger.pgcc.parser.ExpNonTerminal;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.TokenProduction;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.annotation.Nonnull;

public class TextGenerator
implements IDocGenerator {
    protected PrintWriter m_ostr;

    @Override
    public void text(String string) {
        this.print(string);
    }

    @Override
    public void print(String string) {
        this.m_ostr.print(string);
    }

    @Override
    public void documentStart() {
        this.m_ostr = this.createOutputStream();
        this.m_ostr.print("\nDOCUMENT START\n");
    }

    @Override
    public void documentEnd() {
        this.m_ostr.print("\nDOCUMENT END\n");
        this.m_ostr.close();
    }

    @Override
    public void specialTokens(String string) {
        this.m_ostr.print(string);
    }

    @Override
    public void nonterminalsStart() {
        this.text("NON-TERMINALS\n");
    }

    @Override
    public void nonterminalsEnd() {
    }

    @Override
    public void tokensStart() {
        this.text("TOKENS\n");
    }

    @Override
    public void handleTokenProduction(TokenProduction tokenProduction) {
        String string = JJDoc.getStandardTokenProductionText(tokenProduction);
        this.text(string);
    }

    @Override
    public void tokensEnd() {
    }

    @Override
    public void javacode(CodeProductionJava codeProductionJava) {
        this.productionStart(codeProductionJava);
        this.text("java code");
        this.productionEnd(codeProductionJava);
    }

    @Override
    public void cppcode(CodeProductionCpp codeProductionCpp) {
        this.productionStart(codeProductionCpp);
        this.text("c++ code");
        this.productionEnd(codeProductionCpp);
    }

    @Override
    public void productionStart(NormalProduction normalProduction) {
        this.m_ostr.print("\t" + normalProduction.getLhs() + "\t:=\t");
    }

    @Override
    public void productionEnd(NormalProduction normalProduction) {
        this.m_ostr.print("\n");
    }

    @Override
    public void expansionStart(Expansion expansion, boolean bl) {
        if (!bl) {
            this.m_ostr.print("\n\t\t|\t");
        }
    }

    @Override
    public void expansionEnd(Expansion expansion, boolean bl) {
    }

    @Override
    public void nonTerminalStart(ExpNonTerminal expNonTerminal) {
    }

    @Override
    public void nonTerminalEnd(ExpNonTerminal expNonTerminal) {
    }

    @Override
    public void reStart(AbstractExpRegularExpression abstractExpRegularExpression) {
    }

    @Override
    public void reEnd(AbstractExpRegularExpression abstractExpRegularExpression) {
    }

    @Nonnull
    protected PrintWriter createOutputStream() {
        if (StringHelper.hasNoText((String)JJDocOptions.getOutputFile())) {
            String string;
            if (JJDocGlobals.s_input_file.equals("standard input")) {
                return new PrintWriter(new OutputStreamWriter(System.out));
            }
            String string2 = ".html";
            if (JJDocOptions.isText()) {
                string2 = ".txt";
            } else if (JJDocOptions.isXText()) {
                string2 = ".xtext";
            }
            int n = JJDocGlobals.s_input_file.lastIndexOf(46);
            JJDocGlobals.s_output_file = n == -1 ? JJDocGlobals.s_input_file + string2 : ((string = JJDocGlobals.s_input_file.substring(n)).equals(string2) ? JJDocGlobals.s_input_file + string2 : JJDocGlobals.s_input_file.substring(0, n) + string2);
        } else {
            JJDocGlobals.s_output_file = JJDocOptions.getOutputFile();
        }
        try {
            this.m_ostr = new PrintWriter(new FileWriter(JJDocGlobals.s_output_file));
        }
        catch (IOException iOException) {
            this.error("JJDoc: can't open output stream on file " + JJDocGlobals.s_output_file + ".  Using standard output.");
            this.m_ostr = new PrintWriter(new OutputStreamWriter(System.out));
        }
        return this.m_ostr;
    }
}

