/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjdoc;

import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.pgcc.jjdoc.JJDoc;
import com.helger.pgcc.jjdoc.JJDocGlobals;
import com.helger.pgcc.jjdoc.JJDocOptions;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.JavaCCParser;
import com.helger.pgcc.parser.Main;
import com.helger.pgcc.parser.MetaParseException;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.ParseException;
import java.io.DataInputStream;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;

public final class JJDocMain {
    private JJDocMain() {
    }

    static void help_message() {
        JJDocGlobals.info("");
        JJDocGlobals.info("    jjdoc option-settings - (to read from standard input)");
        JJDocGlobals.info("OR");
        JJDocGlobals.info("    jjdoc option-settings inputfile (to read from a file)");
        JJDocGlobals.info("");
        JJDocGlobals.info("WHERE");
        JJDocGlobals.info("    \"option-settings\" is a sequence of settings separated by spaces.");
        JJDocGlobals.info("");
        JJDocGlobals.info("Each option setting must be of one of the following forms:");
        JJDocGlobals.info("");
        JJDocGlobals.info("    -optionname=value (e.g., -TEXT=false)");
        JJDocGlobals.info("    -optionname:value (e.g., -TEXT:false)");
        JJDocGlobals.info("    -optionname       (equivalent to -optionname=true.  e.g., -TEXT)");
        JJDocGlobals.info("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOTEXT)");
        JJDocGlobals.info("");
        JJDocGlobals.info("Option settings are not case-sensitive, so one can say \"-nOtExT\" instead");
        JJDocGlobals.info("of \"-NOTEXT\".  Option values must be appropriate for the corresponding");
        JJDocGlobals.info("option, and must be either an integer, boolean or string value.");
        JJDocGlobals.info("");
        JJDocGlobals.info("The string valued options are:");
        JJDocGlobals.info("");
        JJDocGlobals.info("    OUTPUT_FILE");
        JJDocGlobals.info("    CSS");
        JJDocGlobals.info("");
        JJDocGlobals.info("The boolean valued options are:");
        JJDocGlobals.info("");
        JJDocGlobals.info("    ONE_TABLE              (default true)");
        JJDocGlobals.info("    TEXT                   (default false)");
        JJDocGlobals.info("    BNF                    (default false)");
        JJDocGlobals.info("");
        JJDocGlobals.info("");
        JJDocGlobals.info("EXAMPLES:");
        JJDocGlobals.info("    jjdoc -ONE_TABLE=false mygrammar.jj");
        JJDocGlobals.info("    jjdoc - < mygrammar.jj");
        JJDocGlobals.info("");
        JJDocGlobals.info("ABOUT JJDoc:");
        JJDocGlobals.info("    JJDoc generates JavaDoc documentation from JavaCC grammar files.");
        JJDocGlobals.info("");
        JJDocGlobals.info("    For more information, see the online JJDoc documentation at");
        JJDocGlobals.info("    https://javacc.dev.java.net/doc/JJDoc.html");
    }

    public static void main(String[] stringArray) throws Exception {
        int n = JJDocMain.mainProgram(stringArray);
        System.exit(n);
    }

    public static int mainProgram(String[] stringArray) throws Exception {
        Main.reInitAll();
        JJDocOptions.init();
        JavaCCGlobals.bannerLine("Documentation Generator", "0.1.4");
        JavaCCParser javaCCParser = null;
        if (stringArray.length == 0) {
            JJDocMain.help_message();
            return 1;
        }
        JJDocGlobals.info("(type \"jjdoc\" with no arguments for help)");
        if (Options.isOption(stringArray[stringArray.length - 1])) {
            JJDocGlobals.error("Last argument \"" + stringArray[stringArray.length - 1] + "\" is not a filename or \"-\".  ");
            return 1;
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!Options.isOption(stringArray[i])) {
                JJDocGlobals.error("Argument \"" + stringArray[i] + "\" must be an option setting.");
                return 1;
            }
            Options.setCmdLineOption(stringArray[i]);
        }
        if (stringArray[stringArray.length - 1].equals("-")) {
            JJDocGlobals.info("Reading from standard input . . .");
            javaCCParser = new JavaCCParser(new DataInputStream(System.in));
            JJDocGlobals.s_input_file = "standard input";
            JJDocGlobals.s_output_file = "standard output";
        } else {
            JJDocGlobals.info("Reading from file " + stringArray[stringArray.length - 1] + " . . .");
            try {
                File file = new File(stringArray[stringArray.length - 1]);
                if (!file.exists()) {
                    JJDocGlobals.error("File " + stringArray[stringArray.length - 1] + " not found.");
                    return 1;
                }
                if (file.isDirectory()) {
                    JJDocGlobals.error(stringArray[stringArray.length - 1] + " is a directory. Please use a valid file name.");
                    return 1;
                }
                JJDocGlobals.s_input_file = file.getName();
                NonBlockingBufferedReader nonBlockingBufferedReader = FileHelper.getBufferedReader((File)new File(stringArray[stringArray.length - 1]), (Charset)Options.getGrammarEncoding());
                if (nonBlockingBufferedReader == null) {
                    JJDocGlobals.error("File " + stringArray[stringArray.length - 1] + " not found.");
                    return 1;
                }
                javaCCParser = new JavaCCParser((Reader)nonBlockingBufferedReader);
            }
            catch (SecurityException securityException) {
                JJDocGlobals.error("Security violation while trying to open " + stringArray[stringArray.length - 1]);
                return 1;
            }
        }
        try {
            javaCCParser.javacc_input();
            JJDoc.start();
            if (JavaCCErrors.getErrorCount() == 0) {
                if (JavaCCErrors.getWarningCount() == 0) {
                    JJDocGlobals.info("Grammar documentation generated successfully in " + JJDocGlobals.s_output_file);
                } else {
                    JJDocGlobals.info("Grammar documentation generated with 0 errors and " + JavaCCErrors.getWarningCount() + " warnings.");
                }
                return 0;
            }
            JJDocGlobals.error("Detected " + JavaCCErrors.getErrorCount() + " errors and " + JavaCCErrors.getWarningCount() + " warnings.");
            return JavaCCErrors.getErrorCount() == 0 ? 0 : 1;
        }
        catch (MetaParseException metaParseException) {
            JJDocGlobals.error(metaParseException.toString());
            JJDocGlobals.error("Detected " + JavaCCErrors.getErrorCount() + " errors and " + JavaCCErrors.getWarningCount() + " warnings.");
            return 1;
        }
        catch (ParseException parseException) {
            JJDocGlobals.error(parseException.toString());
            JJDocGlobals.error("Detected " + (JavaCCErrors.getErrorCount() + 1) + " errors and " + JavaCCErrors.getWarningCount() + " warnings.");
            return 1;
        }
    }
}

