/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjdoc;

import com.helger.commons.string.StringHelper;
import com.helger.pgcc.jjdoc.JJDoc;
import com.helger.pgcc.jjdoc.JJDocGlobals;
import com.helger.pgcc.jjdoc.JJDocOptions;
import com.helger.pgcc.jjdoc.TextGenerator;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.CodeProductionCpp;
import com.helger.pgcc.parser.CodeProductionJava;
import com.helger.pgcc.parser.ExpNonTerminal;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.TokenProduction;
import java.util.HashMap;
import java.util.Map;

public class HTMLGenerator
extends TextGenerator {
    private final Map<String, String> id_map = new HashMap<String, String>();
    private int id = 1;

    protected String get_id(String string2) {
        return this.id_map.computeIfAbsent(string2, string -> "prod" + this.id++);
    }

    private void println(String string) {
        this.print(string + "\n");
    }

    @Override
    public void text(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        block5: for (char c : string.toCharArray()) {
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block5;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        this.print(stringBuilder.toString());
    }

    @Override
    public void print(String string) {
        this.m_ostr.print(string);
    }

    @Override
    public void documentStart() {
        this.m_ostr = this.createOutputStream();
        this.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
        this.println("<HTML>");
        this.println("<HEAD>");
        if (StringHelper.hasText((String)JJDocOptions.getCSS())) {
            this.println("<LINK REL=\"stylesheet\" type=\"text/css\" href=\"" + JJDocOptions.getCSS() + "\"/>");
        }
        if (StringHelper.hasText((String)JJDocGlobals.s_input_file)) {
            this.println("<TITLE>BNF for " + JJDocGlobals.s_input_file + "</TITLE>");
        } else {
            this.println("<TITLE>A BNF grammar by JJDoc</TITLE>");
        }
        this.println("</HEAD>");
        this.println("<BODY>");
        this.println("<H1 ALIGN=CENTER>BNF for " + JJDocGlobals.s_input_file + "</H1>");
    }

    @Override
    public void documentEnd() {
        this.println("</BODY>");
        this.println("</HTML>");
        this.m_ostr.close();
    }

    @Override
    public void specialTokens(String string) {
        this.println(" <!-- Special token -->");
        this.println(" <TR>");
        this.println("  <TD>");
        this.println("<PRE>");
        this.print(string);
        this.println("</PRE>");
        this.println("  </TD>");
        this.println(" </TR>");
    }

    @Override
    public void handleTokenProduction(TokenProduction tokenProduction) {
        this.println(" <!-- Token -->");
        this.println(" <TR>");
        this.println("  <TD>");
        this.println("   <PRE>");
        String string = JJDoc.getStandardTokenProductionText(tokenProduction);
        this.text(string);
        this.println("   </PRE>");
        this.println("  </TD>");
        this.println(" </TR>");
    }

    @Override
    public void nonterminalsStart() {
        this.println("<H2 ALIGN=CENTER>NON-TERMINALS</H2>");
        if (JJDocOptions.isOneTable()) {
            this.println("<TABLE>");
        }
    }

    @Override
    public void nonterminalsEnd() {
        if (JJDocOptions.isOneTable()) {
            this.println("</TABLE>");
        }
    }

    @Override
    public void tokensStart() {
        this.println("<H2 ALIGN=CENTER>TOKENS</H2>");
        this.println("<TABLE>");
    }

    @Override
    public void tokensEnd() {
        this.println("</TABLE>");
    }

    @Override
    public void javacode(CodeProductionJava codeProductionJava) {
        this.productionStart(codeProductionJava);
        this.println("<I>java code</I></TD></TR>");
        this.productionEnd(codeProductionJava);
    }

    @Override
    public void cppcode(CodeProductionCpp codeProductionCpp) {
        this.productionStart(codeProductionCpp);
        this.println("<I>cpp code</I></TD></TR>");
        this.productionEnd(codeProductionCpp);
    }

    @Override
    public void productionStart(NormalProduction normalProduction) {
        if (!JJDocOptions.isOneTable()) {
            this.println("");
            this.println("<TABLE ALIGN=CENTER>");
            this.println("<CAPTION><STRONG>" + normalProduction.getLhs() + "</STRONG></CAPTION>");
        }
        this.println("<TR>");
        this.println("<TD ALIGN=RIGHT VALIGN=BASELINE><A NAME=\"" + this.get_id(normalProduction.getLhs()) + "\">" + normalProduction.getLhs() + "</A></TD>");
        this.println("<TD ALIGN=CENTER VALIGN=BASELINE>::=</TD>");
        this.print("<TD ALIGN=LEFT VALIGN=BASELINE>");
    }

    @Override
    public void productionEnd(NormalProduction normalProduction) {
        if (!JJDocOptions.isOneTable()) {
            this.println("</TABLE>");
            this.println("<HR>");
        }
    }

    @Override
    public void expansionStart(Expansion expansion, boolean bl) {
        if (!bl) {
            this.println("<TR>");
            this.println("<TD ALIGN=RIGHT VALIGN=BASELINE></TD>");
            this.println("<TD ALIGN=CENTER VALIGN=BASELINE>|</TD>");
            this.print("<TD ALIGN=LEFT VALIGN=BASELINE>");
        }
    }

    @Override
    public void expansionEnd(Expansion expansion, boolean bl) {
        this.println("</TD>");
        this.println("</TR>");
    }

    @Override
    public void nonTerminalStart(ExpNonTerminal expNonTerminal) {
        this.print("<A HREF=\"#" + this.get_id(expNonTerminal.getName()) + "\">");
    }

    @Override
    public void nonTerminalEnd(ExpNonTerminal expNonTerminal) {
        this.print("</A>");
    }

    @Override
    public void reStart(AbstractExpRegularExpression abstractExpRegularExpression) {
    }

    @Override
    public void reEnd(AbstractExpRegularExpression abstractExpRegularExpression) {
    }
}

