/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjdoc;

import com.helger.commons.string.StringHelper;
import com.helger.pgcc.jjdoc.IDocGenerator;
import com.helger.pgcc.jjdoc.JJDoc;
import com.helger.pgcc.jjdoc.JJDocGlobals;
import com.helger.pgcc.jjdoc.JJDocOptions;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.CodeProductionCpp;
import com.helger.pgcc.parser.CodeProductionJava;
import com.helger.pgcc.parser.ExpNonTerminal;
import com.helger.pgcc.parser.ExpRCharacterList;
import com.helger.pgcc.parser.ExpRJustName;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.TokenProduction;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class BNFGenerator
implements IDocGenerator {
    private final Map<String, String> m_id_map = new HashMap<String, String>();
    private int m_id = 1;
    protected PrintWriter m_ostr;
    private boolean m_bPrinting = true;

    protected String get_id(String string2) {
        return this.m_id_map.computeIfAbsent(string2, string -> "prod" + this.m_id++);
    }

    protected PrintWriter create_output_stream() {
        if (StringHelper.hasNoText((String)JJDocOptions.getOutputFile())) {
            String string;
            if (JJDocGlobals.s_input_file.equals("standard input")) {
                return new PrintWriter(new OutputStreamWriter(System.out));
            }
            int n = JJDocGlobals.s_input_file.lastIndexOf(46);
            JJDocGlobals.s_output_file = n == -1 ? JJDocGlobals.s_input_file + ".bnf" : ((string = JJDocGlobals.s_input_file.substring(n)).equals(".bnf") ? JJDocGlobals.s_input_file + ".bnf" : JJDocGlobals.s_input_file.substring(0, n) + ".bnf");
        } else {
            JJDocGlobals.s_output_file = JJDocOptions.getOutputFile();
        }
        try {
            this.m_ostr = new PrintWriter(new FileWriter(JJDocGlobals.s_output_file));
        }
        catch (IOException iOException) {
            this.error("JJDoc: can't open output stream on file " + JJDocGlobals.s_output_file + ".  Using standard output.");
            this.m_ostr = new PrintWriter(new OutputStreamWriter(System.out));
        }
        return this.m_ostr;
    }

    private void println(String string) {
        this.print(string + "\n");
    }

    @Override
    public void text(String string) {
        if (this.m_bPrinting && (string.length() != 1 || string.charAt(0) != '\n' && string.charAt(0) != '\r')) {
            this.print(string);
        }
    }

    @Override
    public void print(String string) {
        this.m_ostr.print(string);
    }

    @Override
    public void documentStart() {
        this.m_ostr = this.create_output_stream();
    }

    @Override
    public void documentEnd() {
        this.m_ostr.close();
    }

    @Override
    public void specialTokens(String string) {
    }

    @Override
    public void nonterminalsStart() {
    }

    @Override
    public void nonterminalsEnd() {
    }

    @Override
    public void tokensStart() {
    }

    @Override
    public void tokensEnd() {
    }

    @Override
    public void javacode(CodeProductionJava codeProductionJava) {
    }

    @Override
    public void cppcode(CodeProductionCpp codeProductionCpp) {
    }

    @Override
    public void expansionEnd(Expansion expansion, boolean bl) {
    }

    @Override
    public void nonTerminalStart(ExpNonTerminal expNonTerminal) {
    }

    @Override
    public void nonTerminalEnd(ExpNonTerminal expNonTerminal) {
    }

    @Override
    public void productionStart(NormalProduction normalProduction) {
        this.println("");
        this.print(normalProduction.getLhs() + " ::= ");
    }

    @Override
    public void productionEnd(NormalProduction normalProduction) {
        this.println("");
    }

    @Override
    public void expansionStart(Expansion expansion, boolean bl) {
        if (!bl) {
            this.print(" | ");
        }
    }

    @Override
    public void reStart(AbstractExpRegularExpression abstractExpRegularExpression) {
        if (abstractExpRegularExpression.getClass().equals(ExpRJustName.class) || abstractExpRegularExpression.getClass().equals(ExpRCharacterList.class)) {
            this.m_bPrinting = false;
        }
    }

    @Override
    public void reEnd(AbstractExpRegularExpression abstractExpRegularExpression) {
        this.m_bPrinting = true;
    }

    @Override
    public void handleTokenProduction(TokenProduction tokenProduction) {
        this.m_bPrinting = false;
        String string = JJDoc.getStandardTokenProductionText(tokenProduction);
        this.text(string);
        this.m_bPrinting = true;
    }
}

