/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc;

import javax.annotation.Nullable;

public enum EJDKVersion {
    JDK_11(1),
    JDK_12(2),
    JDK_13(3),
    JDK_14(4),
    JDK_15(5),
    JDK_16(6),
    JDK_17(7),
    JDK_18(8),
    JDK_19(9);

    private int m_nMajor;

    private EJDKVersion(int n2) {
        this.m_nMajor = n2;
    }

    public boolean isNewerOrEqualsThan(EJDKVersion eJDKVersion) {
        return this.m_nMajor >= eJDKVersion.m_nMajor;
    }

    private double _getAsDouble1x() {
        return 1.0 + (double)this.m_nMajor / 10.0;
    }

    @Nullable
    public static EJDKVersion getFromDoubleOrNull(double d) {
        if (d >= 1.0 && d <= 2.0) {
            for (EJDKVersion eJDKVersion : EJDKVersion.values()) {
                if (d != eJDKVersion._getAsDouble1x()) continue;
                return eJDKVersion;
            }
            return null;
        }
        int n = (int)d;
        for (EJDKVersion eJDKVersion : EJDKVersion.values()) {
            if (n != eJDKVersion.m_nMajor) continue;
            return eJDKVersion;
        }
        return null;
    }
}

