/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JCEqualsHelper {
    private JCEqualsHelper() {
    }

    public static boolean isEqual(boolean bl, boolean bl2) {
        return bl == bl2;
    }

    public static boolean isEqual(byte by, byte by2) {
        return by == by2;
    }

    public static boolean isEqual(char c, char c2) {
        return c == c2;
    }

    public static boolean isEqual(double d, double d2) {
        return d == d2 || Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean isEqual(float f, float f2) {
        return f == f2 || Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static boolean isEqual(int n, int n2) {
        return n == n2;
    }

    public static boolean isEqual(long l, long l2) {
        return l == l2;
    }

    public static boolean isEqual(short s, short s2) {
        return s == s2;
    }

    public static boolean isEqual(@Nullable Object object, @Nullable Object object2) {
        Class<?> clazz;
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Class<?> clazz2 = object.getClass();
        if (!clazz2.equals(clazz = object2.getClass())) {
            return false;
        }
        if (clazz2.isArray()) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            Object[] objectArray2 = (Object[])object2;
            if (n != objectArray2.length) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (JCEqualsHelper.isEqual(objectArray[i], objectArray2[i])) continue;
                return false;
            }
            return true;
        }
        if (clazz2.equals(boolean[].class)) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        if (clazz2.equals(byte[].class)) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (clazz2.equals(char[].class)) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (clazz2.equals(double[].class)) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (clazz2.equals(float[].class)) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (clazz2.equals(int[].class)) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (clazz2.equals(long[].class)) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (clazz2.equals(short[].class)) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        return object.equals(object2);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static boolean nullSafeEqualsIgnoreCase(@Nullable String string, @Nullable String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }
}

