/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.meta;

import com.helger.jcodemodel.AbstractJType;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class TypeEnvironment {
    private final Map<String, AbstractJType> m_aMap = new TreeMap<String, AbstractJType>();
    private final TypeEnvironment m_aParent;
    private final String m_sPackageName;

    TypeEnvironment(String string) {
        this.m_aParent = null;
        this.m_sPackageName = string;
    }

    private TypeEnvironment(TypeEnvironment typeEnvironment) {
        this.m_sPackageName = null;
        this.m_aParent = typeEnvironment;
    }

    @Nonnull
    public TypeEnvironment enclosed() {
        return new TypeEnvironment(this);
    }

    @Nullable
    public AbstractJType get(@Nonnull String string) {
        AbstractJType abstractJType = this.m_aMap.get(string);
        if (abstractJType != null || this.m_aParent == null) {
            return abstractJType;
        }
        return this.m_aParent.get(string);
    }

    public void put(@Nonnull String string, AbstractJType abstractJType) {
        this.m_aMap.put(string, abstractJType);
    }

    @Nullable
    String packageName() {
        return this.m_aParent == null ? this.m_sPackageName : this.m_aParent.packageName();
    }
}

