/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.meta;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.meta.CodeModelBuildingException;
import com.helger.jcodemodel.meta.DecidedErrorTypesModelsAdapter;
import com.helger.jcodemodel.meta.ErrorTypeFound;
import com.helger.jcodemodel.meta.TypeEnvironment;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;

class Annotator {
    private final DecidedErrorTypesModelsAdapter m_aModelsAdapter;
    private final IJAnnotatable m_aAnnotatable;
    private final TypeEnvironment m_aTypeEnvironment;

    public Annotator(DecidedErrorTypesModelsAdapter decidedErrorTypesModelsAdapter, IJAnnotatable iJAnnotatable, TypeEnvironment typeEnvironment) {
        this.m_aModelsAdapter = decidedErrorTypesModelsAdapter;
        this.m_aAnnotatable = iJAnnotatable;
        this.m_aTypeEnvironment = typeEnvironment;
    }

    void annotate(@Nonnull List<? extends AnnotationMirror> list) throws CodeModelBuildingException, IllegalStateException, ErrorTypeFound {
        for (AnnotationMirror annotationMirror : list) {
            this._annotate(annotationMirror);
        }
    }

    private void _annotate(@Nonnull AnnotationMirror annotationMirror) throws CodeModelBuildingException, IllegalStateException, ErrorTypeFound {
        JAnnotationUse jAnnotationUse = this.m_aAnnotatable.annotate((AbstractJClass)this.m_aModelsAdapter.toJType(annotationMirror.getAnnotationType(), this.m_aTypeEnvironment));
        ArgumentAdder argumentAdder = new ArgumentAdder(jAnnotationUse);
        argumentAdder.addArguments(annotationMirror);
    }

    class ArgumentAdder {
        private final JAnnotationUse m_aAnnotationUse;

        public ArgumentAdder(JAnnotationUse jAnnotationUse) {
            this.m_aAnnotationUse = jAnnotationUse;
        }

        void addArguments(AnnotationMirror annotationMirror) throws CodeModelBuildingException, IllegalStateException, ErrorTypeFound {
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = Annotator.this.m_aModelsAdapter.getElementValuesWithDefaults(annotationMirror);
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                String string = entry.getKey().getSimpleName().toString();
                Object object = entry.getValue().getValue();
                this._addArgument(string, object);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void _addArgument(String string, Object object) throws IllegalStateException, CodeModelBuildingException, ErrorTypeFound {
            if (object instanceof String) {
                this.m_aAnnotationUse.param(string, (String)object);
                return;
            } else if (object instanceof Integer) {
                this.m_aAnnotationUse.param(string, (Integer)object);
                return;
            } else if (object instanceof Long) {
                this.m_aAnnotationUse.param(string, (Long)object);
                return;
            } else if (object instanceof Short) {
                this.m_aAnnotationUse.param(string, (Short)object);
                return;
            } else if (object instanceof Float) {
                this.m_aAnnotationUse.param(string, ((Float)object).floatValue());
                return;
            } else if (object instanceof Double) {
                this.m_aAnnotationUse.param(string, (Double)object);
                return;
            } else if (object instanceof Byte) {
                this.m_aAnnotationUse.param(string, (Byte)object);
                return;
            } else if (object instanceof Character) {
                this.m_aAnnotationUse.param(string, ((Character)object).charValue());
                return;
            } else if (object instanceof Boolean) {
                this.m_aAnnotationUse.param(string, (Boolean)object);
                return;
            } else if (object instanceof Class) {
                this.m_aAnnotationUse.param(string, (Class)object);
                return;
            } else if (object instanceof DeclaredType) {
                this.m_aAnnotationUse.param(string, Annotator.this.m_aModelsAdapter.toJType((DeclaredType)object, Annotator.this.m_aTypeEnvironment));
                return;
            } else if (object instanceof VariableElement) {
                try {
                    this.m_aAnnotationUse.param(string, this._actualEnumConstantValue((VariableElement)object));
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(Annotator.class.getName()).log(Level.WARNING, "Not processing annotation argument: {0}: {1}", new Object[]{string, object});
                }
                return;
            } else if (object instanceof AnnotationMirror) {
                AnnotationMirror annotationMirror = (AnnotationMirror)object;
                AbstractJClass abstractJClass = (AbstractJClass)Annotator.this.m_aModelsAdapter.toJType(annotationMirror.getAnnotationType(), Annotator.this.m_aTypeEnvironment);
                JAnnotationUse jAnnotationUse = this.m_aAnnotationUse.annotationParam(string, abstractJClass);
                ArgumentAdder argumentAdder = new ArgumentAdder(jAnnotationUse);
                argumentAdder.addArguments(annotationMirror);
                return;
            } else {
                if (!(object instanceof List)) throw new IllegalStateException(MessageFormat.format("Unknown annotation argument: {0}: {1} ({2})", string, object, object.getClass()));
                List list = (List)object;
                Iterator iterator = list.iterator();
                if (!iterator.hasNext()) return;
                AnnotationValue annotationValue = (AnnotationValue)iterator.next();
                Object object2 = annotationValue.getValue();
                if (object2 instanceof String) {
                    String[] stringArray = new String[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue2 : list) {
                        stringArray[n] = (String)annotationValue2.getValue();
                        ++n;
                    }
                    this.m_aAnnotationUse.paramArray(string, stringArray);
                    return;
                } else if (object2 instanceof Integer) {
                    int[] nArray = new int[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue3 : list) {
                        nArray[n] = (Integer)annotationValue3.getValue();
                        ++n;
                    }
                    this.m_aAnnotationUse.paramArray(string, nArray);
                    return;
                } else if (object2 instanceof Long) {
                    long[] lArray = new long[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue4 : list) {
                        lArray[n] = (Long)annotationValue4.getValue();
                        ++n;
                    }
                    this.m_aAnnotationUse.paramArray(string, lArray);
                    return;
                } else if (object2 instanceof Short) {
                    short[] sArray = new short[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue5 : list) {
                        sArray[n] = (Short)annotationValue5.getValue();
                        ++n;
                    }
                    this.m_aAnnotationUse.paramArray(string, sArray);
                    return;
                } else if (object2 instanceof Float) {
                    float[] fArray = new float[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue6 : list) {
                        fArray[n] = ((Float)annotationValue6.getValue()).floatValue();
                        ++n;
                    }
                    this.m_aAnnotationUse.paramArray(string, fArray);
                    return;
                } else if (object2 instanceof Double) {
                    double[] dArray = new double[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue7 : list) {
                        dArray[n] = (Double)annotationValue7.getValue();
                        ++n;
                    }
                    this.m_aAnnotationUse.paramArray(string, dArray);
                    return;
                } else if (object2 instanceof Byte) {
                    byte[] byArray = new byte[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue8 : list) {
                        byArray[n] = (Byte)annotationValue8.getValue();
                        ++n;
                    }
                    this.m_aAnnotationUse.paramArray(string, byArray);
                    return;
                } else if (object2 instanceof Character) {
                    char[] cArray = new char[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue9 : list) {
                        cArray[n] = ((Character)annotationValue9.getValue()).charValue();
                        ++n;
                    }
                    this.m_aAnnotationUse.paramArray(string, cArray);
                    return;
                } else if (object2 instanceof Boolean) {
                    boolean[] blArray = new boolean[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue10 : list) {
                        blArray[n] = (Boolean)annotationValue10.getValue();
                        ++n;
                    }
                    this.m_aAnnotationUse.paramArray(string, blArray);
                    return;
                } else if (object2 instanceof Class) {
                    Class[] classArray = new Class[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue11 : list) {
                        classArray[n] = (Class)annotationValue11.getValue();
                        ++n;
                    }
                    this.m_aAnnotationUse.paramArray(string, classArray);
                    return;
                } else if (object2 instanceof DeclaredType) {
                    AbstractJType[] abstractJTypeArray = new AbstractJType[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue12 : list) {
                        abstractJTypeArray[n] = Annotator.this.m_aModelsAdapter.toJType((DeclaredType)annotationValue12.getValue(), Annotator.this.m_aTypeEnvironment);
                        ++n;
                    }
                    this.m_aAnnotationUse.paramArray(string, abstractJTypeArray);
                    return;
                } else if (object2 instanceof VariableElement) {
                    try {
                        Enum[] enumArray = new Enum[list.size()];
                        int n = 0;
                        for (AnnotationValue annotationValue13 : list) {
                            enumArray[n] = this._actualEnumConstantValue((VariableElement)annotationValue13.getValue());
                            ++n;
                        }
                        this.m_aAnnotationUse.paramArray(string, enumArray);
                        return;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logger.getLogger(Annotator.class.getName()).log(Level.WARNING, "Not processing annotation argument: {0}: {1}", new Object[]{string, list});
                    }
                    return;
                } else {
                    if (!(object2 instanceof AnnotationMirror)) throw new IllegalStateException(MessageFormat.format("Unknown annotation array argument: {0}: {1} ({2})", string, object2, object2.getClass()));
                    JAnnotationArrayMember jAnnotationArrayMember = this.m_aAnnotationUse.paramArray(string);
                    for (AnnotationValue annotationValue14 : list) {
                        AnnotationMirror annotationMirror = (AnnotationMirror)annotationValue14.getValue();
                        AbstractJClass abstractJClass = (AbstractJClass)Annotator.this.m_aModelsAdapter.toJType(annotationMirror.getAnnotationType(), Annotator.this.m_aTypeEnvironment);
                        JAnnotationUse jAnnotationUse = jAnnotationArrayMember.annotate(abstractJClass);
                        ArgumentAdder argumentAdder = new ArgumentAdder(jAnnotationUse);
                        argumentAdder.addArguments(annotationMirror);
                    }
                }
            }
        }

        private Enum<?> _actualEnumConstantValue(VariableElement variableElement) throws ClassNotFoundException {
            Enum enum_;
            Field field;
            TypeElement typeElement = (TypeElement)variableElement.getEnclosingElement();
            Class<?> clazz = Class.forName(typeElement.getQualifiedName().toString());
            try {
                field = clazz.getField(variableElement.getSimpleName().toString());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalStateException("Unable to load enum constant: " + typeElement.getQualifiedName().toString() + "." + variableElement.getSimpleName().toString(), noSuchFieldException);
            }
            catch (SecurityException securityException) {
                throw new IllegalStateException("Unable to load enum constant: " + typeElement.getQualifiedName().toString() + "." + variableElement.getSimpleName().toString(), securityException);
            }
            try {
                enum_ = (Enum)field.get(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException("Unable to load enum constant actual value: " + typeElement.getQualifiedName().toString() + "." + variableElement.getSimpleName().toString(), illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Unable to load enum constant actual value:" + typeElement.getQualifiedName().toString() + "." + variableElement.getSimpleName().toString(), illegalAccessException);
            }
            return enum_;
        }
    }
}

