/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.JFormatter;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JCommentPart
extends ArrayList<Object> {
    @Nonnull
    public JCommentPart append(@Nullable Object object) {
        this.add(object);
        return this;
    }

    @Override
    public boolean add(@Nullable Object object) {
        this._flattenAppend(object);
        return true;
    }

    private void _flattenAppend(@Nullable Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                this._flattenAppend(object2);
            }
        } else if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                this._flattenAppend(e);
            }
        } else if (object instanceof String || object instanceof AbstractJType) {
            super.add(object);
        } else {
            throw new IllegalArgumentException("Value is of an unsupported type: " + object.getClass().toString());
        }
    }

    protected void format(@Nonnull JFormatter jFormatter, String string) {
        if (!jFormatter.isPrinting()) {
            for (Object e : this) {
                if (!(e instanceof AbstractJClass)) continue;
                jFormatter.generable((AbstractJClass)e);
            }
            return;
        }
        if (!this.isEmpty()) {
            jFormatter.print(string);
        }
        for (Object e : this) {
            if (e instanceof String) {
                int n;
                String string2 = (String)e;
                while ((n = string2.indexOf(10)) != -1) {
                    String string3 = string2.substring(0, n);
                    if (string3.length() > 0) {
                        jFormatter.print(JCommentPart._escape(string3));
                    }
                    string2 = string2.substring(n + 1);
                    jFormatter.newline().print(string);
                }
                if (string2.length() == 0) continue;
                jFormatter.print(JCommentPart._escape(string2));
                continue;
            }
            if (e instanceof AbstractJClass) {
                ((AbstractJClass)e).printLink(jFormatter);
                continue;
            }
            if (e instanceof AbstractJType) {
                jFormatter.generable((AbstractJType)e);
                continue;
            }
            throw new IllegalStateException("Invalid type present: " + e);
        }
        if (!this.isEmpty()) {
            jFormatter.newline();
        }
    }

    private static String _escape(@Nonnull String string) {
        String string2 = string;
        int n;
        while ((n = string2.indexOf("*/")) >= 0) {
            string2 = string2.substring(0, n + 1) + "<!---->" + string2.substring(n + 1);
        }
        return string2;
    }
}

