/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.IJClassContainer;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JPackage;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractJClassContainer<CLASSTYPE extends AbstractJClassContainer<CLASSTYPE>>
extends AbstractJClass
implements IJClassContainer<CLASSTYPE> {
    private final IJClassContainer<?> m_aOuter;
    private final EClassType m_eClassType;
    private final String m_sName;
    protected Map<String, CLASSTYPE> m_aClasses;

    protected AbstractJClassContainer(@Nonnull JCodeModel jCodeModel, @Nullable IJClassContainer<?> iJClassContainer, @Nonnull EClassType eClassType, @Nullable String string) {
        super(jCodeModel);
        this.m_aOuter = iJClassContainer;
        this.m_eClassType = eClassType;
        this.m_sName = string;
    }

    @Nullable
    public final IJClassContainer<?> getOuter() {
        return this.m_aOuter;
    }

    @Override
    @Nullable
    public final AbstractJClass outer() {
        if (this.m_aOuter != null && this.m_aOuter.isClass()) {
            return (AbstractJClass)((Object)this.m_aOuter);
        }
        return null;
    }

    @Nonnull
    public final EClassType getClassType() {
        return this.m_eClassType;
    }

    @Override
    public final boolean isInterface() {
        return this.m_eClassType == EClassType.INTERFACE;
    }

    public final boolean isAnnotationTypeDeclaration() {
        return this.m_eClassType == EClassType.ANNOTATION_TYPE_DECL;
    }

    @Override
    @Nullable
    public String name() {
        return this.m_sName;
    }

    @Override
    @Nullable
    public String fullName() {
        if (this.getOuter() instanceof AbstractJClassContainer) {
            return ((AbstractJClassContainer)this.getOuter()).fullName() + '.' + this.name();
        }
        JPackage jPackage = this._package();
        if (jPackage.isUnnamed()) {
            return this.name();
        }
        return jPackage.name() + '.' + this.name();
    }

    public final boolean isAnonymous() {
        return this.m_sName == null;
    }

    @Override
    public final boolean isClass() {
        return true;
    }

    @Override
    public final boolean isPackage() {
        return false;
    }

    @Nonnull
    protected final CLASSTYPE thisAsT() {
        return (CLASSTYPE)this;
    }

    @Override
    @Nonnull
    public final IJClassContainer<?> parentContainer() {
        return this.m_aOuter;
    }

    @Override
    public final JPackage getPackage() {
        return this.parentContainer().getPackage();
    }

    @Nonnull
    private Map<String, CLASSTYPE> _getClasses() {
        if (this.m_aClasses == null) {
            this.m_aClasses = new TreeMap<String, CLASSTYPE>();
        }
        return this.m_aClasses;
    }

    @Nonnull
    protected abstract CLASSTYPE createInnerClass(int var1, @Nonnull EClassType var2, @Nonnull String var3);

    @Override
    @Nonnull
    public final CLASSTYPE _class(int n, @Nonnull String string, @Nonnull EClassType eClassType) throws JClassAlreadyExistsException {
        String string2 = JCodeModel.isFileSystemCaseSensitive() ? string.toUpperCase(Locale.US) : string;
        AbstractJClassContainer abstractJClassContainer = (AbstractJClassContainer)this._getClasses().get(string2);
        if (abstractJClassContainer != null) {
            throw new JClassAlreadyExistsException(abstractJClassContainer);
        }
        CLASSTYPE CLASSTYPE = this.createInnerClass(n, eClassType, string);
        this._getClasses().put(string2, CLASSTYPE);
        return CLASSTYPE;
    }

    @Override
    @Nonnull
    public final Collection<CLASSTYPE> classes() {
        if (this.m_aClasses == null) {
            return Collections.emptyList();
        }
        return this.m_aClasses.values();
    }
}

