/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJAnnotationValue;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJOwned;
import com.helger.jcodemodel.JAnnotationStringValue;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCNameUtilities;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public abstract class AbstractJAnnotationValueOwned
extends AbstractJAnnotationValue
implements IJOwned {
    @Nonnull
    public AbstractJAnnotationValue wrap(@Nonnull Enum<?> enum_) {
        return new JAnnotationStringValue(new JEnumConstantExpr(enum_), enum_);
    }

    @Nonnull
    public AbstractJAnnotationValue wrap(@Nonnull Class<?> clazz) {
        return new JAnnotationStringValue(new FullClassNameExpr(clazz), clazz);
    }

    protected final class FullClassNameExpr
    implements IJExpression {
        private final Class<?> m_aClass;

        protected FullClassNameExpr(Class<?> clazz) {
            this.m_aClass = JCValueEnforcer.notNull(clazz, "Class");
        }

        @Override
        public void generate(@Nonnull JFormatter jFormatter) {
            jFormatter.print(JCNameUtilities.getFullName(this.m_aClass)).print(".class");
        }
    }

    protected final class JEnumConstantExpr
    implements IJExpression {
        private final Enum<?> m_aEnumConstant;

        protected JEnumConstantExpr(Enum<?> enum_) {
            this.m_aEnumConstant = JCValueEnforcer.notNull(enum_, "EnumConstant");
        }

        @Override
        public void generate(@Nonnull JFormatter jFormatter) {
            jFormatter.type(AbstractJAnnotationValueOwned.this.owner().ref(this.m_aEnumConstant.getDeclaringClass())).print('.').print(this.m_aEnumConstant.name());
        }
    }
}

