/*
 * Decompiled with CFR 0.152.
 */
package com.helger.font.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.font.api.EFontType;
import com.helger.font.api.IFontResource;
import com.helger.font.api.IFontStyle;
import com.helger.font.api.IFontWeight;
import java.io.InputStream;
import javax.annotation.Nonnull;

public class FontResource
implements IFontResource {
    private final String m_sID;
    private final String m_sFontName;
    private final EFontType m_eFontType;
    private final IFontStyle m_aFontStyle;
    private final IFontWeight m_aFontWeight;
    private final String m_sPath;

    public FontResource(@Nonnull @Nonempty String string, @Nonnull EFontType eFontType, @Nonnull IFontStyle iFontStyle, @Nonnull IFontWeight iFontWeight, @Nonnull @Nonempty String string2) {
        this.m_sFontName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"FontName");
        this.m_eFontType = (EFontType)((Object)ValueEnforcer.notNull((Object)((Object)eFontType), (String)"FontType"));
        this.m_aFontStyle = (IFontStyle)ValueEnforcer.notNull((Object)iFontStyle, (String)"FontStyle");
        this.m_aFontWeight = (IFontWeight)ValueEnforcer.notNull((Object)iFontWeight, (String)"FontWeight");
        this.m_sPath = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"Path");
        this.m_sID = string + ":" + eFontType.getID() + ":" + (String)iFontStyle.getID() + ":" + iFontWeight.getWeight();
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getFontName() {
        return this.m_sFontName;
    }

    @Override
    @Nonnull
    public EFontType getFontType() {
        return this.m_eFontType;
    }

    @Override
    @Nonnull
    public IFontStyle getFontStyle() {
        return this.m_aFontStyle;
    }

    @Override
    @Nonnull
    public IFontWeight getFontWeight() {
        return this.m_aFontWeight;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getPath() {
        return this.m_sPath;
    }

    @Nonnull
    public ClassPathResource getResource() {
        return new ClassPathResource(this.m_sPath);
    }

    @Nonnull
    public InputStream getInputStream() {
        return ClassPathResource.getInputStream((String)this.m_sPath);
    }

    public boolean isReadMultiple() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FontResource fontResource = (FontResource)object;
        return this.m_sID.equals(fontResource.m_sID) && this.m_sPath.equals(fontResource.m_sPath);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append((Object)this.m_sPath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("FontName", (Object)this.m_sFontName).append("FontType", (Enum)this.m_eFontType).append("FontStyle", (Object)this.m_aFontStyle).append("FontWeight", (Object)this.m_aFontWeight).append("Path", (Object)this.m_sPath).getToString();
    }
}

