/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.xml.EXMLVersion;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum EXMLSerializeVersion implements IHasID<String>
{
    XML_10("xml10", EXMLVersion.XML_10),
    XML_11("xml11", EXMLVersion.XML_11),
    HTML("html", null);

    private final String m_sID;
    private final EXMLVersion m_eXMLVersion;

    private EXMLSerializeVersion(String string2, EXMLVersion eXMLVersion) {
        this.m_sID = string2;
        this.m_eXMLVersion = eXMLVersion;
    }

    public @NonNull @Nonempty String getID() {
        return this.m_sID;
    }

    public boolean isXML() {
        return this == XML_10 || this == XML_11;
    }

    public boolean isHTML() {
        return this == HTML;
    }

    public @Nullable EXMLVersion getXMLVersionOrDefault(@Nullable EXMLVersion eXMLVersion) {
        return this.m_eXMLVersion == null ? eXMLVersion : this.m_eXMLVersion;
    }

    public @Nullable String getXMLVersionString() {
        return this.m_eXMLVersion == null ? null : this.m_eXMLVersion.getVersion();
    }

    public static @NonNull EXMLSerializeVersion getFromXMLVersionOrThrow(@NonNull EXMLVersion eXMLVersion) {
        return switch (eXMLVersion) {
            case EXMLVersion.XML_10 -> XML_10;
            case EXMLVersion.XML_11 -> XML_11;
            default -> throw new IllegalStateException("Unsupported XML version " + String.valueOf((Object)eXMLVersion));
        };
    }

    public static @Nullable EXMLSerializeVersion getFromIDOrNull(@Nullable String string) {
        return (EXMLSerializeVersion)EnumHelper.getFromIDOrNull(EXMLSerializeVersion.class, (Object)string);
    }
}

