/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.schema;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.impl.Cache;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.resource.IReadableResource;
import com.helger.xml.transform.TransformSourceFactory;
import java.util.Collection;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@ThreadSafe
public class SchemaCache
extends Cache<ICommonsList<? extends IReadableResource>, Schema> {
    private final String m_sSchemaTypeName;
    private final SchemaFactory m_aSchemaFactory;

    public SchemaCache(@NonNull String string, @NonNull SchemaFactory schemaFactory, @Nullable ErrorHandler errorHandler, @Nullable LSResourceResolver lSResourceResolver) {
        super(iCommonsList -> SchemaCache.createSchema(schemaFactory, string, (ICommonsList<? extends IReadableResource>)iCommonsList), 500, SchemaCache.class.getName() + "$" + string);
        ValueEnforcer.notNull((Object)string, (String)"SchemaTypeName");
        ValueEnforcer.notNull((Object)schemaFactory, (String)"SchemaFactory");
        this.m_sSchemaTypeName = string;
        this.m_aSchemaFactory = schemaFactory;
        this.m_aSchemaFactory.setErrorHandler(errorHandler);
        this.m_aSchemaFactory.setResourceResolver(lSResourceResolver);
    }

    public final @NonNull String getSchemaTypeName() {
        return this.m_sSchemaTypeName;
    }

    public final @NonNull SchemaFactory getSchemaFactory() {
        return this.m_aSchemaFactory;
    }

    public @Nullable ErrorHandler getErrorHandler() {
        return this.m_aSchemaFactory.getErrorHandler();
    }

    public @Nullable LSResourceResolver getResourceResolver() {
        return this.m_aSchemaFactory.getResourceResolver();
    }

    public static @NonNull Schema createSchema(@NonNull SchemaFactory schemaFactory, @NonNull String string, @NonNull @Nonempty ICommonsList<? extends IReadableResource> iCommonsList) {
        ValueEnforcer.notNull((Object)schemaFactory, (String)"SchemaFactory");
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"Resources");
        Source[] sourceArray = new Source[iCommonsList.size()];
        for (int i = 0; i < iCommonsList.size(); ++i) {
            sourceArray[i] = TransformSourceFactory.create((IReadableResource)iCommonsList.get(i));
        }
        try {
            Schema schema = schemaFactory.newSchema(sourceArray);
            if (schema == null) {
                throw new IllegalStateException("Failed to create " + string + " schema from " + iCommonsList.toString());
            }
            return schema;
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("Failed to parse " + string + " from " + iCommonsList.toString(), sAXException);
        }
    }

    public final @NonNull Schema getSchema(@NonNull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        return (Schema)this.getFromCache(new CommonsArrayList((Object)iReadableResource));
    }

    public final @NonNull Schema getSchema(IReadableResource ... iReadableResourceArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iReadableResourceArray, (String)"Resources");
        return (Schema)this.getFromCache(new CommonsArrayList((Object[])iReadableResourceArray));
    }

    public final @NonNull Schema getSchema(@NonNull @Nonempty Collection<? extends IReadableResource> collection) {
        ValueEnforcer.notEmptyNoNullValue(collection, (String)"Resources");
        return (Schema)this.getFromCache(new CommonsArrayList(collection));
    }

    public final @NonNull Validator getValidatorFromSchema(@NonNull Schema schema) {
        ValueEnforcer.notNull((Object)schema, (String)"Schema");
        Validator validator = schema.newValidator();
        validator.setErrorHandler(this.m_aSchemaFactory.getErrorHandler());
        return validator;
    }

    public final @NonNull Validator getValidator(@NonNull IReadableResource iReadableResource) {
        return this.getValidatorFromSchema(this.getSchema(iReadableResource));
    }

    public final @NonNull Validator getValidator(IReadableResource ... iReadableResourceArray) {
        return this.getValidatorFromSchema(this.getSchema(iReadableResourceArray));
    }

    public final @NonNull Validator getValidator(@NonNull @Nonempty Collection<? extends IReadableResource> collection) {
        return this.getValidatorFromSchema(this.getSchema(collection));
    }

    public @NonNull EChange removeFromCache(@NonNull IReadableResource iReadableResource) {
        return this.removeFromCache(new CommonsArrayList((Object)iReadableResource));
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("schemaTypeName", (Object)this.m_sSchemaTypeName).getToString();
    }
}

