/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.stream.ByteBufferInputStream;
import com.helger.base.url.URLHelper;
import com.helger.io.file.FileHelper;
import com.helger.io.resource.FileSystemResource;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.URLResource;
import com.helger.xml.sax.ReadableResourceSAXInputSource;
import com.helger.xml.sax.StringSAXInputSource;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.xml.sax.InputSource;

@Immutable
public final class InputSourceFactory {
    private static final InputSourceFactory INSTANCE = new InputSourceFactory();

    private InputSourceFactory() {
    }

    public static @Nullable InputSource create(@NonNull File file) {
        return InputSourceFactory.create((IReadableResource)new FileSystemResource(file));
    }

    public static @Nullable InputSource create(@NonNull Path path) {
        return InputSourceFactory.create((IReadableResource)new FileSystemResource(path));
    }

    public static @NonNull InputSource create(@NonNull URI uRI) {
        return InputSourceFactory.create(URLHelper.getAsURL((URI)uRI));
    }

    public static @NonNull InputSource create(@NonNull URL uRL) {
        return InputSourceFactory.create((IReadableResource)new URLResource(uRL));
    }

    public static @Nullable InputSource create(@NonNull IHasInputStream iHasInputStream) {
        if (iHasInputStream instanceof IReadableResource) {
            IReadableResource iReadableResource = (IReadableResource)iHasInputStream;
            return InputSourceFactory.create(iReadableResource);
        }
        return InputSourceFactory.create(iHasInputStream.getInputStream());
    }

    public static @Nullable InputSource create(@NonNull IReadableResource iReadableResource) {
        File file;
        if (iReadableResource instanceof FileSystemResource && (file = iReadableResource.getAsFile()) != null) {
            URL uRL;
            InputSource inputSource = InputSourceFactory.create((InputStream)FileHelper.getBufferedInputStream((File)file));
            if (inputSource != null && (uRL = iReadableResource.getAsURL()) != null) {
                inputSource.setSystemId(uRL.toExternalForm());
            }
            return inputSource;
        }
        return new ReadableResourceSAXInputSource(iReadableResource);
    }

    public static @NonNull InputSource create(@NonNull CharSequence charSequence) {
        return new StringSAXInputSource(charSequence);
    }

    public static @NonNull InputSource create(@NonNull String string) {
        return new StringSAXInputSource(string);
    }

    public static @NonNull InputSource create(char @NonNull [] cArray) {
        return new StringSAXInputSource(cArray);
    }

    public static @NonNull InputSource create(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return new StringSAXInputSource(cArray, n, n2);
    }

    public static @NonNull InputSource create(byte @NonNull [] byArray) {
        return InputSourceFactory.create((InputStream)new NonBlockingByteArrayInputStream(byArray));
    }

    public static @NonNull InputSource create(byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return InputSourceFactory.create((InputStream)new NonBlockingByteArrayInputStream(byArray, n, n2));
    }

    public static @NonNull InputSource create(@NonNull ByteBuffer byteBuffer) {
        return InputSourceFactory.create((InputStream)new ByteBufferInputStream(byteBuffer));
    }

    public static @Nullable InputSource create(@Nullable InputStream inputStream) {
        return inputStream == null ? null : new InputSource(inputStream);
    }

    public static @Nullable InputSource create(@Nullable Reader reader) {
        return reader == null ? null : new InputSource(reader);
    }
}

