/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHex;
import com.helger.base.system.ENewLineMode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.xml.EXMLVersion;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeComments;
import com.helger.xml.serialize.write.EXMLSerializeDocType;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.EXMLSerializeVersion;
import com.helger.xml.serialize.write.EXMLSerializeXMLDeclaration;
import com.helger.xml.serialize.write.IXMLBracketModeDeterminator;
import com.helger.xml.serialize.write.IXMLIndentDeterminator;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLBracketModeDeterminatorHTML4;
import com.helger.xml.serialize.write.XMLBracketModeDeterminatorHTML5;
import com.helger.xml.serialize.write.XMLBracketModeDeterminatorXML;
import com.helger.xml.serialize.write.XMLBracketModeDeterminatorXMLC14;
import com.helger.xml.serialize.write.XMLIndentDeterminatorHTML;
import com.helger.xml.serialize.write.XMLIndentDeterminatorXML;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.namespace.NamespaceContext;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class XMLWriterSettings
implements IXMLWriterSettings,
ICloneable<XMLWriterSettings> {
    public static final EXMLSerializeVersion DEFAULT_XML_SERIALIZE_VERSION = EXMLSerializeVersion.XML_10;
    public static final EXMLSerializeXMLDeclaration DEFAULT_SERIALIZE_XML_DECLARATION = EXMLSerializeXMLDeclaration.EMIT;
    public static final boolean DEFAULT_NEW_LINE_AFTER_XML_DECLARATION = true;
    public static final EXMLSerializeDocType DEFAULT_SERIALIZE_DOC_TYPE = EXMLSerializeDocType.EMIT;
    public static final EXMLSerializeComments DEFAULT_SERIALIZE_COMMENTS = EXMLSerializeComments.EMIT;
    public static final EXMLSerializeIndent DEFAULT_SERIALIZE_INDENT = EXMLSerializeIndent.INDENT_AND_ALIGN;
    public static final EXMLIncorrectCharacterHandling DEFAULT_INCORRECT_CHARACTER_HANDLING = EXMLIncorrectCharacterHandling.DO_NOT_WRITE_LOG_WARNING;
    public static final Charset DEFAULT_XML_CHARSET_OBJ = StandardCharsets.UTF_8;
    public static final String DEFAULT_XML_CHARSET = DEFAULT_XML_CHARSET_OBJ.name();
    public static final boolean DEFAULT_USE_DOUBLE_QUOTES_FOR_ATTRIBUTES = true;
    public static final boolean DEFAULT_SPACE_ON_SELF_CLOSED_ELEMENT = true;
    public static final String DEFAULT_INDENTATION_STRING = "  ";
    public static final boolean DEFAULT_EMIT_NAMESPACES = true;
    public static final boolean DEFAULT_PUT_NAMESPACE_CONTEXT_PREFIXES_IN_ROOT = false;
    public static final boolean DEFAULT_WRITE_CDATA_AS_TEXT = false;
    public static final boolean DEFAULT_ORDER_ATTRIBUTES_AND_NAMESPACES = false;
    public static final IXMLWriterSettings DEFAULT_XML_SETTINGS = new XMLWriterSettings();
    private EXMLSerializeVersion m_eSerializeVersion = DEFAULT_XML_SERIALIZE_VERSION;
    private EXMLSerializeXMLDeclaration m_eSerializeXMLDecl = DEFAULT_SERIALIZE_XML_DECLARATION;
    private boolean m_bNewLineAfterXMLDeclaration = true;
    private EXMLSerializeDocType m_eSerializeDocType = DEFAULT_SERIALIZE_DOC_TYPE;
    private EXMLSerializeComments m_eSerializeComments = DEFAULT_SERIALIZE_COMMENTS;
    private EXMLSerializeIndent m_eIndent = DEFAULT_SERIALIZE_INDENT;
    private IXMLIndentDeterminator m_aIndentDeterminator = new XMLIndentDeterminatorXML();
    private EXMLIncorrectCharacterHandling m_eIncorrectCharacterHandling = DEFAULT_INCORRECT_CHARACTER_HANDLING;
    private Charset m_aCharset = DEFAULT_XML_CHARSET_OBJ;
    private NamespaceContext m_aNamespaceContext = new MapBasedNamespaceContext();
    private boolean m_bUseDoubleQuotesForAttributes = true;
    private IXMLBracketModeDeterminator m_aBracketModeDeterminator = new XMLBracketModeDeterminatorXML();
    private boolean m_bSpaceOnSelfClosedElement = true;
    private ENewLineMode m_eNewLineMode = ENewLineMode.DEFAULT;
    private String m_sIndentationString = "  ";
    private boolean m_bEmitNamespaces = true;
    private boolean m_bPutNamespaceContextPrefixesInRoot = false;
    private boolean m_bWriteCDATAAsText = false;
    private boolean m_bOrderAttributesAndNamespaces = false;
    private String m_sIndentationStringToString;

    public XMLWriterSettings() {
    }

    public XMLWriterSettings(@NonNull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Other");
        this.setSerializeVersion(iXMLWriterSettings.getSerializeVersion());
        this.setSerializeXMLDeclaration(iXMLWriterSettings.getSerializeXMLDeclaration());
        this.setNewLineAfterXMLDeclaration(iXMLWriterSettings.isNewLineAfterXMLDeclaration());
        this.setSerializeDocType(iXMLWriterSettings.getSerializeDocType());
        this.setSerializeComments(iXMLWriterSettings.getSerializeComments());
        this.setIndent(iXMLWriterSettings.getIndent());
        this.setIndentDeterminator(iXMLWriterSettings.getIndentDeterminator());
        this.setIncorrectCharacterHandling(iXMLWriterSettings.getIncorrectCharacterHandling());
        this.setCharset(iXMLWriterSettings.getCharset());
        this.setNamespaceContext(iXMLWriterSettings.getNamespaceContext());
        this.setBracketModeDeterminator(iXMLWriterSettings.getBracketModeDeterminator());
        this.setUseDoubleQuotesForAttributes(iXMLWriterSettings.isUseDoubleQuotesForAttributes());
        this.setSpaceOnSelfClosedElement(iXMLWriterSettings.isSpaceOnSelfClosedElement());
        this.setNewLineMode(iXMLWriterSettings.getNewLineMode());
        this.setIndentationString(iXMLWriterSettings.getIndentationString());
        this.setEmitNamespaces(iXMLWriterSettings.isEmitNamespaces());
        this.setPutNamespaceContextPrefixesInRoot(iXMLWriterSettings.isPutNamespaceContextPrefixesInRoot());
        this.setWriteCDATAAsText(iXMLWriterSettings.isWriteCDATAAsText());
        this.setOrderAttributesAndNamespaces(iXMLWriterSettings.isOrderAttributesAndNamespaces());
    }

    @Override
    public @NonNull EXMLVersion getXMLVersion() {
        return this.m_eSerializeVersion.getXMLVersionOrDefault(EXMLVersion.XML_10);
    }

    @Override
    public @NonNull EXMLSerializeVersion getSerializeVersion() {
        return this.m_eSerializeVersion;
    }

    public final @NonNull XMLWriterSettings setSerializeVersion(@NonNull EXMLSerializeVersion eXMLSerializeVersion) {
        this.m_eSerializeVersion = (EXMLSerializeVersion)((Object)ValueEnforcer.notNull((Object)((Object)eXMLSerializeVersion), (String)"Version"));
        return this;
    }

    @Override
    public @NonNull EXMLSerializeXMLDeclaration getSerializeXMLDeclaration() {
        return this.m_eSerializeXMLDecl;
    }

    public final @NonNull XMLWriterSettings setSerializeXMLDeclaration(@NonNull EXMLSerializeXMLDeclaration eXMLSerializeXMLDeclaration) {
        this.m_eSerializeXMLDecl = (EXMLSerializeXMLDeclaration)((Object)ValueEnforcer.notNull((Object)((Object)eXMLSerializeXMLDeclaration), (String)"SerializeXMLDecl"));
        return this;
    }

    @Override
    public boolean isNewLineAfterXMLDeclaration() {
        return this.m_bNewLineAfterXMLDeclaration;
    }

    public final @NonNull XMLWriterSettings setNewLineAfterXMLDeclaration(boolean bl) {
        this.m_bNewLineAfterXMLDeclaration = bl;
        return this;
    }

    @Override
    public @NonNull EXMLSerializeDocType getSerializeDocType() {
        return this.m_eSerializeDocType;
    }

    public final @NonNull XMLWriterSettings setSerializeDocType(@NonNull EXMLSerializeDocType eXMLSerializeDocType) {
        this.m_eSerializeDocType = (EXMLSerializeDocType)((Object)ValueEnforcer.notNull((Object)((Object)eXMLSerializeDocType), (String)"SerializeDocType"));
        return this;
    }

    @Override
    public @NonNull EXMLSerializeComments getSerializeComments() {
        return this.m_eSerializeComments;
    }

    public final @NonNull XMLWriterSettings setSerializeComments(@NonNull EXMLSerializeComments eXMLSerializeComments) {
        this.m_eSerializeComments = (EXMLSerializeComments)((Object)ValueEnforcer.notNull((Object)((Object)eXMLSerializeComments), (String)"SerializeComments"));
        return this;
    }

    @Override
    public @NonNull EXMLSerializeIndent getIndent() {
        return this.m_eIndent;
    }

    public final @NonNull XMLWriterSettings setIndent(@NonNull EXMLSerializeIndent eXMLSerializeIndent) {
        this.m_eIndent = (EXMLSerializeIndent)((Object)ValueEnforcer.notNull((Object)((Object)eXMLSerializeIndent), (String)"Indent"));
        return this;
    }

    @Override
    public @NonNull IXMLIndentDeterminator getIndentDeterminator() {
        return this.m_aIndentDeterminator;
    }

    public final @NonNull XMLWriterSettings setIndentDeterminator(@NonNull IXMLIndentDeterminator iXMLIndentDeterminator) {
        this.m_aIndentDeterminator = (IXMLIndentDeterminator)ValueEnforcer.notNull((Object)iXMLIndentDeterminator, (String)"IndentDeterminator");
        return this;
    }

    @Override
    public @NonNull EXMLIncorrectCharacterHandling getIncorrectCharacterHandling() {
        return this.m_eIncorrectCharacterHandling;
    }

    public final @NonNull XMLWriterSettings setIncorrectCharacterHandling(@NonNull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling) {
        this.m_eIncorrectCharacterHandling = (EXMLIncorrectCharacterHandling)((Object)ValueEnforcer.notNull((Object)((Object)eXMLIncorrectCharacterHandling), (String)"IncorrectCharacterHandling"));
        return this;
    }

    @Override
    public @NonNull Charset getCharset() {
        return this.m_aCharset;
    }

    public final @NonNull XMLWriterSettings setCharset(@NonNull Charset charset) {
        this.m_aCharset = (Charset)ValueEnforcer.notNull((Object)charset, (String)"Charset");
        return this;
    }

    @Override
    public @NonNull NamespaceContext getNamespaceContext() {
        return this.m_aNamespaceContext;
    }

    public final @NonNull XMLWriterSettings setNamespaceContext(@Nullable NamespaceContext namespaceContext) {
        this.m_aNamespaceContext = namespaceContext != null ? namespaceContext : new MapBasedNamespaceContext();
        return this;
    }

    @Override
    public boolean isUseDoubleQuotesForAttributes() {
        return this.m_bUseDoubleQuotesForAttributes;
    }

    public final @NonNull XMLWriterSettings setUseDoubleQuotesForAttributes(boolean bl) {
        this.m_bUseDoubleQuotesForAttributes = bl;
        return this;
    }

    @Override
    public @NonNull IXMLBracketModeDeterminator getBracketModeDeterminator() {
        return this.m_aBracketModeDeterminator;
    }

    public final @NonNull XMLWriterSettings setBracketModeDeterminator(@NonNull IXMLBracketModeDeterminator iXMLBracketModeDeterminator) {
        ValueEnforcer.notNull((Object)iXMLBracketModeDeterminator, (String)"BracketModeDeterminator");
        this.m_aBracketModeDeterminator = iXMLBracketModeDeterminator;
        return this;
    }

    @Override
    public boolean isSpaceOnSelfClosedElement() {
        return this.m_bSpaceOnSelfClosedElement;
    }

    public final @NonNull XMLWriterSettings setSpaceOnSelfClosedElement(boolean bl) {
        this.m_bSpaceOnSelfClosedElement = bl;
        return this;
    }

    @Override
    public @NonNull ENewLineMode getNewLineMode() {
        return this.m_eNewLineMode;
    }

    public final @NonNull XMLWriterSettings setNewLineMode(@NonNull ENewLineMode eNewLineMode) {
        this.m_eNewLineMode = (ENewLineMode)ValueEnforcer.notNull((Object)eNewLineMode, (String)"NewLineMode");
        return this;
    }

    @Override
    @Nonempty
    public @NonNull String getIndentationString() {
        return this.m_sIndentationString;
    }

    public final @NonNull XMLWriterSettings setIndentationString(@Nonempty @NonNull String string) {
        this.m_sIndentationString = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"IndentationString");
        this.m_sIndentationStringToString = null;
        return this;
    }

    @Override
    public boolean isEmitNamespaces() {
        return this.m_bEmitNamespaces;
    }

    public final @NonNull XMLWriterSettings setEmitNamespaces(boolean bl) {
        this.m_bEmitNamespaces = bl;
        return this;
    }

    @Override
    public boolean isPutNamespaceContextPrefixesInRoot() {
        return this.m_bPutNamespaceContextPrefixesInRoot;
    }

    public final @NonNull XMLWriterSettings setPutNamespaceContextPrefixesInRoot(boolean bl) {
        this.m_bPutNamespaceContextPrefixesInRoot = bl;
        return this;
    }

    @Override
    public boolean isWriteCDATAAsText() {
        return this.m_bWriteCDATAAsText;
    }

    public final @NonNull XMLWriterSettings setWriteCDATAAsText(boolean bl) {
        this.m_bWriteCDATAAsText = bl;
        return this;
    }

    @Override
    public boolean isOrderAttributesAndNamespaces() {
        return this.m_bOrderAttributesAndNamespaces;
    }

    public final @NonNull XMLWriterSettings setOrderAttributesAndNamespaces(boolean bl) {
        this.m_bOrderAttributesAndNamespaces = bl;
        return this;
    }

    public @NonNull XMLWriterSettings getClone() {
        return new XMLWriterSettings(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        XMLWriterSettings xMLWriterSettings = (XMLWriterSettings)object;
        NamespaceContext namespaceContext = this.m_aNamespaceContext;
        return this.m_eSerializeVersion.equals((Object)xMLWriterSettings.m_eSerializeVersion) && this.m_eSerializeXMLDecl.equals((Object)xMLWriterSettings.m_eSerializeXMLDecl) && this.m_bNewLineAfterXMLDeclaration == xMLWriterSettings.m_bNewLineAfterXMLDeclaration && this.m_eSerializeDocType.equals((Object)xMLWriterSettings.m_eSerializeDocType) && this.m_eSerializeComments.equals((Object)xMLWriterSettings.m_eSerializeComments) && this.m_eIndent.equals((Object)xMLWriterSettings.m_eIndent) && this.m_aIndentDeterminator.equals(xMLWriterSettings.m_aIndentDeterminator) && this.m_eIncorrectCharacterHandling.equals((Object)xMLWriterSettings.m_eIncorrectCharacterHandling) && this.m_aCharset.equals(xMLWriterSettings.m_aCharset) && EqualsHelper.equals((Object)namespaceContext, (Object)xMLWriterSettings.m_aNamespaceContext) && this.m_bUseDoubleQuotesForAttributes == xMLWriterSettings.m_bUseDoubleQuotesForAttributes && this.m_aBracketModeDeterminator.equals(xMLWriterSettings.m_aBracketModeDeterminator) && this.m_bSpaceOnSelfClosedElement == xMLWriterSettings.m_bSpaceOnSelfClosedElement && this.m_eNewLineMode.equals((Object)xMLWriterSettings.m_eNewLineMode) && this.m_sIndentationString.equals(xMLWriterSettings.m_sIndentationString) && this.m_bEmitNamespaces == xMLWriterSettings.m_bEmitNamespaces && this.m_bPutNamespaceContextPrefixesInRoot == xMLWriterSettings.m_bPutNamespaceContextPrefixesInRoot && this.m_bWriteCDATAAsText == xMLWriterSettings.m_bWriteCDATAAsText && this.m_bOrderAttributesAndNamespaces == xMLWriterSettings.m_bOrderAttributesAndNamespaces;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_eSerializeVersion).append((Object)this.m_eSerializeXMLDecl).append(this.m_bNewLineAfterXMLDeclaration).append((Object)this.m_eSerializeDocType).append((Object)this.m_eSerializeComments).append((Object)this.m_eIndent).append((Object)this.m_aIndentDeterminator).append((Object)this.m_eIncorrectCharacterHandling).append((Object)this.m_aCharset).append((Object)this.m_aNamespaceContext).append(this.m_bUseDoubleQuotesForAttributes).append((Object)this.m_aBracketModeDeterminator).append(this.m_bSpaceOnSelfClosedElement).append((Object)this.m_eNewLineMode).append((Object)this.m_sIndentationString).append(this.m_bEmitNamespaces).append(this.m_bPutNamespaceContextPrefixesInRoot).append(this.m_bWriteCDATAAsText).append(this.m_bOrderAttributesAndNamespaces).getHashCode();
    }

    public String toString() {
        if (this.m_sIndentationStringToString == null) {
            this.m_sIndentationStringToString = StringHex.getHexEncoded((byte[])this.m_sIndentationString.getBytes(StandardCharsets.ISO_8859_1));
        }
        return new ToStringGenerator((Object)this).append("SerializeVersion", (Enum)this.m_eSerializeVersion).append("SerializeXMLDecl", (Enum)this.m_eSerializeXMLDecl).append("NewLineAfterXMLDeclaration", this.m_bNewLineAfterXMLDeclaration).append("SerializeDocType", (Enum)this.m_eSerializeDocType).append("SerializeComments", (Enum)this.m_eSerializeComments).append("Indent", (Enum)this.m_eIndent).append("IndentDeterminator", (Object)this.m_aIndentDeterminator).append("IncorrectCharHandling", (Enum)this.m_eIncorrectCharacterHandling).append("Charset", (Object)this.m_aCharset).append("NamespaceContext", (Object)this.m_aNamespaceContext).append("DoubleQuotesForAttrs", this.m_bUseDoubleQuotesForAttributes).append("BracketModeDeterminator", (Object)this.m_aBracketModeDeterminator).append("SpaceOnSelfClosedElement", this.m_bSpaceOnSelfClosedElement).append("NewlineMode", (Enum)this.m_eNewLineMode).append("IndentationString", (Object)this.m_sIndentationStringToString).append("EmitNamespaces", this.m_bEmitNamespaces).append("PutNamespaceContextPrefixesInRoot", this.m_bPutNamespaceContextPrefixesInRoot).append("WriteCDATAAsText", this.m_bWriteCDATAAsText).append("OrderAttributesAndNamespaces", this.m_bOrderAttributesAndNamespaces).getToString();
    }

    @ReturnsMutableCopy
    public static @NonNull XMLWriterSettings createForHTML4() {
        return new XMLWriterSettings().setSerializeVersion(EXMLSerializeVersion.HTML).setSerializeXMLDeclaration(EXMLSerializeXMLDeclaration.IGNORE).setIndentDeterminator(new XMLIndentDeterminatorHTML()).setBracketModeDeterminator(new XMLBracketModeDeterminatorHTML4()).setSpaceOnSelfClosedElement(true).setPutNamespaceContextPrefixesInRoot(true);
    }

    @ReturnsMutableCopy
    public static @NonNull XMLWriterSettings createForXHTML() {
        return new XMLWriterSettings().setSerializeVersion(EXMLSerializeVersion.HTML).setSerializeXMLDeclaration(EXMLSerializeXMLDeclaration.IGNORE).setIndentDeterminator(new XMLIndentDeterminatorHTML()).setBracketModeDeterminator(new XMLBracketModeDeterminatorXML()).setSpaceOnSelfClosedElement(true).setPutNamespaceContextPrefixesInRoot(true);
    }

    @ReturnsMutableCopy
    public static @NonNull XMLWriterSettings createForHTML5() {
        return new XMLWriterSettings().setSerializeVersion(EXMLSerializeVersion.HTML).setSerializeXMLDeclaration(EXMLSerializeXMLDeclaration.IGNORE).setIndentDeterminator(new XMLIndentDeterminatorHTML()).setBracketModeDeterminator(new XMLBracketModeDeterminatorHTML5()).setSpaceOnSelfClosedElement(true).setPutNamespaceContextPrefixesInRoot(true);
    }

    @ReturnsMutableCopy
    public static @NonNull XMLWriterSettings createForCanonicalization() {
        return new XMLWriterSettings().setSerializeVersion(EXMLSerializeVersion.XML_10).setSerializeXMLDeclaration(EXMLSerializeXMLDeclaration.IGNORE).setSerializeDocType(EXMLSerializeDocType.IGNORE).setCharset(StandardCharsets.UTF_8).setNewLineMode(ENewLineMode.UNIX).setUseDoubleQuotesForAttributes(true).setBracketModeDeterminator(new XMLBracketModeDeterminatorXMLC14()).setWriteCDATAAsText(true).setOrderAttributesAndNamespaces(true);
    }
}

